/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.selector;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.i18n.Translatrix;

public class DicomTagTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.TagName"), Translatrix.getTranslationString((String)"dicom.TagValue")};
    private Vector tags = new Vector();

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            if (rowIndex <= -1) {
                return;
            }
            HeaderTag dr = (HeaderTag)this.tags.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    try {
                        dr.setTagNr((String)aValue);
                        break;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                case 1: {
                    dr.setTagValue((String)aValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex <= -1) {
                return null;
            }
            HeaderTag dr = (HeaderTag)this.tags.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    try {
                        return dr.getTagNr();
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
                case 1: {
                    return dr.getTagValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTags(Vector tags) {
        this.tags = tags;
        this.fireTableDataChanged();
    }

    public void addTag(HeaderTag tag) {
        this.tags.add(tag);
        this.fireTableDataChanged();
    }

    public HeaderTag getTag(int line) {
        try {
            return (HeaderTag)this.tags.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    public HeaderTag[] getTags() {
        try {
            return this.tags.toArray(new HeaderTag[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void removeTag(int row) {
        this.tags.remove(row);
        this.fireTableDataChanged();
    }

    public Vector getTagsVector() {
        return this.tags;
    }
}

