/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.selector;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.selector.DicomFile;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;

public class DicomMatcher {
    private static Logger logger = Logger.getLogger((String)DicomMatcher.class.getName());
    private HeaderTag[] headerTags;
    private Component parent;
    private ProgressMonitor progressMonitor;
    private String lastMessage;

    public DicomMatcher(Component parent) {
        this.parent = parent;
    }

    public void setHeaderTags(HeaderTag[] tags) {
        this.headerTags = tags;
        logger.info((Object)("Setting Filter Tags: " + Arrays.toString(this.headerTags)));
    }

    public void setHeaderTags(List<HeaderTag> tags) {
        this.setHeaderTags(tags.toArray(new HeaderTag[0]));
    }

    public Vector findMachingFiles(File dir) {
        ArrayList al = new ArrayList();
        DicomMatcher.visitAllFiles(dir, al);
        Vector<DicomFile> matches = new Vector<DicomFile>();
        if (this.parent != null) {
            this.progressMonitor = new ProgressMonitor(this.parent, Translatrix.getTranslationString((String)"dicom.searchingFiles"), "", 0, al.size());
        }
        int i = 0;
        while (i < al.size()) {
            if (this.parent != null && this.progressMonitor.isCanceled()) break;
            try {
                DicomFile dFile = new DicomFile((File)al.get(i));
                if (this.parent != null) {
                    this.progressMonitor.setNote("img " + dFile.getFile().getName() + " ( " + (i + 1) + " of " + (al.size() + 1) + " )");
                    this.progressMonitor.setProgress(i);
                }
                if (this.matchFile(dFile)) {
                    matches.add(dFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (this.parent != null) {
            this.progressMonitor.close();
        }
        return matches;
    }

    public boolean matchFile(DicomFile dfile) {
        try {
            logger.info((Object)("testing file: " + dfile.getFile()));
            DicomHeader dh = dfile.getDicomHeader();
            return this.matchFile(dh);
        }
        catch (Exception e) {
            logger.info((Object)("no DICOM file: " + dfile.getFile().getName()));
            return false;
        }
    }

    public boolean matchFile(DicomHeader dh) {
        if (this.headerTags == null) {
            this.lastMessage = "DicomMatcher: no filterTags set -> MATCH";
            logger.warn((Object)"no filterTags set -> MATCH");
            return true;
        }
        int i = 0;
        while (i < this.headerTags.length) {
            block9: {
                String tagValue;
                String tagNr;
                block8: {
                    block7: {
                        try {
                            tagNr = this.headerTags[i].getTagNr();
                            tagValue = this.headerTags[i].getTagValue();
                            if (dh.containsHeaderTag(tagNr)) break block7;
                            this.lastMessage = "DicomMatcher: image is missing tag: " + tagNr;
                            logger.info((Object)("missing tag: " + tagNr));
                            return false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    if (tagValue != null && !"".trim().equals(tagValue)) break block8;
                    logger.info((Object)"DICOM Matcher: Tag found, no check on Tagvalue.");
                    return true;
                }
                String isVal = dh.getHeaderStringValue(tagNr).trim();
                String shouldExpr = tagValue;
                logger.debug((Object)(String.valueOf(isVal) + " : " + shouldExpr));
                Pattern p = Pattern.compile(shouldExpr, 2);
                Matcher m = p.matcher(isVal);
                if (m.find()) {
                    this.lastMessage = "DicomMatcher: MATCH: " + tagNr + " is " + isVal;
                    logger.debug((Object)"  found!");
                    break block9;
                }
                this.lastMessage = "DicomMatcher: NOT MATCHING: " + tagNr + " is " + isVal;
                logger.debug((Object)"");
                return false;
            }
            ++i;
        }
        logger.info((Object)"DICOM Matcher: Full Match, returning true!");
        return true;
    }

    private static void visitAllFiles(File dir, ArrayList al) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                DicomMatcher.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public String getLastMessage() {
        return this.lastMessage;
    }
}

