/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che2.data.DicomObject;

public class QuerySeriesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.Nr"), Translatrix.getTranslationString((String)"dicom.Modality"), Translatrix.getTranslationString((String)"dicom.SeriesDesc"), Translatrix.getTranslationString((String)"dicom.SeriesUID"), Translatrix.getTranslationString((String)"dicom.Images")};
    private Vector series = new Vector();

    @Override
    public int getRowCount() {
        return this.series.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DicomObject dr = (DicomObject)this.series.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return dr.getString(0x200011);
            }
            case 1: {
                return dr.getString(524384);
            }
            case 2: {
                return dr.getString(528446);
            }
            case 3: {
                return dr.getString(0x20000E);
            }
            case 4: {
                return dr.getString(2101769);
            }
        }
        return null;
    }

    public void setSeries(Vector series) {
        this.series = series;
        Collections.sort(this.series, new Comparer());
        this.fireTableDataChanged();
    }

    public DicomObject getDimse(int line) {
        try {
            return (DicomObject)this.series.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    class Comparer
    implements Comparator {
        Comparer() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                DicomObject ds1 = (DicomObject)obj1;
                DicomObject ds2 = (DicomObject)obj2;
                return ds1.getInt(0x200011) - ds2.getInt(0x200011);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

