/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeaderParseException;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.query.FilterField;
import lu.tudor.santec.dicom.gui.query.QueryPanel;
import lu.tudor.santec.dicom.gui.query.QuerySearchPanel;
import lu.tudor.santec.dicom.query.DcmQR;
import lu.tudor.santec.i18n.Translatrix;

public class FilterPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String LINE_DELIM = "\n";
    public static final String FILTER_CHANGED = "FILTER_CHANGED";
    private List<HeaderTag> keys;
    private Vector<FilterField> filterFields = new Vector();
    private QueryPanel parentPanel;
    private JPanel filterPanel;
    private JComboBox levelBox;
    private JLabel levelLabel;
    private JButton reloadButton;
    private LinkedHashSet<String> operators = FilterField.OPERATORS;

    public FilterPanel(QueryPanel parent, String pacs) {
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, 4dlu, pref, 4dlu, pref, 2dlu, 30dlu, 2dlu, right:pref:grow, 4dlu", "2dlu, 20dlu, 2dlu"));
        this.levelLabel = new JLabel(Translatrix.getTranslationString((String)"dicom.QueryPacs", (String[])new String[]{pacs}));
        this.levelBox = new JComboBox();
        for (DcmQR.QueryRetrieveLevel level : QuerySearchPanel.getQueryLevels()) {
            this.levelBox.addItem(level);
        }
        this.levelBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterPanel.this.setKeys(QuerySearchPanel.getQueryFields((DcmQR.QueryRetrieveLevel)((Object)FilterPanel.this.levelBox.getSelectedItem())));
            }
        });
        this.reloadButton = new JButton(DicomIcons.getIcon("icon_search.png"));
        this.reloadButton.setToolTipText(Translatrix.getTranslationString((String)"dicom.refreshDICOMDIR"));
        this.reloadButton.addActionListener(this);
        buttonPanel.add((Component)this.levelLabel, cc.xy(2, 2));
        buttonPanel.add((Component)this.levelBox, cc.xy(4, 2));
        buttonPanel.add((Component)this.reloadButton, cc.xy(10, 2));
        this.add((Component)buttonPanel, "North");
        this.filterPanel = new JPanel(new GridLayout(0, 1));
        this.add((Component)this.filterPanel, "Center");
        this.setBorder(new TitledBorder(Translatrix.getTranslationString((String)"dicom.filter")));
        this.parentPanel = parent;
        this.addFilterPanel();
        this.setKeys(QuerySearchPanel.getQueryFields((DcmQR.QueryRetrieveLevel)((Object)this.levelBox.getSelectedItem())));
    }

    public void setKeys(List<HeaderTag> list) {
        this.keys = list;
        this.filterFields.clear();
        this.filterPanel.removeAll();
        this.addFilterPanel();
        this.parentPanel.validate();
        this.parentPanel.repaint();
    }

    public void setOperators(LinkedHashSet<String> operators) {
        this.operators = operators;
    }

    private void addFilterPanel() {
        FilterField fp = new FilterField(this, this.filterFields.size() == 0);
        fp.setKeys(this.keys);
        fp.addPropertyChangeListener(this);
        this.filterPanel.add(fp);
        this.filterFields.add(fp);
    }

    public void addItem(FilterField filterField) {
        this.addFilterPanel();
        this.parentPanel.validate();
        this.parentPanel.repaint();
    }

    public void removeItem(FilterField filterField) {
        this.filterPanel.remove(filterField);
        this.filterFields.remove(filterField);
        this.parentPanel.validate();
        this.parentPanel.repaint();
    }

    public String getFilter() {
        StringBuffer sb = new StringBuffer();
        for (FilterField field : this.filterFields) {
            sb.append(field.getFilter()).append(LINE_DELIM);
        }
        return sb.toString();
    }

    public Vector<HeaderTag> getFilterTags() throws DicomHeaderParseException {
        Vector<HeaderTag> tags = new Vector<HeaderTag>();
        for (FilterField field : this.filterFields) {
            tags.add(field.getFilterTag());
        }
        return tags;
    }

    public void setFilter(String filter) {
        String[] strings = filter.split(LINE_DELIM);
        this.filterFields.clear();
        this.filterPanel.removeAll();
        int i = 0;
        while (i < strings.length) {
            this.addFilterPanel();
            this.filterFields.get(i).setFilter(strings[i]);
            ++i;
        }
        this.validate();
    }

    public String printFilter() {
        return FilterPanel.printFilter(this.getFilter());
    }

    public static String printFilter(String filter) {
        String[] strings;
        StringBuffer sb = new StringBuffer();
        String[] stringArray = strings = filter.split(LINE_DELIM);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String filterLine = stringArray[n2];
            sb.append(FilterField.printFilter(filterLine)).append(LINE_DELIM);
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.reloadButton)) {
            try {
                Vector<HeaderTag> tags = this.getFilterTags();
                this.parentPanel.queryPanel.query(tags, (DcmQR.QueryRetrieveLevel)((Object)this.levelBox.getSelectedItem()));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

