/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header.selector;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.MemoryMonitorButton;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderTableModel;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.header.filter.TagFilterDialog;
import lu.tudor.santec.dicom.gui.header.selector.DCMResultDialog;
import lu.tudor.santec.dicom.gui.header.selector.HeaderDataExtractor;
import lu.tudor.santec.dicom.gui.header.selector.dnd.DicomHeaderTableDropTargetListener;
import lu.tudor.santec.dicom.gui.header.selector.dnd.HeaderTagTransferHandler;
import lu.tudor.santec.dicom.gui.viewer.Viewer;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;

public class HeaderdataEvaluator
extends JDialog
implements ListSelectionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DicomHeaderTableModel tagTableModel;
    private JTable tagTable;
    private DicomHeaderTableModel selectedTableModel;
    private JTable selectedTable;
    private JTextField nrFilter;
    private JTextField nameFilter;
    private JScrollPane jsp;
    private JButton closeButton;
    private JButton runButton;
    private JButton loadFilesButton;
    private JTextField openField;
    private HeaderDataExtractor headerDataExtractor;
    private DicomFileDialog dicomChooser;
    private DCMResultDialog dcmResultDialog;
    private DicomHeaderTableModel filterTableModel;
    private JTable filterTable;
    private JButton addFilterButton;
    private JButton deleteFilterButton;
    private TagFilterDialog tagFilterDialog;
    private JButton editFilterButton;
    private int rowFrom;
    private int rowTo;
    private JButton loadTemplateFile;
    private JButton loadAllTags;
    private Vector<HeaderTag> usedTags;
    private Vector<HeaderTag> filterTags;
    private JButton saveConfig;
    private JButton loadConfig;
    private JFileChooser fileChooser;
    private File[] files;
    private Properties properties = new Properties();
    public Viewer dicomViewer;
    private JPopupMenu popup;
    private MouseEvent event;
    private JToggleButton saveToFile;
    public static final String FILENAME = "HeaderdataEvaluator.zip";
    private static final Object IMAGE_PATH = "IMAGE_PATH";

    public HeaderdataEvaluator(JFrame parent, DicomFileDialog dicomChooser) {
        super(parent);
        this.initDialog(dicomChooser);
        this.setLocationRelativeTo(parent);
    }

    public HeaderdataEvaluator(JDialog parent, DicomFileDialog dicomChooser) {
        super(parent);
        this.initDialog(dicomChooser);
        this.setLocationRelativeTo(parent);
    }

    private void initDialog(DicomFileDialog dicomChooser) {
        this.dicomChooser = dicomChooser;
        if (this.dicomChooser == null) {
            this.dicomChooser = DicomFileDialog.getDicomFileDialog();
        }
        this.fileChooser = new JFileChooser();
        this.setTitle(Translatrix.getTranslationString((String)"TagSelectorDialog.title"));
        this.setLayout((LayoutManager)new FormLayout("fill:200dlu:grow, 5dlu, fill:250dlu:grow", "pref, 3dlu, pref, 3dlu, fill:150dlu:grow, 3dlu, pref, 3dlu, fill:150dlu:grow, 3dlu, pref"));
        CellConstraints cc = new CellConstraints();
        this.tagFilterDialog = new TagFilterDialog(this, this.dicomChooser);
        JPanel selectFilesPanel = new JPanel((LayoutManager)new FormLayout("pref,pref:grow,pref,pref", "2dlu, fill:pref, 2dlu"));
        selectFilesPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectFilesPanel.setBackground(new Color(200, 255, 200));
        selectFilesPanel.add((Component)new JLabel(Translatrix.getTranslationString((String)"TagSelectorDialog.selectFiles")), cc.xy(1, 2));
        this.openField = new JTextField(40);
        this.openField.setEditable(false);
        this.openField.setOpaque(false);
        selectFilesPanel.add((Component)this.openField, cc.xy(2, 2));
        this.loadFilesButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.open"), DicomIcons.getIcon22("open.png"));
        this.loadFilesButton.addActionListener(this);
        selectFilesPanel.add((Component)this.loadFilesButton, cc.xy(3, 2));
        selectFilesPanel.add((Component)new MemoryMonitorButton(true, true), cc.xy(4, 2));
        this.add((Component)selectFilesPanel, cc.xyw(1, 1, 3));
        this.tagTableModel = new DicomHeaderTableModel(HeaderTag.getAllTags(), false, false);
        this.tagTable = new JTable(this.tagTableModel);
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
        this.tagTable.getSelectionModel().addListSelectionListener(this);
        this.tagTable.addMouseListener(this);
        this.tagTable.getSelectionModel().setSelectionMode(2);
        this.tagTable.setDragEnabled(true);
        this.tagTable.setTransferHandler(new HeaderTagTransferHandler(this.tagTableModel));
        JPanel searchPanel = new JPanel((LayoutManager)new FormLayout("200px, 3dlu, 200px:grow", "pref"));
        this.nrFilter = new JTextField();
        searchPanel.add((Component)this.nrFilter, cc.xy(1, 1));
        this.nameFilter = new JTextField();
        searchPanel.add((Component)this.nameFilter, cc.xy(3, 1));
        KeyAdapter filterListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HeaderdataEvaluator.this.filterTable();
            }
        };
        this.nrFilter.addKeyListener(filterListener);
        this.nameFilter.addKeyListener(filterListener);
        this.add((Component)searchPanel, cc.xy(1, 3));
        this.jsp = new JScrollPane(this.tagTable);
        this.jsp.setOpaque(false);
        this.jsp.getViewport().setOpaque(false);
        this.add((Component)this.jsp, cc.xywh(1, 5, 1, 5));
        this.add((Component)new JLabel(Translatrix.getTranslationString((String)"TagSelectorDialog.selectedTags"), DicomIcons.getIcon22("search.png"), 2), cc.xy(3, 3));
        this.selectedTableModel = new DicomHeaderTableModel(null, false, true);
        this.selectedTable = new JTable(this.selectedTableModel);
        this.selectedTable.getColumnModel().getColumn(0).setMaxWidth(this.selectedTableModel.getColumnSize(0));
        this.selectedTable.getSelectionModel().addListSelectionListener(this);
        this.selectedTable.addMouseListener(this);
        this.selectedTable.getSelectionModel().setSelectionMode(1);
        JScrollPane selectedScrollPane = new JScrollPane(this.selectedTable);
        selectedScrollPane.setOpaque(false);
        selectedScrollPane.getViewport().setOpaque(false);
        this.add((Component)selectedScrollPane, cc.xy(3, 5));
        DicomHeaderTableDropTargetListener selectedDropListener = new DicomHeaderTableDropTargetListener(this.selectedTable, this.selectedTableModel);
        new DropTarget(this.selectedTable, selectedDropListener);
        selectedScrollPane.setDropTarget(new DropTarget(selectedScrollPane, selectedDropListener));
        this.selectedTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                HeaderdataEvaluator.this.TableMouseDragged(evt);
            }
        });
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HeaderdataEvaluator.this.TableMousePressed(evt);
            }
        });
        this.selectedTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int[] rows = HeaderdataEvaluator.this.selectedTable.getSelectedRows();
                    HeaderTag[] hts = new HeaderTag[rows.length];
                    int i = 0;
                    while (i < rows.length) {
                        hts[i] = HeaderdataEvaluator.this.selectedTableModel.getHeaderTag(rows[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < hts.length) {
                        HeaderdataEvaluator.this.selectedTableModel.removeTag(hts[i]);
                        ++i;
                    }
                }
            }
        });
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HeaderdataEvaluator.this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HeaderdataEvaluator.this.showMenu(e);
                }
            }
        });
        JPanel filterPanel = new JPanel(new BorderLayout(3, 3));
        filterPanel.setBackground(new Color(200, 200, 255));
        filterPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        filterPanel.add((Component)new JLabel(Translatrix.getTranslationString((String)"TagSelectorDialog.filterTags"), DicomIcons.getIcon22("open_selector.png"), 2), "North");
        this.filterTableModel = new DicomHeaderTableModel(null, true, false);
        this.filterTable = new JTable(this.filterTableModel);
        this.filterTable.getColumnModel().getColumn(0).setMaxWidth(this.filterTableModel.getColumnSize(0));
        this.filterTable.getSelectionModel().addListSelectionListener(this);
        this.filterTable.addMouseListener(this);
        JScrollPane filterScrollPane = new JScrollPane(this.filterTable);
        filterScrollPane.setOpaque(false);
        filterScrollPane.getViewport().setOpaque(false);
        filterPanel.add((Component)filterScrollPane, "Center");
        this.filterTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    HeaderdataEvaluator.this.deleteFilter();
                }
            }
        });
        DicomHeaderTableDropTargetListener filterDropListener = new DicomHeaderTableDropTargetListener(this.filterTable, this.filterTableModel);
        new DropTarget(this.filterTable, filterDropListener);
        filterScrollPane.setDropTarget(new DropTarget(filterScrollPane, filterDropListener));
        ButtonBarBuilder filterButtons = new ButtonBarBuilder();
        this.deleteFilterButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.deleteFilterButton"), DicomIcons.getIcon16("filter_remove.png"));
        this.deleteFilterButton.addActionListener(this);
        this.deleteFilterButton.setEnabled(false);
        filterButtons.addGridded((JComponent)this.deleteFilterButton);
        filterButtons.addRelatedGap();
        filterButtons.addGlue();
        this.editFilterButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.editFilterButton"), DicomIcons.getIcon16("filter_edit.png"));
        this.editFilterButton.addActionListener(this);
        this.editFilterButton.setEnabled(false);
        filterButtons.addGridded((JComponent)this.editFilterButton);
        filterButtons.addRelatedGap();
        this.addFilterButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.addFilterButton"), DicomIcons.getIcon16("filter_add.png"));
        this.addFilterButton.addActionListener(this);
        filterButtons.addGridded((JComponent)this.addFilterButton);
        JPanel filterButtonPanel = filterButtons.getPanel();
        filterButtonPanel.setOpaque(false);
        filterPanel.add((Component)filterButtonPanel, "South");
        this.add((Component)filterPanel, cc.xy(3, 9));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.loadTemplateFile = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.loadTemplate"), DicomIcons.getIcon32("open_file.png"));
        this.loadTemplateFile.addActionListener(this);
        bb.addFixed((JComponent)this.loadTemplateFile);
        bb.addRelatedGap();
        this.loadAllTags = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.loadAllTags"), DicomIcons.getIcon32("action_header.png"));
        this.loadAllTags.addActionListener(this);
        bb.addFixed((JComponent)this.loadAllTags);
        bb.addUnrelatedGap();
        this.saveToFile = new JToggleButton(Translatrix.getTranslationString((String)"TagSelectorDialog.saveToFile"), DicomIcons.getIcon32("1downarrow.png"));
        this.saveToFile.addActionListener(this);
        bb.addFixed((JComponent)this.saveToFile);
        bb.addUnrelatedGap();
        bb.addGlue();
        this.loadConfig = new JButton(DicomIcons.getIcon32("config_load.png"));
        this.loadConfig.setToolTipText(Translatrix.getTranslationString((String)"TagSelectorDialog.loadConfig"));
        this.loadConfig.addActionListener(this);
        bb.addFixed((JComponent)this.loadConfig);
        this.saveConfig = new JButton(DicomIcons.getIcon32("config_save.png"));
        this.saveConfig.setToolTipText(Translatrix.getTranslationString((String)"TagSelectorDialog.saveConfig"));
        this.saveConfig.addActionListener(this);
        bb.addFixed((JComponent)this.saveConfig);
        bb.addRelatedGap();
        this.runButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.run"), DicomIcons.getIcon32("video_play.png"));
        this.runButton.addActionListener(this);
        this.runButton.setEnabled(false);
        bb.addRelatedGap();
        this.closeButton = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.close"), DicomIcons.getIcon32("close.png"));
        this.closeButton.addActionListener(this);
        bb.addFixed((JComponent)this.closeButton);
        bb.addFixed((JComponent)this.runButton);
        JPanel buttonPanel = bb.getPanel();
        this.add((Component)buttonPanel, cc.xyw(1, 11, 3));
        this.headerDataExtractor = new HeaderDataExtractor(this);
        this.dcmResultDialog = new DCMResultDialog(this);
        this.pack();
    }

    protected void filterTable() {
        this.tagTableModel.getNrFilter().setFilter(this.nrFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nrFilter.getText().length() > 0, 1);
        this.tagTableModel.getNameFilter().setFilter(this.nameFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nameFilter.getText().length() > 0, 2);
        this.tagTableModel.fireTableDataChanged();
    }

    public Vector<HeaderTag> showDialog(Vector<HeaderTag> usedTagss) {
        this.loadTags(new File(FILENAME));
        if (usedTagss != null) {
            this.usedTags = usedTagss;
        }
        this.selectedTableModel.setTags(this.usedTags);
        this.filterTableModel.setTags(this.filterTags);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HeaderdataEvaluator.this.filterTags = HeaderdataEvaluator.this.filterTableModel.getHeaderTags();
                HeaderdataEvaluator.this.usedTags = HeaderdataEvaluator.this.selectedTableModel.getHeaderTags();
                HeaderdataEvaluator.this.saveTags(new File(HeaderdataEvaluator.FILENAME));
            }
        });
        this.setVisible(true);
        return this.selectedTableModel.getHeaderTags();
    }

    private void saveTags(File file) {
        try {
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(file));
            zout.putNextEntry(new ZipEntry("TagSelectorDialog.tags"));
            HeaderTag.saveTags(zout, this.usedTags);
            zout.putNextEntry(new ZipEntry("TagSelectorDialogFilter.tags"));
            HeaderTag.saveTags(zout, this.filterTags);
            zout.putNextEntry(new ZipEntry("Settings.properties"));
            this.properties.put(IMAGE_PATH, this.openField.getText());
            this.properties.store(zout, "");
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTags(File file) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals("TagSelectorDialog.tags")) {
                    this.usedTags = HeaderTag.loadTags(zis);
                    continue;
                }
                if (entry.getName().equals("TagSelectorDialogFilter.tags")) {
                    this.filterTags = HeaderTag.loadTags(zis);
                    continue;
                }
                if (!entry.getName().equals("Settings.properties")) continue;
                this.properties.load(zis);
                try {
                    File f = new File(this.properties.getProperty((String)IMAGE_PATH));
                    if (!f.canRead()) continue;
                    this.openField.setText(f.getAbsolutePath());
                    this.dicomChooser.setSelectedFile(f);
                    this.files = this.dicomChooser.getSelectedFiles();
                    this.runButton.setEnabled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            zis.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Headerdata Evaluator settings not found at: " + file + " ...creating next time...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if ((!e.getSource().equals(this.tagTable.getSelectionModel()) || e.getValueIsAdjusting()) && e.getSource().equals(this.filterTable.getSelectionModel()) && !e.getValueIsAdjusting()) {
            if (this.filterTable.getSelectedRow() == -1) {
                this.deleteFilterButton.setEnabled(false);
                this.editFilterButton.setEnabled(false);
            } else {
                this.deleteFilterButton.setEnabled(true);
                this.editFilterButton.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.tagTable)) {
            if (e.getClickCount() >= 2) {
                HeaderTag ht = this.tagTableModel.getHeaderTag(this.tagTable.getSelectedRow());
                this.selectedTableModel.addTag(ht);
            }
        } else if (!e.getSource().equals(this.selectedTable) && e.getSource().equals(this.filterTable) && e.getClickCount() >= 2) {
            this.editFilter();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeButton)) {
            this.setVisible(false);
        } else if (e.getSource().equals(this.loadFilesButton)) {
            this.loadFiles();
        } else if (e.getSource().equals(this.addFilterButton)) {
            this.addFilter();
        } else if (e.getSource().equals(this.deleteFilterButton)) {
            this.deleteFilter();
        } else if (e.getSource().equals(this.editFilterButton)) {
            this.editFilter();
        } else if (e.getSource().equals(this.runButton)) {
            this.runSearch();
        } else if (e.getSource().equals(this.loadTemplateFile)) {
            this.loadTemplateFile();
        } else if (e.getSource().equals(this.loadAllTags)) {
            this.loadAllTags();
        } else if (e.getSource().equals(this.loadConfig)) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.loadTags(this.fileChooser.getSelectedFile());
                this.selectedTableModel.setTags(this.usedTags);
                this.filterTableModel.setTags(this.filterTags);
            }
        } else if (e.getSource().equals(this.saveConfig)) {
            this.fileChooser.setSelectedFile(new File(FILENAME));
            if (this.fileChooser.showSaveDialog(this) == 0) {
                this.filterTags = this.filterTableModel.getHeaderTags();
                this.usedTags = this.selectedTableModel.getHeaderTags();
                this.saveTags(this.fileChooser.getSelectedFile());
            }
        }
    }

    private void loadAllTags() {
        this.tagTableModel.setShowValue(false);
        this.tagTableModel.setTags(HeaderTag.getAllTags());
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
        this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
    }

    private void loadTemplateFile() {
        if (this.dicomChooser.showNewDialog(this) == 0) {
            File f = this.dicomChooser.getSelectedFile();
            DicomHeader dh = new DicomHeader(f);
            this.tagTableModel.setShowValue(true);
            this.tagTableModel.setTags(dh.getHeaderTagsAsFlatList());
            this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
            this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
        }
    }

    private void addFilter() {
        do {
            HeaderTag ht;
            if ((ht = this.tagFilterDialog.selectTag(null)) == null) continue;
            this.filterTableModel.addTag(ht);
        } while (this.tagFilterDialog.isAddNext());
    }

    private void deleteFilter() {
        int[] rows = this.filterTable.getSelectedRows();
        HeaderTag[] hts = new HeaderTag[rows.length];
        int i = 0;
        while (i < rows.length) {
            hts[i] = this.filterTableModel.getHeaderTag(rows[i]);
            ++i;
        }
        i = 0;
        while (i < hts.length) {
            this.filterTableModel.removeTag(hts[i]);
            ++i;
        }
    }

    private void editFilter() {
        int row = this.filterTable.getSelectedRow();
        HeaderTag ht = this.filterTableModel.getHeaderTag(row);
        if (ht != null) {
            ht = this.tagFilterDialog.selectTag(ht);
        }
        this.filterTableModel.fireTableRowsUpdated(row, row);
    }

    private void runSearch() {
        new Thread(){

            @Override
            public void run() {
                HeaderdataEvaluator.this.runButton.setEnabled(false);
                if (HeaderdataEvaluator.this.saveToFile.isSelected()) {
                    File f = DCMResultDialog.showExportDialog(HeaderdataEvaluator.this, "export.csv");
                    if (f != null) {
                        HeaderdataEvaluator.this.inspectFiles(f);
                    }
                } else {
                    HeaderdataEvaluator.this.inspectFiles(null);
                }
                HeaderdataEvaluator.this.runButton.setEnabled(true);
            }
        }.start();
    }

    private void loadFiles() {
        if (this.dicomChooser.showNewDialog(this) == 0) {
            this.openField.setText(this.dicomChooser.getSelectedFiles()[0].getParent());
            this.files = this.dicomChooser.getSelectedFiles();
            this.runButton.setEnabled(true);
        }
    }

    private void inspectFiles(File f) {
        try {
            this.headerDataExtractor.setHeaderTags(this.selectedTableModel.getHeaderTags());
            this.headerDataExtractor.setFilterTags(this.filterTableModel.getHeaderTags());
            ArrayList<File> al = new ArrayList<File>();
            int i = 0;
            while (i < this.files.length) {
                al.add(this.files[i]);
                ++i;
            }
            Vector<String[]> results = this.headerDataExtractor.workFiles(al, f, true);
            if (f == null) {
                this.dcmResultDialog.showResult(this.headerDataExtractor.createColumns(true), this.headerDataExtractor.createColumnTooltips(true), results);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void TableMousePressed(MouseEvent evt) {
        this.rowFrom = this.selectedTable.rowAtPoint(evt.getPoint());
    }

    private void TableMouseDragged(MouseEvent evt) {
        this.rowTo = this.selectedTable.rowAtPoint(evt.getPoint());
        if (this.rowTo != this.rowFrom && this.rowTo > -1 && this.rowTo < this.selectedTable.getRowCount()) {
            this.selectedTableModel.moveRow(this.rowFrom, this.rowTo);
            this.rowFrom = this.rowTo;
        }
    }

    public static void main(String[] args) {
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new HeaderdataEvaluator(new JFrame(), null).showDialog(null);
    }

    public void setViewer(Viewer viewer) {
        this.dicomViewer = viewer;
    }

    private void showMenu(MouseEvent e) {
        JTable table;
        int row;
        this.event = e;
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(new AbstractAction(Translatrix.getTranslationString((String)"TagSelectorDialog.deleteTags")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JTable table = (JTable)HeaderdataEvaluator.this.event.getSource();
                    int[] selectedRows = table.getSelectedRows();
                    DicomHeaderTableModel model = (DicomHeaderTableModel)table.getModel();
                    Vector<HeaderTag> tags = new Vector<HeaderTag>();
                    int[] nArray = selectedRows;
                    int n = selectedRows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        tags.add(model.getHeaderTag(i));
                        ++n2;
                    }
                    for (HeaderTag headerTag : tags) {
                        model.removeTag(headerTag);
                    }
                }
            });
            this.popup.add(new AbstractAction(Translatrix.getTranslationString((String)"TagSelectorDialog.addTag")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JTable table = (JTable)HeaderdataEvaluator.this.event.getSource();
                    DicomHeaderTableModel model = (DicomHeaderTableModel)table.getModel();
                    model.addTag(new HeaderTag("", "", ""));
                    table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 1, false));
                    table.editCellAt(table.getRowCount() - 1, 1);
                }
            });
        }
        if ((row = (table = (JTable)this.event.getSource()).rowAtPoint(this.event.getPoint())) < 0) {
            return;
        }
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            table.setRowSelectionInterval(row, row);
        }
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }
}

