/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header.selector;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.header.selector.ExportToCSV;
import lu.tudor.santec.dicom.gui.selector.DicomFile;
import lu.tudor.santec.dicom.gui.selector.DicomMatcher;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HeaderDataExtractor {
    private static Logger logger = Logger.getLogger((String)HeaderDataExtractor.class.getName());
    private Vector<HeaderTag> headerTags;
    private Vector<HeaderTag> filterTags;
    private Component parent;
    private ProgressMonitor progressMonitor;
    private DicomMatcher dicomMatcher;

    public HeaderDataExtractor(Component parent) {
        this.parent = parent;
    }

    public void setHeaderTags(Vector<HeaderTag> tags) {
        this.headerTags = tags;
    }

    public void setFilterTags(Vector<HeaderTag> tags) {
        this.filterTags = tags;
    }

    public Vector<String[]> workDir(File dir, File f) {
        try {
            ArrayList<File> al = new ArrayList<File>();
            HeaderDataExtractor.visitAllFiles(dir, al);
            return this.workFiles(al, f, true);
        }
        catch (Throwable e) {
            logger.log((Priority)Level.FATAL, (Object)e.getMessage(), e);
            return null;
        }
    }

    public Vector<String[]> workFiles(ArrayList<File> al, File f, boolean extendedInfo) {
        long start = System.currentTimeMillis();
        Vector<String[]> results = new Vector<String[]>();
        ExportToCSV cvsExporter = null;
        try {
            if (f != null) {
                cvsExporter = new ExportToCSV(f);
                Object[] columns = this.createColumnStrings(extendedInfo);
                cvsExporter.println(columns);
            }
            if (this.filterTags != null) {
                this.dicomMatcher = new DicomMatcher(null);
                HeaderTag[] tags = new HeaderTag[this.filterTags.size()];
                int i = 0;
                while (i < tags.length) {
                    tags[i] = this.filterTags.get(i);
                    ++i;
                }
                this.dicomMatcher.setHeaderTags(tags);
            }
            if (this.parent != null) {
                this.progressMonitor = new ProgressMonitor(this.parent, Translatrix.getTranslationString((String)"dicom.searchingFiles"), "", 0, al.size());
                this.progressMonitor.setMillisToDecideToPopup(5);
                this.progressMonitor.setMillisToPopup(5);
            }
            int i = 0;
            while (i < al.size()) {
                if (this.parent != null && this.progressMonitor.isCanceled()) break;
                try {
                    File file = al.get(i);
                    if (file.exists() && !file.isDirectory()) {
                        Object[] result;
                        DicomFile dFile = new DicomFile(file);
                        if (this.parent != null) {
                            this.progressMonitor.setNote("img " + dFile.getFile().getName() + " ( " + (i + 1) + " of " + (al.size() + 1) + " )");
                            this.progressMonitor.setProgress(i);
                        }
                        if ((this.dicomMatcher == null || this.dicomMatcher.matchFile(dFile)) && (result = this.extractFile(dFile, extendedInfo)) != null) {
                            if (cvsExporter == null) {
                                results.add((String[])result);
                            } else {
                                cvsExporter.println(result);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (this.parent != null) {
                this.progressMonitor.close();
            }
        }
        catch (Throwable e) {
            logger.log((Priority)Level.FATAL, (Object)e.getMessage(), e);
        }
        if (cvsExporter != null) {
            try {
                cvsExporter.close();
                JOptionPane.showMessageDialog(this.parent, "Exportet \n" + al.size() + " rows with " + this.headerTags.size() + "cols \nto:\n" + f.getAbsolutePath() + "\n" + "took: " + (System.currentTimeMillis() - start) / 1000L / 60L + "min\n" + "\n Delimiter: ; Quote Char: \"");
            }
            catch (IOException e) {
                logger.log((Priority)Level.WARN, (Object)"", (Throwable)e);
            }
        }
        return results;
    }

    public String[] createColumns(boolean extendedInfo) {
        String[] result = new String[this.headerTags.size()];
        if (extendedInfo) {
            result = new String[this.headerTags.size() + 4];
        }
        int i = 0;
        for (HeaderTag ht : this.headerTags) {
            String tagValue;
            result[i] = tagValue = ht.getTagName();
            ++i;
        }
        if (extendedInfo) {
            result[result.length - 4] = "filesize (kb)";
            result[result.length - 3] = "hasPixeldata";
            result[result.length - 2] = "path";
            result[result.length - 1] = "filename";
        }
        return result;
    }

    public String[] createColumnTooltips(boolean extendedInfo) {
        String[] result = new String[this.headerTags.size()];
        if (extendedInfo) {
            result = new String[this.headerTags.size() + 4];
        }
        int i = 0;
        for (HeaderTag ht : this.headerTags) {
            String tagValue;
            result[i] = tagValue = String.valueOf(ht.getTagVR()) + ":" + ht.getTagNr();
            ++i;
        }
        if (extendedInfo) {
            result[result.length - 4] = "filesize (kb)";
            result[result.length - 3] = "hasPixeldata";
            result[result.length - 2] = "path";
            result[result.length - 1] = "filename";
        }
        return result;
    }

    public String[] createColumnStrings(boolean extendedInfo) {
        String[] result = new String[this.headerTags.size()];
        if (extendedInfo) {
            result = new String[this.headerTags.size() + 4];
        }
        int i = 0;
        for (HeaderTag ht : this.headerTags) {
            String tagValue;
            result[i] = tagValue = String.valueOf(ht.getTagName()) + " [" + ht.getTagVR() + ":" + ht.getTagNr() + "]";
            ++i;
        }
        if (extendedInfo) {
            result[result.length - 4] = "filesize (kb)";
            result[result.length - 3] = "hasPixeldata";
            result[result.length - 2] = "path";
            result[result.length - 1] = "filename";
        }
        return result;
    }

    private String[] extractFile(DicomFile dfile, boolean extendedInfo) {
        String[] result;
        block12: {
            int i;
            DicomHeader dh;
            boolean isEmpty;
            block11: {
                result = new String[this.headerTags.size()];
                if (extendedInfo) {
                    result = new String[this.headerTags.size() + 4];
                }
                isEmpty = true;
                logger.info((Object)("testing file: " + dfile.getFile()));
                dh = dfile.getDicomHeader();
                i = 0;
                if (dh != null) break block11;
                logger.warn((Object)("NO DICOM file (Header is NULL): " + dfile.getFile().getAbsolutePath()));
                return null;
            }
            try {
                for (HeaderTag ht : this.headerTags) {
                    String tagValue = null;
                    try {
                        tagValue = ht.getTagNr().indexOf("#") > 0 ? "" + dh.getHeaderValueInsideTag(ht.getTagNr().split("#")) : dh.getHeaderStringValue(ht.getTagNr());
                    }
                    catch (Exception e) {
                        logger.log((Priority)Level.WARN, (Object)("Error getting Tag: " + ht.toString() + " on file " + dfile.getFile().getName()), (Throwable)e);
                    }
                    if (tagValue != null && !tagValue.equals("")) {
                        isEmpty = false;
                    }
                    if (tagValue.length() > 200) {
                        tagValue = String.valueOf(tagValue.substring(0, 199)) + " [TRUNCATED AT 200chars]";
                    }
                    result[i] = tagValue;
                    ++i;
                }
                if (!isEmpty) break block12;
                logger.warn((Object)("NO DICOM file: " + dfile.getFile().getAbsolutePath()));
                return null;
            }
            catch (Throwable e) {
                logger.info((Object)("no DICOM file: " + dfile.getFile().getName()));
                e.printStackTrace();
                return null;
            }
        }
        if (extendedInfo) {
            result[result.length - 4] = String.valueOf(dfile.getFile().length() / 1024L);
            result[result.length - 3] = String.valueOf(dfile.getDicomHeader().hasPixelData());
            result[result.length - 2] = dfile.getFile().getParentFile().getAbsolutePath();
            result[result.length - 1] = dfile.getFile().getName();
        }
        return result;
    }

    public static void visitAllFiles(File dir, ArrayList<File> al) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                HeaderDataExtractor.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public static String printArray(String[] ar) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ar.length) {
            sb.append("'").append(ar[i]).append("',");
            ++i;
        }
        System.out.println(sb.toString());
        return sb.toString();
    }
}

