/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header.selector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExportToXSL {
    private FileOutputStream fos;
    private HSSFSheet sheet;
    private HSSFWorkbook workbook;
    private HSSFCellStyle cellStyle;
    private int rowIndex = 0;

    public ExportToXSL(File xlsOut) throws FileNotFoundException {
        this.fos = new FileOutputStream(xlsOut);
        this.workbook = new HSSFWorkbook();
        this.cellStyle = this.workbook.createCellStyle();
        this.sheet = this.workbook.createSheet("Results");
    }

    public void println(Object[] line) {
        HSSFRow row = this.sheet.createRow((int)((short)this.rowIndex));
        boolean printed = true;
        int i = 0;
        while (i < line.length) {
            try {
                Date interValue = (Date)line[i];
                System.out.println(interValue + " " + line[i]);
                this.cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy"));
                row.createCell((short)i).setCellValue(interValue);
                row.getCell((short)i).setCellStyle(this.cellStyle);
                printed = true;
            }
            catch (Exception e) {
                printed = false;
            }
            try {
                if (!printed) {
                    double interValue = Double.parseDouble(line[i].toString());
                    row.createCell((short)i).setCellValue(interValue);
                    printed = true;
                }
            }
            catch (Exception e) {
                printed = false;
            }
            if (!printed) {
                try {
                    String interValue = line[i].toString();
                    row.createCell((short)i).setCellValue(interValue);
                    printed = true;
                }
                catch (Exception e) {
                    row.createCell((short)i).setCellValue("");
                }
            }
            ++i;
        }
        ++this.rowIndex;
    }

    public boolean writeStreamToBook() {
        try {
            this.workbook.write((OutputStream)this.fos);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() throws IOException {
        this.fos.close();
    }
}

