/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header.selector;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import ij.IJ;
import ij.ImageJ;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import lu.tudor.santec.dicom.gui.TableSorter;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoDialog;
import lu.tudor.santec.dicom.gui.header.selector.ExportToCSV;
import lu.tudor.santec.dicom.gui.header.selector.ExportToXSL;
import lu.tudor.santec.dicom.gui.header.selector.HeaderdataEvaluator;
import lu.tudor.santec.dicom.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.dicom.gui.utils.TableUtils;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;

public class DCMResultDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)DCMResultDialog.class.getName());
    private DCMResultTableModel dcmResultTableModel;
    private JTable dcmResultTable;
    private JButton closeButton;
    private JButton csvButton;
    private JButton xlsButton;
    private JButton printButton;
    private static JFileChooser fileChooser = new JFileChooser();
    private DicomHeaderInfoDialog dhd;
    protected ImageJ imageJ;
    private JButton openImageButton;
    private JButton openImagesButton;
    private HeaderdataEvaluator evaluator;
    private TableSorter sorter;
    private JButton openFolderButton;
    private JButton copyFilesButton;
    private ProgressMonitor progressMonitor;

    public DCMResultDialog(HeaderdataEvaluator parent) {
        super((Dialog)parent, Translatrix.getTranslationString((String)"DCMResultDialog.title"));
        this.evaluator = parent;
        this.dhd = new DicomHeaderInfoDialog(this);
        this.setLayout(new BorderLayout(5, 5));
        this.dcmResultTableModel = new DCMResultTableModel();
        this.sorter = new TableSorter(this.dcmResultTableModel);
        this.dcmResultTable = new JTable(this.sorter){
            private static final long serialVersionUID = 1L;

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return DCMResultDialog.this.dcmResultTableModel.getColumnTooltip(realIndex);
                    }
                };
            }
        };
        this.dcmResultTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 72) {
                    int row = DCMResultDialog.this.sorter.modelIndex(DCMResultDialog.this.dcmResultTable.getSelectedRow());
                    if (row < 0) {
                        return;
                    }
                    DCMResultDialog.this.showDicomHeader(String.valueOf(DCMResultDialog.this.dcmResultTableModel.getPathforRow(row)) + File.separator + DCMResultDialog.this.dcmResultTableModel.getFilenameforRow(row));
                } else if (e.getKeyCode() == 73) {
                    int row = DCMResultDialog.this.sorter.modelIndex(DCMResultDialog.this.dcmResultTable.getSelectedRow());
                    if (row < 0) {
                        return;
                    }
                    File[] f = new File[]{new File(String.valueOf(DCMResultDialog.this.dcmResultTableModel.getPathforRow(row)) + File.separator + DCMResultDialog.this.dcmResultTableModel.getFilenameforRow(row))};
                    DCMResultDialog.this.showImage(f);
                } else if (e.getKeyCode() == 70) {
                    int row = DCMResultDialog.this.sorter.modelIndex(DCMResultDialog.this.dcmResultTable.getSelectedRow());
                    if (row < 0) {
                        return;
                    }
                    File[] f = new File(DCMResultDialog.this.dcmResultTableModel.getPathforRow(row)).listFiles();
                    DCMResultDialog.this.showImage(f);
                }
            }
        });
        this.sorter.setTableHeader(this.dcmResultTable.getTableHeader());
        this.dcmResultTable.setDefaultRenderer(String.class, new LineColorCellRenderer());
        this.dcmResultTable.setDefaultRenderer(Object.class, new LineColorCellRenderer());
        this.dcmResultTable.setAutoResizeMode(0);
        JScrollPane jsp = new JScrollPane(this.dcmResultTable);
        jsp.setHorizontalScrollBarPolicy(30);
        this.add((Component)jsp, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.csvButton = new JButton(String.valueOf(Translatrix.getTranslationString((String)"dicom.export")) + " .csv");
        this.csvButton.addActionListener(this);
        bb.addGridded((JComponent)this.csvButton);
        bb.addRelatedGap();
        bb.addRelatedGap();
        this.openImageButton = new JButton("View image");
        this.openImageButton.addActionListener(this);
        bb.addGridded((JComponent)this.openImageButton);
        this.openImagesButton = new JButton("View images in folder");
        this.openImagesButton.addActionListener(this);
        bb.addGridded((JComponent)this.openImagesButton);
        this.openFolderButton = new JButton("Open folder");
        this.openFolderButton.addActionListener(this);
        bb.addGridded((JComponent)this.openFolderButton);
        this.copyFilesButton = new JButton("Copy Files");
        this.copyFilesButton.addActionListener(this);
        bb.addGridded((JComponent)this.copyFilesButton);
        bb.addGlue();
        this.closeButton = new JButton(Translatrix.getTranslationString((String)"dicom.close"));
        this.closeButton.addActionListener(this);
        bb.addGridded((JComponent)this.closeButton);
        JPanel buttonPanel = bb.getPanel();
        this.add((Component)buttonPanel, "South");
        this.setSize(1100, 800);
    }

    public void showResult(String[] columns, String[] columnTooltips, Vector<String[]> data) {
        this.dcmResultTableModel.setColumns(columns);
        this.dcmResultTableModel.setColumnTooltips(columnTooltips);
        this.dcmResultTableModel.setData(data);
        this.setTitle(String.valueOf(Translatrix.getTranslationString((String)"DCMResultDialog.title")) + " " + data.size() + " " + Translatrix.getTranslationString((String)"DCMResultDialog.results"));
        TableUtils.adjustColWidth(this.dcmResultTable);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeButton)) {
            this.setVisible(false);
        } else if (e.getSource().equals(this.csvButton)) {
            this.exportCSV();
        } else if (e.getSource().equals(this.copyFilesButton)) {
            this.copyFiles();
        } else if (e.getSource().equals(this.xlsButton)) {
            this.exportXLS();
        } else if (e.getSource().equals(this.printButton)) {
            this.printTable();
        } else if (e.getSource().equals(this.openImageButton)) {
            int row = this.sorter.modelIndex(this.dcmResultTable.getSelectedRow());
            if (row < 0) {
                return;
            }
            File[] f = new File[]{new File(String.valueOf(this.dcmResultTableModel.getPathforRow(row)) + File.separator + this.dcmResultTableModel.getFilenameforRow(row))};
            this.showImage(f);
        } else if (e.getSource().equals(this.openImagesButton)) {
            int row = this.sorter.modelIndex(this.dcmResultTable.getSelectedRow());
            if (row < 0) {
                return;
            }
            File[] f = new File(this.dcmResultTableModel.getPathforRow(row)).listFiles();
            this.showImage(f);
        } else if (e.getSource().equals(this.openFolderButton)) {
            int row = this.sorter.modelIndex(this.dcmResultTable.getSelectedRow());
            if (row < 0) {
                return;
            }
            File f = new File(this.dcmResultTableModel.getPathforRow(row));
            this.openFolder(f);
        }
    }

    private void printTable() {
        try {
            MessageFormat headerFormat = new MessageFormat("Page {0}");
            MessageFormat footerFormat = new MessageFormat("- {0} -");
            this.dcmResultTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
        }
        catch (PrinterException pe) {
            System.err.println("Error printing: " + pe.getMessage());
        }
    }

    private void exportCSV() {
        File f = DCMResultDialog.showExportDialog(this, "export.csv");
        if (f != null) {
            try {
                ExportToCSV cvsExporter = new ExportToCSV(f);
                String[] columns = this.dcmResultTableModel.getColumns();
                String[] toolTips = this.dcmResultTableModel.getColumnTooltips();
                int i = 0;
                while (i < columns.length) {
                    int n = i;
                    columns[n] = String.valueOf(columns[n]) + " [" + toolTips[i] + "]";
                    ++i;
                }
                cvsExporter.println(this.dcmResultTableModel.getColumns());
                Vector<String[]> data = this.dcmResultTableModel.getData();
                for (Object[] objectArray : data) {
                    cvsExporter.println(objectArray);
                }
                cvsExporter.close();
                JOptionPane.showMessageDialog(this, "Exportet \n" + data.size() + " rows with " + this.dcmResultTableModel.getColumnCount() + "cols \nto:\n" + f.getAbsolutePath() + "\n Delimiter: ; Quote Char: \"");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void exportXLS() {
        File f = DCMResultDialog.showExportDialog(this, "export.xls");
        if (f != null) {
            try {
                ExportToXSL xlsExporter = new ExportToXSL(f);
                Object[] columns = this.dcmResultTableModel.getColumns();
                String[] toolTips = this.dcmResultTableModel.getColumnTooltips();
                int i = 0;
                while (i < columns.length) {
                    int n = i;
                    columns[n] = String.valueOf(columns[n]) + " [" + toolTips[i] + "]";
                    ++i;
                }
                xlsExporter.println(columns);
                xlsExporter.writeStreamToBook();
                Vector<String[]> data = this.dcmResultTableModel.getData();
                for (Object[] objectArray : data) {
                    xlsExporter.println(objectArray);
                    xlsExporter.writeStreamToBook();
                }
                xlsExporter.close();
                JOptionPane.showMessageDialog(this, "Exportet \n" + data.size() + " rows with " + this.dcmResultTableModel.getColumnCount() + "cols \nto:\n" + f.getAbsolutePath());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static File showExportDialog(Component parent, String fileName) {
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setSelectedFile(new File(fileName));
        if (fileChooser.showSaveDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    protected void showImage(File[] files) {
        try {
            if (this.evaluator.dicomViewer != null) {
                this.evaluator.dicomViewer.setFiles(files);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showDicomHeader(String path) {
        try {
            DicomHeader dh = new DicomHeader(new File(path));
            this.dhd.setInfo(dh);
            this.dhd.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFiles() {
        final int[] rows = this.dcmResultTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select rows first!");
        } else {
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showSaveDialog(this) == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        File folder = fileChooser.getSelectedFile();
                        folder.mkdirs();
                        DCMResultDialog.this.progressMonitor = new ProgressMonitor(DCMResultDialog.this, "Copy Files", "", 0, rows.length);
                        DCMResultDialog.this.progressMonitor.setMillisToDecideToPopup(5);
                        DCMResultDialog.this.progressMonitor.setMillisToPopup(5);
                        int i = 0;
                        while (i < rows.length) {
                            if (DCMResultDialog.this.progressMonitor.isCanceled()) break;
                            int row = DCMResultDialog.this.sorter.modelIndex(rows[i]);
                            if (row >= 0) {
                                File oldFile = new File("");
                                File newFile = new File("");
                                try {
                                    oldFile = new File(String.valueOf(DCMResultDialog.this.dcmResultTableModel.getPathforRow(row)) + File.separator + DCMResultDialog.this.dcmResultTableModel.getFilenameforRow(row));
                                    DCMResultDialog.this.progressMonitor.setNote("img " + oldFile.getName() + " ( " + (i + 1) + " of " + (rows.length + 1) + " )");
                                    DCMResultDialog.this.progressMonitor.setProgress(i);
                                    newFile = new File(folder, DicomDirReader.createFileName(new DicomHeader(oldFile).getDicomObject()));
                                    DCMResultDialog.copyFile(oldFile, newFile);
                                }
                                catch (Exception e) {
                                    logger.error((Object)("Error copying file: " + oldFile.getAbsolutePath() + " to " + newFile.getAbsolutePath()), (Throwable)e);
                                }
                            }
                            ++i;
                        }
                        DCMResultDialog.this.progressMonitor.close();
                    }
                }.start();
            }
        }
    }

    public void openFolder(File folder) {
        block13: {
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    Desktop.getDesktop().open(folder);
                    break block13;
                }
                try {
                    Runtime rt = Runtime.getRuntime();
                    if (IJ.isWindows()) {
                        String[] command = new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", folder.getAbsolutePath()};
                        rt.exec(command);
                    } else if (IJ.isLinux()) {
                        String[] command = new String[]{"kfmclient", "openURL", folder.getAbsolutePath()};
                        rt.exec(command);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    Runtime rt = Runtime.getRuntime();
                    if (IJ.isWindows()) {
                        String[] command = new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", folder.getAbsolutePath()};
                        rt.exec(command);
                    } else if (IJ.isLinux()) {
                        String[] command = new String[]{"kfmclient", "openURL", folder.getAbsolutePath()};
                        rt.exec(command);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void main(String[] args) {
    }

    public class DCMResultTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columns = new String[0];
        private Vector<String[]> data = new Vector();
        private String[] columnTooltips = new String[0];

        public void setColumns(String[] columns) {
            this.columns = columns;
            this.fireTableStructureChanged();
        }

        public String getPathforRow(int selectedRow) {
            return (String)this.getValueAt(selectedRow, this.getColumnCount() - 2);
        }

        public String getFilenameforRow(int selectedRow) {
            return (String)this.getValueAt(selectedRow, this.getColumnCount() - 1);
        }

        public void setColumnTooltips(String[] columnTooltips) {
            this.columnTooltips = columnTooltips;
        }

        public void setData(Vector<String[]> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        public String getColumnTooltip(int columnIndex) {
            return this.columnTooltips[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex)[columnIndex];
        }

        public String[] getColumns() {
            return this.columns;
        }

        public String[] getColumnTooltips() {
            return this.columnTooltips;
        }

        public Vector<String[]> getData() {
            return this.data;
        }
    }

    public class DCMSummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columns = new String[0];
        private Vector<Double[]> data = new Vector();
        private NumberFormat nf = new DecimalFormat("#0.000");

        public void setColumns(String[] columns) {
            this.columns = columns;
            this.fireTableStructureChanged();
        }

        public void setData(Vector<String[]> data) {
            this.data.clear();
            try {
                int columns = data.get(0).length;
                Double[] min = new Double[columns];
                Double[] max = new Double[columns];
                Double[] mean = new Double[columns];
                Double[] stdev = new Double[columns];
                for (String[] strings : data) {
                    int i = 0;
                    while (i < strings.length) {
                        try {
                            double val = Double.parseDouble(strings[i]);
                            if (min[i] == null || min[i] > val) {
                                min[i] = val;
                            }
                            if (max[i] == null || max[i] < val) {
                                max[i] = val;
                            }
                            if (mean[i] == null) {
                                mean[i] = 0.0;
                            }
                            int n = i;
                            mean[n] = mean[n] + val;
                        }
                        catch (Exception val) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                this.data.add(min);
                this.data.add(max);
                int i = 0;
                while (i < mean.length) {
                    try {
                        mean[i] = mean[i] / (double)data.size();
                        double sum = 0.0;
                        for (String[] strings : data) {
                            double val = Double.parseDouble(strings[i]);
                            sum += Math.pow(val - mean[i], 2.0);
                        }
                        stdev[i] = Math.sqrt(sum) / (double)data.size();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.data.add(mean);
                this.data.add(stdev);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                return this.nf.format(this.data.get(rowIndex)[columnIndex]);
            }
            catch (Exception e) {
                return "";
            }
        }

        public String[] getColumns() {
            return this.columns;
        }

        public Vector<Double[]> getData() {
            return this.data;
        }
    }
}

