/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderTableModel;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.header.TagListener;
import lu.tudor.santec.i18n.Translatrix;

public class TagSearchPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DicomHeaderTableModel tagTableModel;
    private JTable tagTable;
    private JScrollPane jsp;
    private JTextField nrFilter;
    private JTextField nameFilter;
    private Vector<TagListener> tagListeners = new Vector();
    private HeaderTag ht;
    private JButton loadTemplateFile;
    private JButton loadAllTags;
    private DicomFileDialog dicomChooser;
    private RootPaneContainer parentDialog;

    public TagSearchPanel() {
        this(null, null);
    }

    public TagSearchPanel(RootPaneContainer parent, DicomFileDialog dicomChooser) {
        this.parentDialog = parent;
        this.dicomChooser = dicomChooser;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        JPanel filterPanel = new JPanel((LayoutManager)new FormLayout("105px, 3dlu, 200px:grow", "pref"));
        this.nrFilter = new JTextField();
        filterPanel.add((Component)this.nrFilter, cc.xy(1, 1));
        this.nameFilter = new JTextField();
        filterPanel.add((Component)this.nameFilter, cc.xy(3, 1));
        KeyAdapter filterListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TagSearchPanel.this.filterTable();
            }
        };
        this.nrFilter.addKeyListener(filterListener);
        this.nameFilter.addKeyListener(filterListener);
        this.add((Component)filterPanel, "North");
        this.tagTableModel = new DicomHeaderTableModel(HeaderTag.getAllTags(), false, false);
        this.tagTable = new JTable(this.tagTableModel);
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
        this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
        this.tagTable.getSelectionModel().addListSelectionListener(this);
        this.jsp = new JScrollPane(this.tagTable);
        this.jsp.setOpaque(false);
        this.jsp.getViewport().setOpaque(false);
        this.add((Component)this.jsp, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.loadTemplateFile = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.loadTemplate"), DicomIcons.getIcon16("open_file.png"));
        this.loadTemplateFile.addActionListener(this);
        bb.addFixed((JComponent)this.loadTemplateFile);
        bb.addRelatedGap();
        this.loadAllTags = new JButton(Translatrix.getTranslationString((String)"TagSelectorDialog.loadAllTags"), DicomIcons.getIcon16("action_header.png"));
        this.loadAllTags.addActionListener(this);
        bb.addFixed((JComponent)this.loadAllTags);
        bb.addUnrelatedGap();
        if (this.dicomChooser != null) {
            JPanel buttonPanel = bb.getPanel();
            buttonPanel.setOpaque(false);
            this.add((Component)buttonPanel, "South");
        }
    }

    public void filterTable() {
        this.tagTableModel.getNrFilter().setFilter(this.nrFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nrFilter.getText().length() > 0, 1);
        this.tagTableModel.getNameFilter().setFilter(this.nameFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nameFilter.getText().length() > 0, 2);
        this.tagTableModel.fireTableDataChanged();
    }

    private void loadAllTags() {
        this.tagTableModel.setShowValue(false);
        this.tagTableModel.setTags(HeaderTag.getAllTags());
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
        this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
    }

    private void loadTemplateFile() {
        if (this.dicomChooser.showNewDialog(this.parentDialog) == 0) {
            File f = this.dicomChooser.getSelectedFile();
            DicomHeader dh = new DicomHeader(f);
            this.tagTableModel.setShowValue(true);
            this.tagTableModel.setTags(dh.getHeaderTagsAsFlatList());
            this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
            this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.loadTemplateFile)) {
            this.loadTemplateFile();
        } else if (e.getSource().equals(this.loadAllTags)) {
            this.loadAllTags();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.tagTable.getSelectionModel()) && !e.getValueIsAdjusting()) {
            HeaderTag ht = this.tagTableModel.getHeaderTag(this.tagTable.getSelectedRow());
            this.tagSelected(ht);
        }
    }

    public void setTag(HeaderTag ht) {
        this.ht = ht;
        if (ht != null) {
            this.nrFilter.setText(ht.getTagNr());
        } else {
            this.nrFilter.setText("");
        }
        this.nameFilter.setText("");
        this.filterTable();
    }

    public HeaderTag getTag() {
        return this.ht;
    }

    private void tagSelected(HeaderTag ht) {
        this.ht = ht;
        for (TagListener tagListener : this.tagListeners) {
            tagListener.tagChanged(ht);
        }
    }

    public void addTagListener(TagListener tagListener) {
        this.tagListeners.add(tagListener);
    }

    public void removeTagListener(TagListener tagListener) {
        this.tagListeners.remove(tagListener);
    }

    public void setEditable(boolean editable) {
        this.nrFilter.setEnabled(editable);
        this.nameFilter.setEnabled(editable);
        this.tagTable.setEnabled(editable);
    }
}

