/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.tudor.santec.dicom.gui.header.DicomHeaderTableModel;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;

public class TagChooserDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DicomHeaderTableModel tagTableModel;
    private JTable tagTable;
    private JPanel mainPanel;
    private JTextField nrFilter;
    private JTextField nameFilter;
    private JScrollPane jsp;
    private JButton closeButton;
    private JButton okButton;
    private HeaderTag ht;
    private Component parent;

    public TagChooserDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initDialog();
        this.setLocationRelativeTo(parent);
    }

    public TagChooserDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initDialog();
        this.setLocationRelativeTo(parent);
    }

    public TagChooserDialog() {
        this.initDialog();
    }

    private void initDialog() {
        this.setTitle(Translatrix.getTranslationString((String)"FilterTagDialog.title"));
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel((LayoutManager)new FormLayout("fill:200dlu, 5dlu,", "pref, 3dlu, top:200dlu:grow"));
        CellConstraints cc = new CellConstraints();
        this.tagTableModel = new DicomHeaderTableModel(HeaderTag.getAllTags(), false, false);
        this.tagTable = new JTable(this.tagTableModel);
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(this.tagTableModel.getColumnSize(0));
        this.tagTable.getColumnModel().getColumn(1).setMaxWidth(this.tagTableModel.getColumnSize(1));
        this.tagTable.getSelectionModel().addListSelectionListener(this);
        this.tagTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    TagChooserDialog.this.ht = TagChooserDialog.this.tagTableModel.getHeaderTag(TagChooserDialog.this.tagTable.getSelectedRow());
                    TagChooserDialog.this.setVisible(false);
                }
            }
        });
        JPanel filterPanel = new JPanel((LayoutManager)new FormLayout("105px, 3dlu, 200px:grow", "pref"));
        this.nrFilter = new JTextField();
        filterPanel.add((Component)this.nrFilter, cc.xy(1, 1));
        this.nameFilter = new JTextField();
        filterPanel.add((Component)this.nameFilter, cc.xy(3, 1));
        KeyAdapter filterListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TagChooserDialog.this.filterTable();
            }
        };
        this.nrFilter.addKeyListener(filterListener);
        this.nameFilter.addKeyListener(filterListener);
        this.mainPanel.add((Component)filterPanel, cc.xy(1, 1));
        this.jsp = new JScrollPane(this.tagTable);
        this.jsp.setOpaque(false);
        this.jsp.getViewport().setOpaque(false);
        this.mainPanel.add((Component)this.jsp, cc.xy(1, 3));
        this.add((Component)this.mainPanel, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        this.closeButton = new JButton(Translatrix.getTranslationString((String)"dicom.Cancel"));
        this.closeButton.addActionListener(this);
        bb.addGridded((JComponent)this.closeButton);
        bb.addRelatedGap();
        this.okButton = new JButton(Translatrix.getTranslationString((String)"dicom.OK"));
        this.okButton.addActionListener(this);
        bb.addGridded((JComponent)this.okButton);
        this.add((Component)bb.getPanel(), "South");
        this.pack();
    }

    protected void filterTable() {
        this.tagTableModel.getNrFilter().setFilter(this.nrFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nrFilter.getText().length() > 0, 1);
        this.tagTableModel.getNameFilter().setFilter(this.nameFilter.getText());
        this.tagTableModel.setFilteringEnabled(this.nameFilter.getText().length() > 0, 2);
        this.tagTableModel.fireTableDataChanged();
    }

    public HeaderTag selectTag(HeaderTag ht) {
        this.ht = ht;
        if (ht != null) {
            this.nrFilter.setText(ht.getTagNr());
            this.nameFilter.setText("");
            this.filterTable();
        }
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        this.setVisible(true);
        return this.ht;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.tagTable.getSelectionModel()) && !e.getValueIsAdjusting()) {
            this.ht = this.tagTableModel.getHeaderTag(this.tagTable.getSelectedRow());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton)) {
            this.ht = this.tagTableModel.getHeaderTag(this.tagTable.getSelectedRow());
        } else if (e.getSource().equals(this.closeButton)) {
            this.ht = null;
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new TagChooserDialog().selectTag(null);
    }
}

