/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import java.util.Vector;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.utils.FilterTableModel;
import lu.tudor.santec.dicom.gui.utils.TableFilter;
import lu.tudor.santec.dicom.gui.utils.TableFulltextFilter;
import lu.tudor.santec.i18n.Translatrix;

public class DicomHeaderTableModel
extends FilterTableModel {
    private static final long serialVersionUID = 1L;
    private Vector<HeaderTag> headerTags = new Vector();
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.Tag.VR"), Translatrix.getTranslationString((String)"dicom.Tag.NR"), Translatrix.getTranslationString((String)"dicom.Tag.Name"), Translatrix.getTranslationString((String)"dicom.Tag.Value")};
    private int[] columnSizes = new int[]{30, 90, 200, 200};
    private boolean showValue;
    private TableFulltextFilter nrFilter;
    private TableFulltextFilter nameFilter;
    private boolean editable;

    public DicomHeaderTableModel(Vector<HeaderTag> headerTags, boolean showValue, boolean editable) {
        this.setTags(headerTags);
        this.showValue = showValue;
        this.editable = editable;
    }

    @Override
    public int getColumnCount() {
        if (this.showValue) {
            return 4;
        }
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.isFiltering()) {
            return this.getFilteredRowCount();
        }
        return this.headerTags.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HeaderTag ht;
        if (this.isFiltering()) {
            rowIndex = this.filteredToModel(rowIndex);
        }
        if ((ht = this.headerTags.get(rowIndex)) == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return ht.getTagVR();
            }
            case 1: {
                return ht.getTagNr();
            }
            case 2: {
                return ht.getTagName();
            }
            case 3: {
                return ht.getTagValue();
            }
        }
        return "";
    }

    public void setTags(Vector<HeaderTag> headerTags) {
        this.headerTags = headerTags;
        if (this.headerTags == null) {
            this.headerTags = new Vector();
        }
        this.setTableData(headerTags);
        this.fireTableDataChanged();
    }

    public void addTag(HeaderTag headerTag) {
        this.headerTags.add(headerTag);
        this.setTableData(this.headerTags);
        this.fireTableDataChanged();
    }

    public void removeTag(HeaderTag headerTag) {
        this.headerTags.remove(headerTag);
        this.setTableData(this.headerTags);
        this.fireTableDataChanged();
    }

    public HeaderTag getHeaderTag(int line) {
        try {
            if (this.isFiltering()) {
                line = this.filteredToModel(line);
            }
            return this.headerTags.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    public int getColumnSize(int column) {
        return this.columnSizes[column];
    }

    public TableFilter getNrFilter() {
        if (this.nrFilter == null) {
            this.nrFilter = new TableFulltextFilter();
            this.installFilter(this.nrFilter, 1);
        }
        return this.nrFilter;
    }

    public TableFilter getNameFilter() {
        if (this.nameFilter == null) {
            this.nameFilter = new TableFulltextFilter();
            this.installFilter(this.nameFilter, 2);
        }
        return this.nameFilter;
    }

    public Vector<HeaderTag> getHeaderTags() {
        return this.headerTags;
    }

    public void moveRow(int rowFrom, int toRow) {
        HeaderTag ht = this.headerTags.get(rowFrom);
        this.headerTags.remove(rowFrom);
        this.headerTags.add(toRow, ht);
        this.fireTableDataChanged();
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || columnIndex == 2) {
            return false;
        }
        return this.editable && columnIndex > 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.isFiltering()) {
            rowIndex = this.filteredToModel(rowIndex);
        }
        try {
            HeaderTag ht = this.headerTags.get(rowIndex);
            if (ht == null) {
                return;
            }
            switch (columnIndex) {
                case 1: {
                    ht.setTagNr((String)aValue);
                    String name = DicomHeader.getHeaderName((String)aValue);
                    if (name == null || "".equals(name)) {
                        name = (String)aValue;
                    }
                    ht.setTagName((String)aValue);
                    break;
                }
                case 2: {
                    ht.setTagName((String)aValue);
                    break;
                }
                case 3: {
                    ht.setTagValue((String)aValue);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRow(String tagNr) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (tagNr.equals(this.getValueAt(i, 1))) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

