/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.nio.CharBuffer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoDialog;

public class DicomHeaderInfoPanel
extends JPanel
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    public static final String FILE_CHANGED = "FILE_CHANGED";
    JTextArea infoField;
    private JTextField searchField;
    private JButton searchButton;
    private JScrollPane jsp;
    Highlighter.HighlightPainter infoHighlightPainter = new MyHighlightPainter(new Color(255, 255, 0));
    Highlighter.HighlightPainter diffHighlightPainter = new MyHighlightPainter(new Color(255, 0, 0, 40));
    private AdjustmentListener listener;
    protected File f;
    private DicomHeaderInfoDialog dicomHeaderInfoDialog;
    private int pos;

    public DicomHeaderInfoPanel(DicomHeaderInfoDialog dicomHeaderInfoDialog) {
        this.dicomHeaderInfoDialog = dicomHeaderInfoDialog;
        this.setLayout(new BorderLayout());
        this.buildPanel();
        if (dicomHeaderInfoDialog != null) {
            this.dicomHeaderInfoDialog.addWindowListener(this);
        }
    }

    private void buildPanel() {
        this.infoField = new JTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            public void replaceSelection(String content) {
                try {
                    content = content.replaceAll("file:/", "");
                    DicomHeaderInfoPanel.this.f = new File(content);
                    DicomHeader dh = new DicomHeader(DicomHeaderInfoPanel.this.f);
                    DicomHeaderInfoPanel.this.setInfo(dh);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.dicomHeaderInfoDialog != null) {
            this.infoField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == 'h' || e.getKeyChar() == 'H') {
                        DicomHeaderInfoPanel.this.dicomHeaderInfoDialog.setVisible(false);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 70 && e.isControlDown()) {
                        DicomHeaderInfoPanel.this.searchField.requestFocus();
                    }
                }
            });
        }
        this.infoField.setEditable(false);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)new JLabel("search:"), "West");
        this.searchField = new JTextField();
        jp.add((Component)this.searchField, "Center");
        this.searchButton = new JButton(DicomIcons.getIcon16("icon_search.png"));
        jp.add((Component)this.searchButton, "East");
        this.searchButton.addActionListener(this);
        this.searchField.addActionListener(this);
        this.add((Component)jp, "North");
        this.jsp = new JScrollPane(this.infoField);
        this.add((Component)this.jsp, "Center");
        this.setSize(600, 700);
    }

    public void setInfo(DicomHeader dh, boolean retainValues) {
        int scrollValue = this.jsp.getVerticalScrollBar().getValue();
        this.infoField.setText(dh.toString());
        this.infoField.setCaretPosition(0);
        this.firePropertyChange(FILE_CHANGED, null, this.f);
        if (retainValues) {
            this.search();
            this.jsp.getVerticalScrollBar().setValue(scrollValue);
        }
    }

    public void setInfo(DicomHeader dh) {
        this.setInfo(dh, false);
    }

    public void search() {
        this.highlight(this.infoField, this.searchField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.search();
    }

    public void highlight(JTextComponent textComp, String pattern) {
        this.removeHighlights(textComp, this.infoHighlightPainter);
        if (pattern == null || pattern.equals("")) {
            return;
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength()).toLowerCase();
            Pattern p = Pattern.compile(pattern.toLowerCase(), 8);
            Matcher m = p.matcher(CharBuffer.wrap(text.toCharArray()));
            boolean found = false;
            while (m.find()) {
                hilite.addHighlight(m.start(), m.end(), this.infoHighlightPainter);
                if (found) continue;
                this.pos = m.start();
                found = true;
            }
            textComp.setCaretPosition(this.pos);
            textComp.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void diff(JTextComponent textComp, String pattern) {
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            if (pattern.startsWith("---------")) {
                return;
            }
            int fromIndex = 0;
            int start = text.indexOf(pattern);
            while (start != -1) {
                fromIndex = start + pattern.length();
                hilite.addHighlight(start, fromIndex, this.diffHighlightPainter);
                start = text.indexOf(pattern, fromIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeHighlights(JTextComponent textComp, Highlighter.HighlightPainter highlighter) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter().equals(highlighter)) {
                hilite.removeHighlight(hilites[i]);
            }
            ++i;
        }
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listener = listener;
        this.jsp.getVerticalScrollBar().addAdjustmentListener(listener);
    }

    public void setAdjustment(int value) {
        this.jsp.getVerticalScrollBar().removeAdjustmentListener(this.listener);
        this.jsp.getVerticalScrollBar().setValue(value);
        this.jsp.getVerticalScrollBar().addAdjustmentListener(this.listener);
    }

    public void showDiff(Vector<String> diff) {
        this.removeHighlights(this.infoField, this.diffHighlightPainter);
        for (String element : diff) {
            this.diff(this.infoField, element);
        }
    }

    public String getText() {
        return this.infoField.getText();
    }

    public File getFile() {
        return this.f;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.infoField.requestFocus();
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

