/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoPanel;
import lu.tudor.santec.i18n.Translatrix;

public class DicomHeaderInfoDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DicomHeaderInfoPanel dicomHeaderInfoPanel;
    private Vector<JPanel> panels = new Vector();
    private JLabel sliceLabel;
    private JButton prevButton;
    private JButton nextButton;
    private Vector<DicomHeader> headers;
    int slice = 0;
    private JButton copy;
    private JButton close;

    public DicomHeaderInfoDialog(JDialog parent) {
        super(parent);
        this.setModal(true);
        this.buildPanel(false);
    }

    public DicomHeaderInfoDialog() {
        this.setTitle("DICOM Header");
        this.buildPanel(false);
    }

    public DicomHeaderInfoDialog(JDialog parent, boolean multiSlice) {
        super(parent);
        this.setModal(true);
        this.buildPanel(multiSlice);
    }

    public DicomHeaderInfoDialog(boolean multiSlice) {
        this.setTitle("DICOM Header");
        this.buildPanel(multiSlice);
    }

    private void buildPanel(boolean multiSlice) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("DICOM Header");
        JPanel slicePanel = new JPanel(new BorderLayout());
        this.prevButton = new JButton(DicomIcons.getIcon22("prev.png"));
        this.prevButton.addActionListener(this);
        slicePanel.add((Component)this.prevButton, "West");
        this.sliceLabel = new JLabel();
        this.sliceLabel.setFont(this.sliceLabel.getFont().deriveFont(16));
        this.sliceLabel.setHorizontalAlignment(0);
        this.sliceLabel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                DicomHeaderInfoDialog.this.setSlice(DicomHeaderInfoDialog.this.slice + e.getWheelRotation());
            }
        });
        slicePanel.add((Component)this.sliceLabel, "Center");
        this.nextButton = new JButton(DicomIcons.getIcon22("next.png"));
        this.nextButton.addActionListener(this);
        slicePanel.add((Component)this.nextButton, "East");
        if (multiSlice) {
            this.add((Component)slicePanel, "North");
        }
        this.dicomHeaderInfoPanel = new DicomHeaderInfoPanel(this);
        this.panels.add(this.dicomHeaderInfoPanel);
        this.add((Component)this.dicomHeaderInfoPanel, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.copy = new JButton(Translatrix.getTranslationString((String)"dicom.copy"));
        this.copy.addActionListener(this);
        bb.addGridded((JComponent)this.copy);
        bb.addRelatedGap();
        bb.addGlue();
        this.close = new JButton(Translatrix.getTranslationString((String)"dicom.close"));
        this.close.addActionListener(this);
        bb.addGridded((JComponent)this.close);
        this.add((Component)bb.getPanel(), "South");
        this.setSize(600, 700);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.close)) {
            this.setVisible(false);
        } else if (arg0.getSource().equals(this.copy)) {
            DicomHeaderInfoDialog.copy2Clipboard(this.dicomHeaderInfoPanel.getText());
        } else if (arg0.getSource().equals(this.prevButton)) {
            this.setSlice(this.slice - 1);
        } else if (arg0.getSource().equals(this.nextButton)) {
            this.setSlice(this.slice + 1);
        }
    }

    public void setInfo(DicomHeader dh) {
        this.slice = 0;
        this.dicomHeaderInfoPanel.setInfo(dh, true);
    }

    public void setInfo(File f) {
        DicomHeader dh = new DicomHeader(f);
        this.slice = 0;
        this.dicomHeaderInfoPanel.setInfo(dh, true);
    }

    public void setInfos(Collection<DicomHeader> dhs) {
        this.headers = new Vector<DicomHeader>(dhs);
        this.slice = 0;
        this.setSlice(this.slice);
    }

    public void setInfos(File[] files) {
        this.headers = new Vector();
        int i = 0;
        while (i < files.length) {
            this.headers.add(new DicomHeader(files[i]));
            ++i;
        }
        this.slice = 0;
        this.setSlice(this.slice);
    }

    private void setSlice(int slice) {
        if (slice >= this.headers.size()) {
            slice = this.headers.size() - 1;
        }
        if (slice < 0) {
            slice = 0;
        }
        this.slice = slice;
        this.sliceLabel.setText("Slice " + (slice + 1) + " of " + this.headers.size());
        this.dicomHeaderInfoPanel.setInfo(this.headers.get(slice), true);
    }

    public static void copy2Clipboard(String text) {
        try {
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DicomHeaderInfoDialog dhd = new DicomHeaderInfoDialog(true);
        dhd.setInfo(new File("/home/hermenj/tux.dcm"));
        dhd.setVisible(true);
    }
}

