/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import lu.tudor.santec.dicom.gui.DicomFilter;
import lu.tudor.santec.dicom.gui.DicomURLChooser;
import lu.tudor.santec.dicom.gui.ErrorDialog;
import lu.tudor.santec.dicom.gui.ImagePreviewDicom;
import lu.tudor.santec.dicom.gui.filechooser.DicomFileFilter;
import lu.tudor.santec.dicom.gui.filechooser.FILEPanelDicom;
import lu.tudor.santec.dicom.sender.DicomSender;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che.util.DcmURL;

public class FILEChooserDicom
extends JPanel
implements ActionListener,
PropertyChangeListener,
DicomFilter {
    private static final long serialVersionUID = 1L;
    private FILEPanelDicom filePanel;
    private JFileChooser fileChooser;
    private boolean send;
    private ProgressMonitor progressMonitor;
    private File[] arr;
    private DcmURL[] senders;
    private DicomSender dicomSender;
    private boolean disableListener;

    public FILEChooserDicom(File dir, FILEPanelDicom filePanel, boolean send, String[] dicomFields) {
        this.send = send;
        this.filePanel = filePanel;
        this.setLayout(new BorderLayout());
        this.fileChooser = new JFileChooser(dir);
        this.fileChooser.addActionListener(this);
        this.fileChooser.addPropertyChangeListener(this);
        this.fileChooser.setAccessory(new ImagePreviewDicom(this.fileChooser, filePanel.getDicomFileDialog(), dicomFields));
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setLocale(Translatrix.getLocale());
        this.add((Component)this.fileChooser, "Center");
        if (send) {
            this.fileChooser.setApproveButtonText(Translatrix.getTranslationString((String)"dicom.Send"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CancelSelection")) {
            this.filePanel.getDicomFileDialog().setRetValue(1);
            this.filePanel.getDicomFileDialog().setVisible(false);
        } else if (e.getActionCommand().equals("ApproveSelection") && this.fileChooser.getSelectedFile() != null) {
            this.selectFiles(this.fileChooser.getSelectedFiles());
            if (this.send) {
                this.send();
            } else {
                this.filePanel.getDicomFileDialog().setRetValue(0);
                this.filePanel.getDicomFileDialog().setVisible(false);
            }
        }
    }

    private void selectFiles(File[] fileArr) {
        this.disableListener = true;
        File f = fileArr[0];
        if (fileArr.length == 1 && f.isFile()) {
            this.filePanel.getDicomFileDialog().setSingleFileSelected(true);
            this.filePanel.getDicomFileDialog().setSelectedFile(f);
        } else {
            this.filePanel.getDicomFileDialog().setSingleFileSelected(false);
        }
        if (f.isDirectory()) {
            Object[] files = FILEChooserDicom.getFilesRecursive(f);
            Arrays.sort(files);
            this.filePanel.getDicomFileDialog().setSelectedFiles((File[])files);
        } else if (fileArr.length > 0) {
            Object[] files = fileArr;
            Arrays.sort(files);
            this.filePanel.getDicomFileDialog().setSelectedFiles((File[])files);
        }
        if (!this.filePanel.getDicomFileDialog().singleFileSelected) {
            this.filePanel.getDicomFileDialog().setSelectedFile(null);
        }
        this.disableListener = false;
    }

    public void setFile(File f) {
        if (!this.disableListener) {
            this.fileChooser.setSelectedFile(f);
            this.validate();
        }
    }

    private void send() {
        if (this.filePanel.getDicomFileDialog().getSingleFileSelected()) {
            this.arr = new File[1];
            this.arr[0] = this.filePanel.getDicomFileDialog().getSelectedFile();
        } else {
            this.arr = this.filePanel.getDicomFileDialog().getSelectedFiles();
        }
        DcmURL url = DicomURLChooser.showDialog(this.filePanel.getDicomFileDialog().getCurrentDialog(), this.senders);
        if (url == null) {
            return;
        }
        this.dicomSender = new DicomSender(url);
        this.progressMonitor = new ProgressMonitor(this.filePanel.getDicomFileDialog().getCurrentDialog(), "Sending Files to: \r\n" + this.dicomSender.getUrl(), "preparing", 0, this.arr.length);
        new Thread(){

            @Override
            public void run() {
                boolean firstError = true;
                FILEChooserDicom.this.filePanel.getDicomFileDialog().setWaitCursor(true);
                int i = 0;
                while (i < FILEChooserDicom.this.arr.length) {
                    block4: {
                        try {
                            File element = FILEChooserDicom.this.arr[i];
                            if (FILEChooserDicom.this.progressMonitor.isCanceled()) {
                                this.destroy();
                            }
                            FILEChooserDicom.this.progressMonitor.setNote("img " + element.getName() + " ( " + (i + 1) + " of " + (FILEChooserDicom.this.arr.length + 1) + " )");
                            FILEChooserDicom.this.progressMonitor.setProgress(i);
                            FILEChooserDicom.this.dicomSender.send(element);
                        }
                        catch (Exception e1) {
                            if (!firstError) break block4;
                            ErrorDialog.showErrorDialog((JDialog)FILEChooserDicom.this.filePanel.getDicomFileDialog(), "Error while sending File", e1.getLocalizedMessage(), (Throwable)e1);
                            firstError = false;
                        }
                    }
                    ++i;
                }
                FILEChooserDicom.this.progressMonitor.close();
                FILEChooserDicom.this.filePanel.getDicomFileDialog().setWaitCursor(false);
            }
        }.start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.disableListener = true;
        try {
            if (arg0.getPropertyName() != null && arg0.getNewValue() != null && "SelectedFileChangedProperty".equals(arg0.getPropertyName())) {
                this.filePanel.setFile(new File(arg0.getNewValue().toString()));
            }
        }
        catch (Exception e) {
            System.err.println("updating filechooser failed...." + arg0);
        }
        this.disableListener = false;
    }

    public static File[] getFilesRecursive(File dir) {
        ArrayList<File> al = new ArrayList<File>();
        FILEChooserDicom.visitAllFiles(dir, al);
        File[] files = new File[al.size()];
        int i = 0;
        Iterator<File> iter = al.iterator();
        while (iter.hasNext()) {
            File element;
            files[i] = element = iter.next();
            ++i;
        }
        return files;
    }

    private static void visitAllFiles(File dir, ArrayList<File> al) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                FILEChooserDicom.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.senders = senders;
    }

    @Override
    public void setDicomFilterTags(Vector headerTags) {
        this.fileChooser.resetChoosableFileFilters();
        if (headerTags != null && headerTags.size() > 0) {
            this.fileChooser.setFileFilter(new DicomFileFilter(headerTags));
        }
    }
}

