/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.filechooser;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;

public class DicomFileFilter
extends FileFilter {
    private Vector<HeaderTag> filterTags;
    private String description;

    public DicomFileFilter(Vector<HeaderTag> headerTags) {
        this.filterTags = headerTags;
        this.description = "DICOM Filter: ";
        for (HeaderTag ht : headerTags) {
            this.description = String.valueOf(this.description) + ht.tagName + "=" + ht.tagValue + " ";
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        boolean matches = true;
        DicomHeader dh = new DicomHeader(f);
        if (dh.isEmpty()) {
            return false;
        }
        Iterator<HeaderTag> iter = this.filterTags.iterator();
        while (iter.hasNext()) {
            try {
                HeaderTag ht = iter.next();
                if (ht.tagValue.matches(dh.getHeaderStringValue(ht.tagNr))) continue;
                matches = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dh = null;
        System.gc();
        return matches;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

