/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.dicomdir;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.DicomTableModel;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che2.data.DicomObject;

public class PatientTableModel
extends AbstractTableModel
implements DicomTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.PatientName"), Translatrix.getTranslationString((String)"dicom.PatientID")};
    private Vector<DicomObject> patients = new Vector();

    @Override
    public int getRowCount() {
        return this.patients.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex <= -1) {
                return null;
            }
            DicomObject dr = this.patients.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    try {
                        return dr.getString(0x100010).replaceAll("\\^", ",");
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
                case 1: {
                    return dr.getString(0x100020);
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPatients(Vector<DicomObject> patients) {
        this.patients = patients;
        this.fireTableDataChanged();
    }

    @Override
    public DicomObject getRecord(int line) {
        try {
            return this.patients.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }
}

