/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.dicomdir;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import lu.tudor.santec.dicom.gui.DICOMSettingsPlugin;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomFilter;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRSearchPanel;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRVIEW;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.dicom.receiver.DicomDirWatcher;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import lu.tudor.santec.dicom.receiver.DicomStorageServer;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;

public class PACSPanel
extends JPanel
implements DICOMDIRVIEW,
DicomFilter {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger((String)"PACSPanel");
    private JLabel pacsStatus;
    private JLabel pacsStatusIcon;
    private JLabel pacsStatusLabel;
    private DICOMDIRSearchPanel pacsPanel;
    private DicomStorageServer dicomStorageServer;
    private File file;
    private DicomFileDialog parent;
    public static final int SERVER_ON = 0;
    public static final int SERVER_OFF = 1;
    public static final int SERVER_UPDATE = 2;
    public static final int SERVER_RESET = 3;
    private JButton reloadButton;
    public Integer port;
    public String AET;
    private DicomDirReader ddr;

    public PACSPanel(File file, DicomFileDialog parent, int updateInterval) {
        this.file = file;
        this.parent = parent;
        CellConstraints cc = new CellConstraints();
        FormLayout fl = new FormLayout("6dlu, fill:200dlu:grow, 4dlu", "6dlu, fill:pref, 4dlu, fill:100dlu:grow");
        this.setLayout((LayoutManager)fl);
        this.pacsStatusLabel = new JLabel(Translatrix.getTranslationString((String)"dicom.PacsServerStatus"));
        this.pacsStatus = new JLabel();
        this.pacsStatusIcon = new JLabel();
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout((LayoutManager)new FormLayout("4dlu, pref, 4dlu, pref:grow, 4dlu, pref, 4dlu, pref, 4dlu", "2dlu, fill:20dlu, 2dlu"));
        statusPanel.setBorder(new LineBorder(new JTabbedPane().getBackground()));
        this.reloadButton = new JButton(DicomIcons.getIcon("icon_reload.png"));
        this.reloadButton.setToolTipText(Translatrix.getTranslationString((String)"refresh.DICOMDIR"));
        this.reloadButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PACSPanel.this.reload();
            }
        });
        statusPanel.add((Component)this.pacsStatusLabel, cc.xy(2, 2));
        statusPanel.add((Component)this.pacsStatus, cc.xy(4, 2));
        statusPanel.add((Component)this.reloadButton, cc.xy(6, 2));
        statusPanel.add((Component)this.pacsStatusIcon, cc.xy(8, 2));
        this.add((Component)statusPanel, cc.xyw(2, 2, 1));
        this.pacsPanel = new DICOMDIRSearchPanel(file, this, true, true, true, true, parent.dicomFields);
        this.ddr = this.pacsPanel.getDicomDirReader();
        this.add((Component)this.pacsPanel, cc.xyw(1, 4, 3));
        this.setServerStatus(1);
        new DicomDirWatcher(file, updateInterval, this);
    }

    @Override
    public void setPath(File f) {
        this.file = f;
        this.pacsPanel.setPath(this.file);
        this.dicomStorageServer.setDicomDirReader(this.pacsPanel.getDicomDirReader());
    }

    public File getPath() {
        return this.file;
    }

    public void reload() {
        this.pacsPanel.reIndex();
        this.dicomStorageServer.setDicomDirReader(this.pacsPanel.getDicomDirReader());
        this.setServerStatus(0);
    }

    public void setServerStatus(int status) {
        switch (status) {
            case 3: {
                if (this.dicomStorageServer == null || !this.dicomStorageServer.isRunning()) {
                    this.setServerStatus(1);
                    break;
                }
                this.setServerStatus(0);
                break;
            }
            case 0: {
                this.pacsStatus.setText(String.valueOf(Translatrix.getTranslationString((String)"dicom.PacsServerIsRunning")) + "  " + this.AET + "@" + DICOMSettingsPlugin.getIP() + ":" + this.port);
                this.pacsStatusIcon.setIcon(DicomIcons.getIcon("pacs_on.gif"));
                break;
            }
            case 2: {
                this.pacsStatus.setText(String.valueOf(Translatrix.getTranslationString((String)"dicom.PacsServerNewFiles")) + "  " + this.AET + "@" + DICOMSettingsPlugin.getIP() + ":" + this.port);
                this.pacsStatusIcon.setIcon(DicomIcons.getIcon("pacs_update.gif"));
                break;
            }
            default: {
                this.pacsStatus.setText(Translatrix.getTranslationString((String)"dicom.PacsServerIsOffline"));
                this.pacsStatusIcon.setIcon(DicomIcons.getIcon("pacs_off.gif"));
            }
        }
    }

    public void startDicomServer(String AET, Integer port) throws Exception {
        this.ddr = null;
        if (this.dicomStorageServer != null) {
            try {
                this.dicomStorageServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.AET = AET;
        this.port = port;
        this.dicomStorageServer = new DicomStorageServer(AET, port, this.file.getAbsolutePath(), false, "password", false, this.ddr);
        this.dicomStorageServer.start();
        this.setServerStatus(0);
    }

    public void stopDicomServer() {
        try {
            this.dicomStorageServer.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setServerStatus(1);
    }

    @Override
    public DicomFileDialog getParentDialog() {
        return this.parent;
    }

    @Override
    public void dicomdirChanged(DicomEvent d_Event) {
        log.info((Object)("----DICOM STORE changed: " + d_Event.getDicomDir()));
        if (this.isShowing()) {
            this.pacsPanel.updateView();
            this.setServerStatus(2);
        }
    }

    public void setDicomSenders(DcmURL[] senders) {
        if (senders != null) {
            this.pacsPanel.setDicomSenders(senders);
        }
    }

    @Override
    public void setDicomFilterTags(Vector headerTags) {
        this.pacsPanel.setDicomFilterTags(headerTags);
    }

    public void addDicomListener(DICOMListener dl) {
        this.dicomStorageServer.addDICOMListener(dl);
    }

    public void removeDicomListener(DICOMListener dl) {
        this.dicomStorageServer.removeDICOMListener(dl);
    }

    public DicomDirReader getDicomDir() {
        return this.ddr;
    }

    public void deleteRecord(String level, DicomHeader dh) throws Exception {
        this.ddr.deleteRecord(level, dh);
    }
}

