/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.dicomdir;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomFilter;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRFileFilter;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRSearchPanel;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRVIEW;
import lu.tudor.santec.dicom.receiver.DicomDirWatcher;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;
import sun.awt.shell.ShellFolder;

public class DICOMDIRPanel
extends JPanel
implements DICOMDIRVIEW,
ActionListener,
DicomFilter {
    private static final Logger log = Logger.getLogger((String)"DICOMDIRPanel");
    private static final long serialVersionUID = 1L;
    private JTextField fileField;
    private JButton chooseFileButton;
    private JButton reloadButton;
    private JLabel fileFieldLabel;
    private CardLayout cardLayout;
    private JPanel contentPanel;
    private JFileChooser dicomdirFileChooser;
    public DICOMDIRSearchPanel searchPanel;
    public DicomFileDialog parent;
    private File file;
    private DicomDirWatcher ddw;
    private int updateInterval;
    private static final String FILE_VIEW = "file";
    private static final String DICOMDIR_VIEW = "dicomdir";
    public static final int NO_UPDATE = -1;

    public DICOMDIRPanel(File file, DicomFileDialog parent, int updateInterval, boolean send, boolean delete) {
        this.parent = parent;
        this.file = file;
        this.updateInterval = updateInterval;
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        CellConstraints cc = new CellConstraints();
        FormLayout fl = new FormLayout("6dlu, 200dlu:grow, 4dlu", "6dlu, pref, 4dlu, fill:100dlu:grow");
        this.contentPanel = new JPanel((LayoutManager)fl);
        JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, 4dlu, 200dlu:grow, 4dlu, pref, 4dlu, pref, 4dlu", "2dlu, 20dlu, 2dlu"));
        buttonPanel.setBorder(new LineBorder(new JTabbedPane().getBackground()));
        this.fileFieldLabel = new JLabel(Translatrix.getTranslationString((String)"dicom.ChooseCD"));
        this.fileField = new JTextField(file.getAbsolutePath());
        this.chooseFileButton = new JButton("...");
        this.chooseFileButton.addActionListener(this);
        this.chooseFileButton.setToolTipText("Load DICOMDIR");
        this.reloadButton = new JButton(DicomIcons.getIcon("icon_reload.png"));
        this.reloadButton.setToolTipText("Refresh DICOMDIR");
        this.reloadButton.addActionListener(this);
        buttonPanel.add((Component)this.fileFieldLabel, cc.xy(2, 2));
        buttonPanel.add((Component)this.fileField, cc.xy(4, 2));
        buttonPanel.add((Component)this.chooseFileButton, cc.xy(6, 2));
        buttonPanel.add((Component)this.reloadButton, cc.xy(8, 2));
        this.contentPanel.add((Component)buttonPanel, cc.xy(2, 2));
        this.searchPanel = new DICOMDIRSearchPanel(file, this, true, delete, send, false, parent.dicomFields);
        this.contentPanel.add((Component)this.searchPanel, cc.xyw(1, 4, 3));
        this.add((Component)this.contentPanel, DICOMDIR_VIEW);
        this.dicomdirFileChooser = new JFileChooser(file);
        this.dicomdirFileChooser.addChoosableFileFilter(new DICOMDIRFileFilter());
        this.dicomdirFileChooser.addActionListener(this);
        this.add((Component)this.dicomdirFileChooser, FILE_VIEW);
        if (updateInterval > 0) {
            this.ddw = new DicomDirWatcher(file, updateInterval, this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.chooseFileButton)) {
            this.cardLayout.show(this, FILE_VIEW);
        } else if (e.getSource().equals(this.reloadButton)) {
            if (this.updateInterval < 0 && !this.file.getName().toUpperCase().endsWith("DICOMDIR") && !this.file.canRead()) {
                try {
                    System.out.println("find cdrom");
                    String os = System.getProperty("os.name").toLowerCase();
                    File[] drives = null;
                    drives = os.startsWith("win") ? ShellFolder.listRoots() : (os.startsWith("mac") ? new File("/Volumes").listFiles() : new File("/media").listFiles());
                    int i = 0;
                    while (i < drives.length) {
                        File dicomDir = new File(drives[i] + File.separator + "DICOMDIR");
                        if (dicomDir.canRead()) {
                            System.out.println("DICOM CD found at: " + dicomDir);
                            this.file = dicomDir;
                            break;
                        }
                        dicomDir = new File(drives[i] + File.separator + DICOMDIR_VIEW);
                        if (dicomDir.canRead()) {
                            System.out.println("DICOM CD found at: " + dicomDir);
                            this.file = dicomDir;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            this.setPath(this.file);
        } else if (e.getSource().equals(this.dicomdirFileChooser)) {
            if (e.getActionCommand().equals("ApproveSelection")) {
                this.file = this.dicomdirFileChooser.getSelectedFile();
                this.setPath(this.file);
                try {
                    this.ddw.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.updateInterval > 0) {
                    this.ddw = new DicomDirWatcher(this.file, this.updateInterval, this);
                }
            }
            this.cardLayout.show(this, DICOMDIR_VIEW);
        }
    }

    @Override
    public void setPath(File f) {
        this.searchPanel.setPath(f);
        this.fileField.setText(f.getAbsolutePath());
    }

    @Override
    public DicomFileDialog getParentDialog() {
        return this.parent;
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.searchPanel.setDicomSenders(senders);
    }

    @Override
    public void dicomdirChanged(DicomEvent d_Event) {
        log.info((Object)("DICOMDIR changed: " + d_Event.getDicomDir()));
        this.setPath(this.file);
    }

    @Override
    public void setDicomFilterTags(Vector headerTags) {
        this.searchPanel.setDicomFilterTags(headerTags);
    }
}

