/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.SpaceListener;

public class MemoryMonitorButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 3030537064914356613L;
    private Runtime rt = Runtime.getRuntime();
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private boolean drawLeds;
    private int SIZE = 32;
    private int BAR_WITH = 8;
    private int VOFFSET = 5;
    private int HOFFSET = 5;
    private static final Color USED = Color.RED;
    private static final Color ALLOC = Color.YELLOW;
    private static final Color FREE = Color.GREEN;
    private static final int LEDSPAN = 1;
    private static final int LEDSIZE = 2;
    private Vector<SpaceListener> listeners = new Vector();

    public MemoryMonitorButton(boolean enabled, boolean drawLeds) {
        this(enabled, drawLeds, 32);
    }

    public MemoryMonitorButton(boolean enabled, boolean drawLeds, int size) {
        this.SIZE = size;
        this.BAR_WITH = size / 4;
        this.HOFFSET = size / 6;
        this.setEnabled(enabled);
        this.setFocusPainted(false);
        this.drawLeds = drawLeds;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        try {
            this.setIcon(DicomIcons.getIcon("memory.png", size));
        }
        catch (Exception e) {
            System.out.println("Icon for memory button missing");
        }
        this.setSize(40, 40);
        this.addActionListener(this);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            MemoryMonitorButton.this.repaint();
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        double maxVM = this.rt.maxMemory() / 1024L;
        double totalAlloc = this.rt.totalMemory() / 1024L;
        double freeAlloc = this.rt.freeMemory() / 1024L;
        double used = totalAlloc - freeAlloc;
        double free = maxVM - used;
        double freeMB = free / 1024.0;
        if (this.drawLeds) {
            this.drawLeds(g, used, totalAlloc, maxVM);
        } else {
            this.drawBar(g, used, totalAlloc, maxVM);
        }
        this.setToolTipText("<html><h2>&nbsp;&nbsp; Memory Status: &nbsp;&nbsp;</h2><b>&nbsp;&nbsp; Max: </b>" + this.nf.format(maxVM / 1024.0) + " mb<br>" + "<b>&nbsp;&nbsp; Allocated: </b>" + this.nf.format(totalAlloc / 1024.0) + " mb<br>" + "<b>&nbsp;&nbsp; Used: </b>" + this.nf.format(used / 1024.0) + " mb<br>" + "<b>&nbsp;&nbsp; Free: </b>" + this.nf.format(free / 1024.0) + " mb<br>&nbsp;");
        for (SpaceListener listener : this.listeners) {
            if (!(freeMB <= (double)listener.getFreeMBLimit())) continue;
            listener.spaceLow(null, freeMB);
        }
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setLayout(new GridLayout(1, 0));
        jf.add(new MemoryMonitorButton(true, true, 22));
        jf.add(new MemoryMonitorButton(true, true, 22));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Running GC!");
        System.gc();
    }

    public void drawBar(Graphics g, double used, double totalAlloc, double maxVM) {
        int usedDraw = (int)(used / maxVM * 30.0);
        int allocDraw = (int)(totalAlloc / maxVM * 30.0);
        g.setColor(Color.BLACK);
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString("Mem", this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 2.5));
        g.drawString("Info", this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 1.2));
        g.setColor(FREE);
        g.fillRect(this.HOFFSET, this.VOFFSET, this.BAR_WITH, this.SIZE - 1);
        g.setColor(ALLOC);
        g.fillRect(this.HOFFSET, this.SIZE - allocDraw + this.VOFFSET, this.BAR_WITH, allocDraw);
        g.setColor(USED);
        g.fillRect(this.HOFFSET, this.SIZE - usedDraw + this.VOFFSET, this.BAR_WITH, usedDraw);
    }

    public void drawLeds(Graphics g, double used, double totalAlloc, double maxVM) {
        int usedDraw = this.SIZE - (int)(used / maxVM * 30.0);
        int allocDraw = this.SIZE - (int)(totalAlloc / maxVM * 30.0);
        g.setColor(Color.BLACK);
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString("Mem", this.HOFFSET + this.BAR_WITH + 2, this.VOFFSET + (int)((double)this.SIZE / 2.5));
        g.drawString("Info", this.HOFFSET + this.BAR_WITH + 2, this.VOFFSET + (int)((double)this.SIZE / 1.2));
        g.setColor(FREE);
        int i = 0;
        while (i <= this.SIZE) {
            if (this.VOFFSET + i >= allocDraw) {
                g.setColor(ALLOC);
            }
            if (this.VOFFSET + i >= usedDraw) {
                g.setColor(USED);
            }
            g.fillRect(this.HOFFSET, this.VOFFSET + i, this.BAR_WITH, 2);
            i += 3;
        }
    }

    public void addMemSpaceListener(SpaceListener dsl) {
        this.listeners.add(dsl);
    }

    public void removeMemSpaceListener(SpaceListener dsl) {
        this.listeners.remove(dsl);
    }
}

