/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import lu.tudor.santec.dicom.gui.DICOMSettingsPlugin;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.DicomSettings;
import lu.tudor.santec.dicom.gui.ImagePreviewDicom;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRPanel;
import lu.tudor.santec.dicom.gui.dicomdir.PACSPanel;
import lu.tudor.santec.dicom.gui.filechooser.FILEChooserDicom;
import lu.tudor.santec.dicom.gui.filechooser.FILEPanelDicom;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.query.QueryPanel;
import lu.tudor.santec.dicom.gui.selector.DicomFile;
import lu.tudor.santec.dicom.gui.selector.DicomMatcher;
import lu.tudor.santec.dicom.gui.selector.SelectorPanel;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.dicom.sender.DicomSender;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingListener;
import lu.tudor.santec.settings.SettingsPanel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;

public class DicomFileDialog
extends JDialog
implements SettingListener {
    private static Logger logger = Logger.getLogger((String)DicomFileDialog.class.getName());
    private JPanel dicomFilePanel;
    private static DicomFileDialog staticDialog;
    private static final long serialVersionUID = 1L;
    private JButtonBar bb;
    private JToggleButton fileButton;
    private JToggleButton pacsButton;
    private JToggleButton dicomcdButton;
    private JPanel contentPanel;
    private CardLayout cardLayout = new CardLayout();
    private DICOMDIRPanel dicomCDPanel;
    private FILEPanelDicom dicomFileChooser;
    public PACSPanel pacsPanel;
    private File[] selectedFiles;
    private File selectedFile;
    private int retValue = 1;
    public boolean singleFileSelected = false;
    protected DICOMSettingsPlugin dicomSettingsPlugin;
    private ButtonGroup group;
    private String error;
    private static final String FILE_VIEW = "file";
    private static final String PACS_VIEW = "pacs";
    private static final String DICOMCD_VIEW = "dicomcd";
    private static final String DICOMDIR_VIEW = "dicomdir";
    private static final String QUERY_VIEW = "query";
    private static final String SELECTOR_VIEW = "selector";
    private static final String FILTER_TAGS = "filtertags.properties";
    public String[] dicomFields = new String[]{""};
    private JToggleButton queryButton;
    public QueryPanel dicomQueryPanel;
    private DicomDirReader dicomDirReader;
    public JDialog dialog;
    private RootPaneContainer owner;
    private DcmURL[] senders;
    private JToggleButton dicomdirButton;
    private DICOMDIRPanel dicomdirPanel;
    private Vector dicomdirs = new Vector();
    private JToggleButton selectorButton;
    private SelectorPanel dicomSelectorPanel;
    private String[] defaultFields = new String[]{"0008,0060", "0008,1010", "0020,0013", "0018,0050", "0018,0060", "0008,0021", "0008,0031"};

    public DicomFileDialog(JFrame owner, SettingsPanel settingsPanel, DICOMSettingsPlugin dsp) {
        super(owner);
        this.owner = owner;
        this.dialog = this;
        this.createDicomFilePanel(settingsPanel, dsp);
        this.getContentPane().add((Component)this.dicomFilePanel, "Center");
    }

    public DicomFileDialog(JDialog owner, SettingsPanel settingsPanel, DICOMSettingsPlugin dsp) {
        super(owner);
        this.owner = owner;
        this.dialog = this;
        this.createDicomFilePanel(settingsPanel, dsp);
        this.getContentPane().add((Component)this.dicomFilePanel, "Center");
    }

    public DicomFileDialog(SettingsPanel settingsPanel, DICOMSettingsPlugin dsp) {
        this.dialog = this;
        this.createDicomFilePanel(settingsPanel, dsp);
        this.getContentPane().add((Component)this.dicomFilePanel, "Center");
    }

    private void createDicomFilePanel(SettingsPanel sp, DICOMSettingsPlugin dsp) {
        DicomFileDialog.initTranslatrix();
        sp.addSettingListener((SettingListener)this);
        Logger.getLogger((String)"loci").setLevel(Level.WARN);
        this.dicomSettingsPlugin = dsp;
        this.dicomFields = ((String)this.dicomSettingsPlugin.getValue("DicomFields")).split("\n");
        if (this.dicomFields.length == 0) {
            this.dicomFields = this.defaultFields;
        } else {
            int i = 0;
            while (i < this.dicomFields.length) {
                this.dicomFields[i] = this.dicomFields[i].trim();
                ++i;
            }
        }
        this.loadDicomSenders();
        this.dicomFilePanel = new JPanel();
        this.dicomFilePanel.setLayout(new BorderLayout());
        this.bb = new JButtonBar(1);
        this.bb.setPreferredSize(new Dimension(100, 40));
        this.group = new ButtonGroup();
        ImagePreviewDicom.showPreview = (Boolean)this.dicomSettingsPlugin.getValue("DicomShowPreview");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(this.cardLayout);
        this.dicomFilePanel.add((Component)this.contentPanel, "Center");
        this.dicomdirs.removeAllElements();
        this.showFilePanel();
        this.showPacsPanel();
        this.showQueryPanel();
        this.showDicomCDPanel();
        this.showDICOMDIRPanel();
        this.showSelectorPanel();
        this.dicomFilePanel.add((Component)this.bb, "West");
        try {
            ((JToggleButton)this.group.getElements().nextElement()).doClick();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDicomSenders() {
        try {
            String[] dicomSenders = ((String)this.dicomSettingsPlugin.getValue("SenderUrls")).split("\n");
            this.senders = new DcmURL[dicomSenders.length];
            int i = 0;
            while (i < dicomSenders.length) {
                this.senders[i] = new DcmURL(dicomSenders[i]);
                ++i;
            }
        }
        catch (Exception e) {
            logger.info((Object)"error loading dicom senders, check settings");
        }
    }

    public AbstractAction createTabAction(String text, Icon icon, String action) {
        class TabAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            public TabAction(String text, Icon icon, String action) {
                super(text, icon);
                this.putValue("ActionCommandKey", action);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomFileDialog.this.cardLayout.show(DicomFileDialog.this.contentPanel, e.getActionCommand());
                DicomFileDialog.this.setWaitCursor(false);
            }
        }
        return new TabAction(text, icon, action);
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public boolean getSingleFileSelected() {
        return this.singleFileSelected;
    }

    public void setSingleFileSelected(boolean singleFileSelected) {
        this.singleFileSelected = singleFileSelected;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        if (this.dicomFileChooser != null) {
            this.dicomFileChooser.setFile(selectedFile);
        }
    }

    private void center(Component parent, JDialog dialog) {
        dialog.setLocationRelativeTo(parent);
    }

    public JPanel getAsPanel() {
        return this.dicomFilePanel;
    }

    public int showDialog() {
        return this.showNewDialog(null, null);
    }

    public int showDialog(Vector headerTags) {
        return this.showNewDialog(null, headerTags);
    }

    public int showNewDialog(RootPaneContainer parent) {
        return this.showNewDialog(parent, null);
    }

    public int showNewDialog(RootPaneContainer parent, Vector headerTags) {
        if (this.dicomFileChooser != null) {
            this.dicomFileChooser.setDicomFilterTags(headerTags);
        }
        if (this.pacsPanel != null) {
            this.pacsPanel.setDicomFilterTags(headerTags);
        }
        if (this.dicomCDPanel != null) {
            this.dicomCDPanel.setDicomFilterTags(headerTags);
        }
        if (this.dicomdirPanel != null) {
            this.dicomdirPanel.setDicomFilterTags(headerTags);
        }
        JDialog jd = null;
        jd = parent instanceof JDialog ? new JDialog((JDialog)parent) : (parent instanceof JFrame ? new JDialog((JFrame)parent) : (this.owner instanceof JDialog ? new JDialog((JDialog)this.owner) : (this.owner instanceof JFrame ? new JDialog((JFrame)this.owner) : new JDialog())));
        jd.setModal(true);
        this.dialog = jd;
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)this.dicomFilePanel, "Center");
        this.setWaitCursor(false);
        if (this.pacsPanel != null) {
            this.pacsPanel.setServerStatus(3);
        }
        jd.validate();
        jd.setSize(850, 600);
        Component jc = (Component)((Object)this.owner);
        if (jc == null) {
            try {
                if (parent instanceof JDialog) {
                    jc = (Component)((Object)parent);
                } else if (parent instanceof JFrame) {
                    jc = (Component)((Object)parent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.center(jc, jd);
        jd.setVisible(true);
        return this.retValue;
    }

    public void setRetValue(int retValue) {
        this.retValue = retValue;
    }

    public void settingChanged(SettingEvent p_Event) {
        if (p_Event.getSource().equals((Object)this.dicomSettingsPlugin)) {
            try {
                this.dicomFields = ((String)this.dicomSettingsPlugin.getValue("DicomFields")).split("\n");
            }
            catch (Exception e) {
                logger.info((Object)("unable to set dicomFields to: " + this.dicomSettingsPlugin.getValue("DicomFields")));
            }
            if (this.dicomFields.length == 0) {
                this.dicomFields = this.defaultFields;
            } else {
                int i = 0;
                while (i < this.dicomFields.length) {
                    this.dicomFields[i] = this.dicomFields[i].trim();
                    ++i;
                }
            }
            this.loadDicomSenders();
            this.dicomdirs.removeAllElements();
            this.showFilePanel();
            this.showPacsPanel();
            this.showQueryPanel();
            this.showDicomCDPanel();
            this.showDICOMDIRPanel();
            this.showSelectorPanel();
            try {
                ((JButton)this.group.getElements().nextElement()).doClick();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JButton getToolBarButton() {
        return new JButton(DicomIcons.getIcon32("open.png"));
    }

    public Action getToolBarAction() {
        return new AbstractAction("", DicomIcons.getIcon32("open.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomFileDialog.this.showDialog();
            }
        };
    }

    private void showFilePanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("FileEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.fileButton);
            this.group.remove(this.fileButton);
            this.contentPanel.remove(this.dicomFileChooser);
            this.dicomFileChooser = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.fileButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.File"), DicomIcons.getIcon("open_file.png"), FILE_VIEW));
            this.bb.add((Component)this.fileButton);
            this.group.add(this.fileButton);
            this.dicomFileChooser = new FILEPanelDicom(new File((String)this.dicomSettingsPlugin.getValue("FileName")), this, (Boolean)this.dicomSettingsPlugin.getValue("SendEnabled"));
            this.dicomFileChooser.setDicomSenders(this.senders);
            this.contentPanel.add((Component)this.dicomFileChooser, FILE_VIEW);
        }
    }

    private void showQueryPanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("QueryEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.queryButton);
            this.group.remove(this.queryButton);
            this.contentPanel.remove(this.dicomQueryPanel);
            this.dicomFileChooser = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.queryButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.Query"), DicomIcons.getIcon("open_query.png"), QUERY_VIEW));
            this.bb.add((Component)this.queryButton);
            this.group.add(this.queryButton);
            String url = "dicom://" + (String)this.dicomSettingsPlugin.getValue("QueryToAET") + ":" + (String)this.dicomSettingsPlugin.getValue("RecAET") + "@" + (String)this.dicomSettingsPlugin.getValue("QueryToAddress") + ":" + (String)this.dicomSettingsPlugin.getValue("QueryToPort");
            DcmURL dcmUrl = new DcmURL(url);
            boolean openOnReceive = false;
            try {
                openOnReceive = (Boolean)this.dicomSettingsPlugin.getValue("QUERY_OPENONRECEIVE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dicomQueryPanel = new QueryPanel(dcmUrl, this, openOnReceive);
            String localDest = "dicom://" + this.dicomSettingsPlugin.getValue("RecAET");
            localDest = String.valueOf(localDest) + "@" + "localhost" + ":" + this.dicomSettingsPlugin.getValue("RecPort");
            DcmURL localDestUrl = new DcmURL(localDest);
            this.dicomQueryPanel.setLocalDest(localDestUrl);
            this.dicomQueryPanel.setDicomSenders(this.senders);
            this.dicomQueryPanel.setSearchString((String)this.dicomSettingsPlugin.getValue("QueryString"));
            this.contentPanel.add((Component)this.dicomQueryPanel, QUERY_VIEW);
        }
    }

    private void showPacsPanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("RecEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.pacsButton);
            this.group.remove(this.pacsButton);
            this.contentPanel.remove(this.pacsPanel);
            this.pacsPanel.stopDicomServer();
            this.pacsPanel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.dicomdirs.add((String)this.dicomSettingsPlugin.getValue("RecDir"));
            this.pacsPanel = new PACSPanel(new File((String)this.dicomSettingsPlugin.getValue("RecDir")), this, 2000);
            this.pacsButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.Pacs"), DicomIcons.getIcon("open_dicom_store.png"), PACS_VIEW));
            this.bb.add((Component)this.pacsButton);
            this.group.add(this.pacsButton);
            this.contentPanel.add((Component)this.pacsPanel, PACS_VIEW);
            this.pacsPanel.setDicomSenders(this.senders);
            try {
                this.pacsPanel.startDicomServer((String)this.dicomSettingsPlugin.getValue("RecAET"), new Integer((String)this.dicomSettingsPlugin.getValue("RecPort")));
                DcmURL url = new DcmURL("dicom://" + this.dicomSettingsPlugin.getValue("RecAET") + "@" + DICOMSettingsPlugin.getIP() + ":" + this.dicomSettingsPlugin.getValue("RecPort"));
                String retVal = DICOMSettingsPlugin.testPACS("LOCAL DICOM STORE", this.pacsPanel, url);
                if (retVal != null) {
                    logger.warn((Object)retVal);
                }
            }
            catch (Exception e) {
                String[] params = new String[]{String.valueOf(DICOMSettingsPlugin.getIP()), "" + this.dicomSettingsPlugin.getValue("RecPort")};
                JOptionPane.showMessageDialog(this, String.valueOf(Translatrix.getTranslationString((String)"dicom.StoreStartError", (String[])params)) + "\n" + e.getMessage(), "DICOM STORE ERROR", 0);
                logger.warn((Object)(String.valueOf(Translatrix.getTranslationString((String)"dicom.StoreStartError", (String[])params)) + "\n" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void showDicomCDPanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("DicomCDEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.dicomcdButton);
            this.group.remove(this.dicomcdButton);
            this.contentPanel.remove(this.dicomCDPanel);
            this.dicomCDPanel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.dicomcdButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.DicomCD"), DicomIcons.getIcon("open_dicomcd.png"), DICOMCD_VIEW));
            this.bb.add((Component)this.dicomcdButton);
            this.group.add(this.dicomcdButton);
            this.dicomCDPanel = new DICOMDIRPanel(new File((String)this.dicomSettingsPlugin.getValue("DicomCDName")), this, -1, (Boolean)this.dicomSettingsPlugin.getValue("RecEnabled"), false);
            this.dicomCDPanel.setDicomSenders(this.senders);
            this.contentPanel.add((Component)this.dicomCDPanel, DICOMCD_VIEW);
        }
    }

    private void showDICOMDIRPanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("DicomDirEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.dicomdirButton);
            this.group.remove(this.dicomdirButton);
            this.contentPanel.remove(this.dicomdirPanel);
            this.dicomdirPanel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.dicomdirs.add((String)this.dicomSettingsPlugin.getValue("DicomDirName"));
            this.dicomdirButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.Dicomdir"), DicomIcons.getIcon("open_dicom_dir.png"), DICOMDIR_VIEW));
            this.bb.add((Component)this.dicomdirButton);
            this.group.add(this.dicomdirButton);
            this.dicomdirPanel = new DICOMDIRPanel(new File((String)this.dicomSettingsPlugin.getValue("DicomDirName")), this, 2000, false, true);
            this.dicomdirPanel.setDicomSenders(this.senders);
            this.contentPanel.add((Component)this.dicomdirPanel, DICOMDIR_VIEW);
        }
    }

    private void showSelectorPanel() {
        boolean enabled = false;
        try {
            enabled = (Boolean)this.dicomSettingsPlugin.getValue("SELECTOR_ENABLED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bb.remove((Component)this.selectorButton);
            this.group.remove(this.selectorButton);
            this.contentPanel.remove(this.dicomSelectorPanel);
            this.dicomSelectorPanel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enabled) {
            this.selectorButton = new JToggleButton(this.createTabAction(Translatrix.getTranslationString((String)"dicom.Selector"), DicomIcons.getIcon("open_selector.png"), SELECTOR_VIEW));
            this.bb.add((Component)this.selectorButton);
            this.group.add(this.selectorButton);
            this.dicomSelectorPanel = new SelectorPanel(new File((String)this.dicomSettingsPlugin.getValue("SELECTOR_DIR")), this, (Boolean)this.dicomSettingsPlugin.getValue("RecEnabled"));
            this.dicomSelectorPanel.setDicomSenders(this.senders);
            String localDest = "dicom://" + this.dicomSettingsPlugin.getValue("RecAET");
            localDest = String.valueOf(localDest) + "@" + "localhost" + ":" + this.dicomSettingsPlugin.getValue("RecPort");
            DcmURL localDestUrl = new DcmURL(localDest);
            this.dicomSelectorPanel.setLocalDest(localDestUrl);
            Properties tags = new Properties();
            try {
                tags.load(new FileInputStream(FILTER_TAGS));
            }
            catch (FileNotFoundException e) {
                System.err.println("Filtertag settings not found at: filtertags.properties ...creating next time...");
            }
            catch (Exception e) {
                System.out.println(e.getLocalizedMessage());
            }
            Vector<HeaderTag> headerTags = new Vector<HeaderTag>();
            TreeSet<Object> set = new TreeSet<Object>(tags.keySet());
            for (String string : set) {
                headerTags.add(new HeaderTag(string, null, (String)tags.get(string)));
            }
            this.dicomSelectorPanel.setDicomFilterTags(HeaderTag.loadTags(FILTER_TAGS));
            this.contentPanel.add((Component)this.dicomSelectorPanel, SELECTOR_VIEW);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HeaderTag.saveTags(DicomFileDialog.FILTER_TAGS, (Vector<HeaderTag>)DicomFileDialog.this.dicomSelectorPanel.getDicomFilterTags());
                }
            });
        }
    }

    protected DicomSender createLocalDicomSender() {
        String url = "dicom://" + this.dicomSettingsPlugin.getValue("RecAET");
        url = String.valueOf(url) + "@" + "localhost" + ":" + this.dicomSettingsPlugin.getValue("RecPort");
        logger.info((Object)("created new Local Dicomsender: " + url));
        DcmURL dcmUrl = new DcmURL(url);
        return new DicomSender(dcmUrl);
    }

    public void setWaitCursor(boolean on) {
        if (on) {
            this.dialog.getGlassPane().setVisible(true);
            this.dialog.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.dialog.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.dialog.getGlassPane().setVisible(false);
        }
    }

    public String getError() {
        return this.error;
    }

    public File loadFileByImageURL(String imageUrl) throws Exception {
        for (String dicomdir : this.dicomdirs) {
            block6: {
                File image;
                logger.info((Object)("trying to load image from: " + dicomdir));
                this.dicomDirReader = new DicomDirReader();
                this.dicomDirReader.loadDicomDirFile(new File(dicomdir), false, false);
                if (imageUrl.indexOf("#") != -1 || (image = this.dicomDirReader.getImageFromSOPInstanceUID(imageUrl)) == null) break block6;
                logger.info((Object)("image loaded from: " + dicomdir));
                return image;
            }
            try {
                String[] parts = imageUrl.split("#");
                DicomMatcher dm = new DicomMatcher(null);
                HeaderTag[] htArr = null;
                htArr = parts.length == 1 ? new HeaderTag[]{new HeaderTag("0008,0018", null, parts[0])} : new HeaderTag[]{new HeaderTag("0020,000E", null, parts[0]), new HeaderTag("0020,0013", null, parts[1])};
                dm.setHeaderTags(htArr);
                Vector v = dm.findMachingFiles(new File(dicomdir).getParentFile());
                DicomFile file = (DicomFile)v.get(0);
                return file.getFile();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Exception e2) {
                    logger.warn((Object)("dicomdir: " + dicomdir + " does not exist"));
                }
            }
        }
        logger.warn((Object)"image not found");
        return null;
    }

    public String saveFiletoLocalPacs(File file) throws Exception {
        try {
            this.createLocalDicomSender().send(file);
        }
        catch (Exception e) {
            logger.warn((Object)("unable to save image to: " + this.createLocalDicomSender().getUrl()));
        }
        DicomHeader dh = new DicomHeader(file);
        String SOPInstanceUID = dh.getHeaderStringValue("0002,0003");
        if (SOPInstanceUID != "") {
            return SOPInstanceUID;
        }
        return String.valueOf(dh.getHeaderStringValue("0020,000E")) + "#" + dh.getHeaderStringValue("0020,0013");
    }

    public static DicomFileDialog getDicomFileDialog() {
        if (staticDialog == null) {
            DicomFileDialog.initTranslatrix();
            staticDialog = new DicomFileDialog(DicomSettings.getSettingPanel(), DicomSettings.getDicomSettingsPlugin());
        }
        return staticDialog;
    }

    public static DicomFileDialog getDicomFileDialog(JDialog parent) {
        if (staticDialog == null) {
            DicomFileDialog.initTranslatrix();
            staticDialog = new DicomFileDialog(parent, DicomSettings.getSettingPanel(), DicomSettings.getDicomSettingsPlugin());
        }
        return staticDialog;
    }

    public static DicomFileDialog getDicomFileDialog(JFrame parent) {
        if (staticDialog == null) {
            DicomFileDialog.initTranslatrix();
            staticDialog = new DicomFileDialog(parent, DicomSettings.getSettingPanel(), DicomSettings.getDicomSettingsPlugin());
        }
        return staticDialog;
    }

    public File[] getNextImagefromDicomDir(boolean series) throws Exception {
        this.dicomDirReader = new DicomDirReader();
        this.dicomDirReader.loadDicomDirFile(new File((String)this.dicomSettingsPlugin.getValue("RecDir")), false, false);
        return this.dicomDirReader.getNextImage(series);
    }

    public void deleteFileByImageURL(String imageUrl) throws Exception {
        this.dicomDirReader = new DicomDirReader();
        this.dicomDirReader.loadDicomDirFile(new File((String)this.dicomSettingsPlugin.getValue("RecDir")), false, false);
        String[] parts = imageUrl.split("#");
        System.out.println("deleting Image: " + imageUrl);
        this.dicomDirReader.deleteImageFromSeriesUID(parts[0], Integer.parseInt(parts[1]));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.dialog.setVisible(b);
        } else {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public JDialog getCurrentDialog() {
        return this.dialog;
    }

    public static void main(String[] args) {
        JFrame parent = new JFrame();
        DicomFileDialog dfd = new DicomFileDialog(parent, DicomSettings.getSettingPanel(), DicomSettings.getDicomSettingsPlugin());
        dfd.showDialog();
    }

    private static void initTranslatrix() {
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFromDicomDir(File f) {
        File path = this.pacsPanel.getPath();
        if (!path.isDirectory()) {
            path = path.getParentFile();
        }
        return f.getAbsolutePath().startsWith(path.getAbsolutePath());
    }

    public void deleteFromDicomDir(String level, DicomHeader dh) throws Exception {
        this.pacsPanel.deleteRecord(level, dh);
    }

    public File[] getFilesRecursive(File folder) {
        return FILEChooserDicom.getFilesRecursive(folder);
    }
}

