/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import lu.tudor.santec.dicom.gui.ButtonEditor;
import lu.tudor.santec.dicom.gui.ButtonRenderer;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.DicomURLTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRFileFilter;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.header.TagChooserDialog;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.dicom.utils.DCMEcho;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingsPlugin;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;

public class DICOMSettingsPlugin
extends SettingsPlugin {
    private static final long serialVersionUID = 1L;
    public static final String FILE_ENABLED = "FileEnabled";
    public static final String FILE_NAME = "FileName";
    public static final String DICOMDIR_ENABLED = "DicomDirEnabled";
    public static final String DICOMDIR_NAME = "DicomDirName";
    public static final String DICOMCD_ENABLED = "DicomCDEnabled";
    public static final String DICOMCD_NAME = "DicomCDName";
    public static final String REC_ENABLED = "RecEnabled";
    public static final String REC_DIR = "RecDir";
    public static final String REC_AET = "RecAET";
    public static final String REC_PORT = "RecPort";
    public static final String QUERY_ENABLED = "QueryEnabled";
    public static final String QUERY_STRING = "QueryString";
    public static final String QUERY_TO_ADDRESS = "QueryToAddress";
    public static final String QUERY_TO_PORT = "QueryToPort";
    public static final String QUERY_TO_AET = "QueryToAET";
    public static final String SENDER_ENABLED = "SendEnabled";
    public static final String SENDER_URLS = "SenderUrls";
    public static final String DICOM_FIELDS = "DicomFields";
    public static final String DICOM_SHOWIMAGEPREVIEW = "DicomShowPreview";
    public static final String SELECTOR_ENABLED = "SELECTOR_ENABLED";
    public static final String SELECTOR_DIR = "SELECTOR_DIR";
    public static final String QUERY_OPENONRECEIVE = "QUERY_OPENONRECEIVE";
    public static final String TRY_OPEN_VIA_IMAGEJ = "TRY_OPEN_VIA_IMAGEJ";
    private JCheckBox fileEnabled;
    private JTextField fileName;
    private JButton chooseFile;
    private JLabel fileNameLabel;
    private JFileChooser fileChooser;
    private JPanel filePanel;
    private JPanel dicomRecPanel;
    private JPanel dicomSendPanel;
    protected JFileChooser recDirChooser;
    private JButton chooseRecDir;
    private JTextField recDir;
    private JCheckBox recEnabled;
    private JLabel recDirLabel;
    private JLabel recAETLabel;
    private JTextField recAET;
    private JLabel recPortLabel;
    private JCheckBox sendEnabled;
    private JTextField recPort;
    private JCheckBox dicomdirEnabled;
    private JTextField dicomdirName;
    private JButton chooseDicomDirFile;
    protected JFileChooser dicomdirChooser;
    private JPanel dicomdir;
    private JLabel dicomdirLabel;
    private JTextArea dicomHeader;
    private JLabel dicomHeaderLabel;
    private JPanel dicomHeaderPanel;
    private JPanel dicomQueryPanel;
    private JLabel queryToAddressLabel;
    private JTextField queryToAddress;
    private JLabel queryToPortLabel;
    private JTextField queryToPort;
    private JLabel queryToAETLabel;
    private JTextField queryToAET;
    private JCheckBox queryEnabled;
    private JCheckBox queryOpenOnReceive;
    private JCheckBox showPreview;
    private JTable senderUrls;
    private DicomURLTableModel senderTableModel;
    private JButton addSenderButton;
    private JButton deleteSenderButton;
    private JPanel dicomCD;
    private JCheckBox dicomCDEnabled;
    private JButton chooseDicomCDFile;
    private JLabel dicomCDLabel;
    private JTextField dicomCDName;
    private JButton jb;
    private JLabel queryStringLabel;
    private JTextField queryString;
    private JPanel selectorPanel;
    private JCheckBox selectorEnabled;
    private JButton selectorChooseFile;
    private JLabel selectorNameLabel;
    private JTextField selectorFileName;
    private boolean simpleMode = false;
    private JLabel recIPLabel;
    private JLabel recAddressLabel;
    private JLabel reindexLabel;
    private JLabel reindexDesc;
    private JButton reindexButton;
    private boolean singleSender;
    private boolean showDicomDir = true;
    private boolean showImageSelector = true;
    private boolean showStore = true;
    private boolean showQuery = true;
    private boolean showSend = true;
    private JCheckBox openViaImageJ;
    private JPanel generalPanel;
    private JLabel openViaImageJLabel;
    private static Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.gui.DICOMPlugin");
    private static final ImageIcon FAILED = DicomIcons.getIcon("status_failed.png");
    private static final ImageIcon OK = DicomIcons.getIcon("status_ok.png");
    private static final ImageIcon UNKNOWN = DicomIcons.getIcon("status_unknown.png");

    public DICOMSettingsPlugin(String name) {
        super(name);
        this.init();
    }

    public DICOMSettingsPlugin(String name, boolean simpleMode) {
        super(name);
        this.simpleMode = simpleMode;
        this.init();
    }

    public DICOMSettingsPlugin(String name, boolean showDicomDir, boolean showStore, boolean showQuery, boolean showSend, boolean showImageSelector) {
        super(name);
        this.showDicomDir = showDicomDir;
        this.showStore = showStore;
        this.showQuery = showQuery;
        this.showSend = showSend;
        this.showImageSelector = showImageSelector;
        this.init();
    }

    private void init() {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure();
        }
        Logger.getLogger((String)"org.dcm4che2").setLevel(Level.WARN);
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIcon(DicomIcons.getIcon("open.png"));
        this.setStationaryValues();
        this.buildPanel();
        this.jb.doClick();
        this.relocalize();
    }

    private void buildPanel() {
        this.initComponents();
        CellConstraints cc = new CellConstraints();
        this.generalPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.General"));
        FormLayout generalLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.generalPanel.setLayout((LayoutManager)generalLayout);
        this.generalPanel.add((Component)this.openViaImageJ, cc.xyw(1, 1, 7));
        this.generalPanel.add((Component)this.openViaImageJLabel, cc.xy(1, 3));
        this.addSubPanel(this.generalPanel);
        this.filePanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.FileInput"));
        FormLayout fileLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.filePanel.setLayout((LayoutManager)fileLayout);
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)this.chooseFile, "East");
        this.filePanel.add((Component)this.fileEnabled, cc.xyw(1, 1, 3));
        this.filePanel.add((Component)this.fileNameLabel, cc.xy(1, 3));
        this.filePanel.add((Component)fileChooserPanel, cc.xyw(3, 3, 7));
        this.addSubPanel(this.filePanel);
        this.dicomCD = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomCDInput"));
        FormLayout dicomCDLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.dicomCD.setLayout((LayoutManager)dicomCDLayout);
        JPanel dicomCDChooserPanel = new JPanel(new BorderLayout());
        dicomCDChooserPanel.add((Component)this.dicomCDName, "Center");
        dicomCDChooserPanel.add((Component)this.chooseDicomCDFile, "East");
        this.dicomCD.add((Component)this.dicomCDEnabled, cc.xyw(1, 1, 3));
        this.dicomCD.add((Component)this.dicomCDLabel, cc.xy(1, 3));
        this.dicomCD.add((Component)dicomCDChooserPanel, cc.xyw(3, 3, 7));
        this.addSubPanel(this.dicomCD);
        this.dicomdir = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomDirInput"));
        FormLayout dicomdirLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.dicomdir.setLayout((LayoutManager)dicomdirLayout);
        JPanel dicomdirChooserPanel = new JPanel(new BorderLayout());
        dicomdirChooserPanel.add((Component)this.dicomdirName, "Center");
        dicomdirChooserPanel.add((Component)this.chooseDicomDirFile, "East");
        this.dicomdir.add((Component)this.dicomdirEnabled, cc.xyw(1, 1, 3));
        this.dicomdir.add((Component)this.dicomdirLabel, cc.xy(1, 3));
        this.dicomdir.add((Component)dicomdirChooserPanel, cc.xyw(3, 3, 7));
        if (!this.simpleMode && this.showDicomDir) {
            this.addSubPanel(this.dicomdir);
        }
        this.dicomRecPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomRec"));
        FormLayout dicomRecLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu");
        this.dicomRecPanel.setLayout((LayoutManager)dicomRecLayout);
        JPanel dicomRecChooserPanel = new JPanel(new BorderLayout());
        dicomRecChooserPanel.add((Component)this.recDir, "Center");
        dicomRecChooserPanel.add((Component)this.chooseRecDir, "East");
        this.dicomRecPanel.add((Component)this.recEnabled, cc.xyw(1, 1, 3));
        this.dicomRecPanel.add((Component)this.recAddressLabel, cc.xyw(1, 3, 3));
        this.dicomRecPanel.add((Component)this.recIPLabel, cc.xyw(3, 3, 7));
        this.dicomRecPanel.add((Component)this.recDirLabel, cc.xy(1, 5));
        this.dicomRecPanel.add((Component)dicomRecChooserPanel, cc.xyw(3, 5, 7));
        this.dicomRecPanel.add((Component)this.recAETLabel, cc.xy(1, 7));
        this.dicomRecPanel.add((Component)this.recAET, cc.xyw(3, 7, 3));
        this.dicomRecPanel.add((Component)this.recPortLabel, cc.xy(7, 7));
        this.dicomRecPanel.add((Component)this.recPort, cc.xy(9, 7));
        this.dicomRecPanel.add((Component)this.reindexLabel, cc.xy(1, 9));
        this.dicomRecPanel.add((Component)this.reindexDesc, cc.xyw(3, 9, 5));
        this.dicomRecPanel.add((Component)this.reindexButton, cc.xy(9, 9));
        if (!this.simpleMode && this.showStore) {
            this.addSubPanel(this.dicomRecPanel);
        }
        this.dicomQueryPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomQuery"));
        FormLayout dicomQueryLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 20dlu, 10dlu", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu");
        this.dicomQueryPanel.setLayout((LayoutManager)dicomQueryLayout);
        this.dicomQueryPanel.add((Component)this.queryEnabled, cc.xyw(1, 1, 3));
        this.jb = this.createTestButton();
        this.dicomQueryPanel.add((Component)this.jb, cc.xy(10, 1));
        this.dicomQueryPanel.add((Component)this.queryStringLabel, cc.xy(1, 3));
        this.dicomQueryPanel.add((Component)this.queryString, cc.xyw(3, 3, 8));
        this.dicomQueryPanel.add((Component)this.queryToAddressLabel, cc.xy(1, 5));
        this.dicomQueryPanel.add((Component)this.queryToAddress, cc.xyw(3, 5, 3));
        this.dicomQueryPanel.add((Component)this.queryToPortLabel, cc.xy(7, 5));
        this.dicomQueryPanel.add((Component)this.queryToPort, cc.xyw(9, 5, 2));
        this.dicomQueryPanel.add((Component)this.queryToAETLabel, cc.xy(1, 7));
        this.dicomQueryPanel.add((Component)this.queryToAET, cc.xyw(3, 7, 8));
        this.dicomQueryPanel.add((Component)this.queryOpenOnReceive, cc.xyw(3, 9, 8));
        if (!this.simpleMode && this.showQuery) {
            this.addSubPanel(this.dicomQueryPanel);
        }
        this.selectorPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.Selector"));
        FormLayout selectorLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.selectorPanel.setLayout((LayoutManager)selectorLayout);
        JPanel selectorChooserPanel = new JPanel(new BorderLayout());
        selectorChooserPanel.add((Component)this.selectorFileName, "Center");
        selectorChooserPanel.add((Component)this.selectorChooseFile, "East");
        this.selectorPanel.add((Component)this.selectorEnabled, cc.xyw(1, 1, 3));
        this.selectorPanel.add((Component)this.selectorNameLabel, cc.xy(1, 3));
        this.selectorPanel.add((Component)selectorChooserPanel, cc.xyw(3, 3, 7));
        if (!this.simpleMode && this.showImageSelector) {
            this.addSubPanel(this.selectorPanel);
        }
        this.dicomSendPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomSend"));
        FormLayout dicomSendLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 10dlu, 2dlu, 70dlu:grow, 2dlu, 70dlu:grow", "pref, 2dlu, 50dlu, 2dlu, pref, 2dlu, pref, 2dlu");
        this.dicomSendPanel.setLayout((LayoutManager)dicomSendLayout);
        this.dicomSendPanel.add((Component)this.sendEnabled, cc.xyw(1, 1, 3));
        this.dicomSendPanel.add((Component)new JScrollPane(this.senderUrls), cc.xyw(1, 3, 9));
        this.dicomSendPanel.add((Component)this.deleteSenderButton, cc.xyw(7, 5, 1));
        this.dicomSendPanel.add((Component)this.addSenderButton, cc.xyw(9, 5, 1));
        if (!this.simpleMode && this.showSend) {
            this.addSubPanel(this.dicomSendPanel);
        }
        this.dicomHeaderPanel = this.createSubPanel(Translatrix.getTranslationString((String)"dicom.DicomHeader"));
        FormLayout dicomHeaderLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu, fill:70dlu, 2dlu");
        this.dicomHeaderPanel.setLayout((LayoutManager)dicomHeaderLayout);
        this.dicomHeaderPanel.add((Component)this.showPreview, cc.xyw(1, 1, 7));
        this.dicomHeaderPanel.add((Component)this.dicomHeaderLabel, cc.xy(1, 3));
        JButton chooseTag = new JButton("choose Tag");
        chooseTag.addActionListener(new ActionListener(){
            private TagChooserDialog chooseTagDialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                HeaderTag ht;
                if (this.chooseTagDialog == null) {
                    try {
                        Container parent = DICOMSettingsPlugin.this.getParent();
                        while ((parent = parent.getParent()) != null && !(parent instanceof JDialog)) {
                        }
                        this.chooseTagDialog = new TagChooserDialog((JDialog)parent);
                    }
                    catch (Exception e2) {
                        this.chooseTagDialog = new TagChooserDialog();
                    }
                }
                if ((ht = this.chooseTagDialog.selectTag(null)) != null) {
                    DICOMSettingsPlugin.this.dicomHeader.append("\n" + ht.getTagNr());
                }
            }
        });
        this.dicomHeaderPanel.add((Component)chooseTag, cc.xy(1, 5));
        this.dicomHeaderPanel.add((Component)new JScrollPane(this.dicomHeader), cc.xywh(3, 3, 7, 3));
        this.addSubPanel(this.dicomHeaderPanel);
    }

    private void initComponents() {
        this.openViaImageJ = new JCheckBox();
        this.openViaImageJLabel = new JLabel();
        this.fileEnabled = new JCheckBox();
        this.chooseFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DICOMSettingsPlugin.this.fileChooser = new JFileChooser(DICOMSettingsPlugin.this.fileName.getText());
                DICOMSettingsPlugin.this.fileChooser.setFileSelectionMode(1);
                if (DICOMSettingsPlugin.this.fileChooser.showOpenDialog(DICOMSettingsPlugin.this.getParent()) == 0) {
                    DICOMSettingsPlugin.this.fileName.setText(DICOMSettingsPlugin.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.fileNameLabel = new JLabel();
        this.fileName = new JTextField();
        this.fileName.setEditable(false);
        this.dicomCDEnabled = new JCheckBox();
        this.chooseDicomCDFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;
            private JFileChooser dicomCDChooser;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dicomCDChooser = new JFileChooser(DICOMSettingsPlugin.this.dicomCDName.getText());
                this.dicomCDChooser.setFileFilter(new DICOMDIRFileFilter());
                this.dicomCDChooser.setFileSelectionMode(2);
                if (this.dicomCDChooser.showOpenDialog(DICOMSettingsPlugin.this.getParent()) == 0) {
                    if (this.dicomCDChooser.getSelectedFile().isFile()) {
                        DICOMSettingsPlugin.this.dicomCDName.setText(this.dicomCDChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        DICOMSettingsPlugin.this.dicomCDName.setText(String.valueOf(this.dicomCDChooser.getSelectedFile().getAbsolutePath()) + File.separator + "DICOMDIR");
                    }
                }
            }
        });
        this.dicomCDLabel = new JLabel();
        this.dicomCDName = new JTextField();
        this.dicomCDName.setEditable(false);
        this.dicomdirEnabled = new JCheckBox();
        this.chooseDicomDirFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DICOMSettingsPlugin.this.dicomdirChooser = new JFileChooser(DICOMSettingsPlugin.this.dicomdirName.getText());
                DICOMSettingsPlugin.this.dicomdirChooser.setFileFilter(new DICOMDIRFileFilter());
                DICOMSettingsPlugin.this.dicomdirChooser.setFileSelectionMode(2);
                if (DICOMSettingsPlugin.this.dicomdirChooser.showOpenDialog(DICOMSettingsPlugin.this.getParent()) == 0) {
                    if (DICOMSettingsPlugin.this.dicomdirChooser.getSelectedFile().isFile()) {
                        DICOMSettingsPlugin.this.dicomdirName.setText(DICOMSettingsPlugin.this.dicomdirChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        DICOMSettingsPlugin.this.dicomdirName.setText(String.valueOf(DICOMSettingsPlugin.this.dicomdirChooser.getSelectedFile().getAbsolutePath()) + File.separator + "DICOMDIR");
                    }
                }
            }
        });
        this.dicomdirLabel = new JLabel();
        this.dicomdirName = new JTextField();
        this.dicomdirName.setEditable(false);
        this.recEnabled = new JCheckBox();
        this.recAddressLabel = new JLabel();
        this.recIPLabel = new JLabel();
        this.recIPLabel.setText(DICOMSettingsPlugin.getIP());
        this.chooseRecDir = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DICOMSettingsPlugin.this.recDirChooser = new JFileChooser(DICOMSettingsPlugin.this.recDir.getText());
                DICOMSettingsPlugin.this.recDirChooser.addChoosableFileFilter(new DICOMDIRFileFilter());
                DICOMSettingsPlugin.this.recDirChooser.setFileSelectionMode(2);
                if (DICOMSettingsPlugin.this.recDirChooser.showOpenDialog(DICOMSettingsPlugin.this.getParent()) == 0) {
                    if (DICOMSettingsPlugin.this.recDirChooser.getSelectedFile().isFile()) {
                        DICOMSettingsPlugin.this.recDir.setText(DICOMSettingsPlugin.this.recDirChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        DICOMSettingsPlugin.this.recDir.setText(String.valueOf(DICOMSettingsPlugin.this.recDirChooser.getSelectedFile().getAbsolutePath()) + File.separator + "DICOMDIR");
                    }
                }
            }
        });
        this.recDirLabel = new JLabel();
        this.recDir = new JTextField();
        this.recDir.setEditable(false);
        this.recAETLabel = new JLabel();
        this.recAET = new JTextField();
        this.recPortLabel = new JLabel();
        this.recPort = new JTextField();
        this.recPort.setDocument(new NumberValidation());
        this.reindexLabel = new JLabel(Translatrix.getTranslationString((String)"dicom.reindex"));
        this.reindexDesc = new JLabel(Translatrix.getTranslationString((String)"dicom.reindexDesc"));
        this.reindexButton = new JButton(new AbstractAction("", DicomIcons.getIcon16("filter_edit.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DICOMSettingsPlugin.this.reindex(new File(DICOMSettingsPlugin.this.recDir.getText()), (JComponent)((Object)DICOMSettingsPlugin.this));
            }
        });
        this.queryEnabled = new JCheckBox();
        this.queryStringLabel = new JLabel();
        this.queryString = new JTextField();
        this.queryToAddressLabel = new JLabel();
        this.queryToAddress = new JTextField();
        this.queryToPortLabel = new JLabel();
        this.queryToPort = new JTextField();
        this.queryToPort.setDocument(new NumberValidation());
        this.queryToAETLabel = new JLabel();
        this.queryToAET = new JTextField();
        this.queryOpenOnReceive = new JCheckBox();
        this.selectorEnabled = new JCheckBox();
        this.selectorChooseFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;
            private JFileChooser selectorFileChooser;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.selectorFileChooser = new JFileChooser(DICOMSettingsPlugin.this.selectorFileName.getText());
                this.selectorFileChooser.setFileSelectionMode(1);
                this.selectorFileChooser.showOpenDialog(DICOMSettingsPlugin.this.getParent());
                if (this.selectorFileChooser.getSelectedFile() != null) {
                    DICOMSettingsPlugin.this.selectorFileName.setText(this.selectorFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.selectorNameLabel = new JLabel();
        this.selectorFileName = new JTextField();
        this.selectorFileName.setEditable(false);
        this.sendEnabled = new JCheckBox();
        this.senderTableModel = new DicomURLTableModel(true);
        this.senderUrls = new JTable(this.senderTableModel);
        this.senderUrls.getColumnModel().getColumn(3).setMaxWidth(50);
        this.senderUrls.getColumnModel().getColumn(4).setCellRenderer(new ButtonRenderer());
        this.senderUrls.getColumnModel().getColumn(4).setCellEditor(new ButtonEditor());
        this.senderUrls.getColumnModel().getColumn(4).setMaxWidth(30);
        this.addSenderButton = new JButton();
        this.addSenderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DICOMSettingsPlugin.this.singleSender && DICOMSettingsPlugin.this.senderTableModel.getRowCount() > 0) {
                    return;
                }
                DICOMSettingsPlugin.this.senderTableModel.addLine(new DcmURL("dicom://receiver:sender@host:5104"));
            }
        });
        this.deleteSenderButton = new JButton();
        this.deleteSenderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DICOMSettingsPlugin.this.senderTableModel.removeLine(DICOMSettingsPlugin.this.senderUrls.getSelectedRow());
                if (DICOMSettingsPlugin.this.singleSender && DICOMSettingsPlugin.this.senderTableModel.getRowCount() == 0) {
                    DICOMSettingsPlugin.this.addSenderButton.setEnabled(true);
                }
            }
        });
        this.showPreview = new JCheckBox();
        this.dicomHeader = new JTextArea();
        this.dicomHeaderLabel = new JLabel();
        this.dicomHeaderLabel.setVerticalAlignment(1);
    }

    public static String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void revertToDefaults() {
        this.openViaImageJ.setSelected((Boolean)this.getDefault(TRY_OPEN_VIA_IMAGEJ));
        this.fileEnabled.setSelected((Boolean)this.getDefault(FILE_ENABLED));
        this.fileName.setText((String)this.getDefault(FILE_NAME));
        this.dicomCDEnabled.setSelected((Boolean)this.getDefault(DICOMCD_ENABLED));
        this.dicomCDName.setText((String)this.getDefault(DICOMCD_NAME));
        this.dicomdirEnabled.setSelected((Boolean)this.getDefault(DICOMDIR_ENABLED));
        this.dicomdirName.setText((String)this.getDefault(DICOMDIR_NAME));
        this.recEnabled.setSelected((Boolean)this.getDefault(REC_ENABLED));
        this.recDir.setText((String)this.getDefault(REC_DIR));
        this.recAET.setText((String)this.getDefault(REC_AET));
        this.recPort.setText((String)this.getDefault(REC_PORT));
        this.queryEnabled.setSelected((Boolean)this.getDefault(QUERY_ENABLED));
        this.queryString.setText((String)this.getDefault(QUERY_STRING));
        this.queryToAddress.setText((String)this.getDefault(QUERY_TO_ADDRESS));
        this.queryToPort.setText((String)this.getDefault(QUERY_TO_PORT));
        this.queryToAET.setText((String)this.getDefault(QUERY_TO_AET));
        this.selectorEnabled.setSelected((Boolean)this.getDefault(SELECTOR_ENABLED));
        this.selectorFileName.setText((String)this.getDefault(SELECTOR_DIR));
        this.sendEnabled.setSelected((Boolean)this.getDefault(SENDER_ENABLED));
        this.senderTableModel.setUrls((String)this.getDefault(SENDER_URLS));
        this.dicomHeader.setText((String)this.getDefault(DICOM_FIELDS));
        this.showPreview.setSelected((Boolean)this.getDefault(DICOM_SHOWIMAGEPREVIEW));
        this.queryOpenOnReceive.setSelected((Boolean)this.getDefault(QUERY_OPENONRECEIVE));
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void setStationaryValues() {
        boolean panelEnabled = true;
        if (this.simpleMode) {
            panelEnabled = false;
        } else {
            this.setStationary(TRY_OPEN_VIA_IMAGEJ, new Boolean(true));
        }
        this.setStationary(FILE_ENABLED, new Boolean(true));
        this.setStationary(FILE_NAME, "");
        this.setStationary(DICOMCD_ENABLED, new Boolean(true));
        this.setStationary(DICOMCD_NAME, "");
        this.setStationary(DICOMDIR_ENABLED, new Boolean(panelEnabled));
        this.setStationary(DICOMDIR_NAME, "");
        this.setStationary(REC_ENABLED, false);
        this.setStationary(REC_DIR, "./DICOMSTORE/DICOMDIR");
        this.setStationary(REC_AET, "SANTEC");
        this.setStationary(REC_PORT, "5104");
        this.setStationary(QUERY_ENABLED, new Boolean(panelEnabled));
        this.setStationary(QUERY_STRING, "");
        this.setStationary(QUERY_TO_ADDRESS, "PACS_ADDRESS");
        this.setStationary(QUERY_TO_PORT, "5104");
        this.setStationary(QUERY_TO_AET, "PACS_AET");
        this.setStationary(QUERY_OPENONRECEIVE, true);
        this.setStationary(SELECTOR_ENABLED, new Boolean(panelEnabled));
        this.setStationary(SELECTOR_DIR, "");
        this.setStationary(SENDER_ENABLED, new Boolean(panelEnabled));
        String url = "dicom://" + this.getStationary(REC_AET) + "@" + "localhost:" + this.getStationary(REC_PORT);
        this.setStationary(SENDER_URLS, url);
        this.setStationary(DICOM_SHOWIMAGEPREVIEW, new Boolean(true));
        this.setStationary(DICOM_FIELDS, "0008,0060\n0020,0013\n0010,0010\n0010,0030\n0010,0040\n0018,0015");
    }

    public void updateSettings() {
        this.setValue(TRY_OPEN_VIA_IMAGEJ, this.openViaImageJ.isSelected());
        this.setValue(FILE_ENABLED, new Boolean(this.fileEnabled.isSelected()));
        this.setValue(FILE_NAME, this.fileName.getText());
        this.setValue(DICOMCD_ENABLED, new Boolean(this.dicomCDEnabled.isSelected()));
        this.setValue(DICOMCD_NAME, this.dicomCDName.getText());
        this.setValue(DICOMDIR_ENABLED, new Boolean(this.dicomdirEnabled.isSelected()));
        this.setValue(DICOMDIR_NAME, this.dicomdirName.getText());
        this.setValue(REC_ENABLED, new Boolean(this.recEnabled.isSelected()));
        this.setValue(REC_DIR, this.recDir.getText());
        this.setValue(REC_AET, this.recAET.getText());
        this.setValue(REC_PORT, this.recPort.getText());
        this.setValue(QUERY_ENABLED, new Boolean(this.queryEnabled.isSelected()));
        this.setValue(QUERY_STRING, this.queryString.getText());
        this.setValue(QUERY_TO_ADDRESS, this.queryToAddress.getText());
        this.setValue(QUERY_TO_PORT, this.queryToPort.getText());
        this.setValue(QUERY_TO_AET, this.queryToAET.getText());
        this.setValue(QUERY_OPENONRECEIVE, this.queryOpenOnReceive.isSelected());
        this.setValue(SELECTOR_ENABLED, new Boolean(this.selectorEnabled.isSelected()));
        this.setValue(SELECTOR_DIR, this.selectorFileName.getText());
        this.setValue(SENDER_ENABLED, new Boolean(this.sendEnabled.isSelected()));
        this.setValue(SENDER_URLS, this.senderTableModel.getUrlsAsString());
        this.setValue(DICOM_SHOWIMAGEPREVIEW, new Boolean(this.showPreview.isSelected()));
        this.setValue(DICOM_FIELDS, this.dicomHeader.getText());
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        try {
            this.openViaImageJ.setSelected((Boolean)this.getValue(TRY_OPEN_VIA_IMAGEJ));
            this.fileEnabled.setSelected((Boolean)this.getValue(FILE_ENABLED));
            this.fileName.setText((String)this.getValue(FILE_NAME));
            this.dicomCDEnabled.setSelected((Boolean)this.getValue(DICOMCD_ENABLED));
            this.dicomCDName.setText((String)this.getValue(DICOMCD_NAME));
            this.dicomdirEnabled.setSelected((Boolean)this.getValue(DICOMDIR_ENABLED));
            this.dicomdirName.setText((String)this.getValue(DICOMDIR_NAME));
            this.recEnabled.setSelected((Boolean)this.getValue(REC_ENABLED));
            this.recDir.setText((String)this.getValue(REC_DIR));
            this.recAET.setText((String)this.getValue(REC_AET));
            this.recPort.setText((String)this.getValue(REC_PORT));
            this.queryEnabled.setSelected((Boolean)this.getValue(QUERY_ENABLED));
            this.queryString.setText((String)this.getValue(QUERY_STRING));
            this.queryToAddress.setText((String)this.getValue(QUERY_TO_ADDRESS));
            this.queryToPort.setText((String)this.getValue(QUERY_TO_PORT));
            this.queryToAET.setText((String)this.getValue(QUERY_TO_AET));
            this.selectorEnabled.setSelected((Boolean)this.getValue(SELECTOR_ENABLED));
            this.selectorFileName.setText((String)this.getValue(SELECTOR_DIR));
            this.sendEnabled.setSelected((Boolean)this.getValue(SENDER_ENABLED));
            this.senderTableModel.setUrls((String)this.getValue(SENDER_URLS));
            if (this.singleSender && this.senderTableModel.getRowCount() > 0) {
                this.addSenderButton.setEnabled(false);
            }
            this.showPreview.setSelected((Boolean)this.getValue(DICOM_SHOWIMAGEPREVIEW));
            this.dicomHeader.setText((String)this.getValue(DICOM_FIELDS));
            if (this.dicomHeader.getText() == null || this.dicomHeader.getText().equals("")) {
                this.dicomHeader.setText((String)this.getStationary(DICOM_FIELDS));
            }
            this.queryOpenOnReceive.setSelected((Boolean)this.getValue(QUERY_OPENONRECEIVE));
        }
        catch (Exception e) {
            logger.warn((Object)("Could not load Settings: " + e.getLocalizedMessage()));
        }
    }

    public void relocalize() {
        this.setLabel(Translatrix.getTranslationString((String)"dicom.Dicom"));
        this.setSubPanelTitle(this.generalPanel, Translatrix.getTranslationString((String)"dicom.General"));
        this.openViaImageJ.setText(Translatrix.getTranslationString((String)"dicom.OpenViaImageJ"));
        this.setSubPanelTitle(this.filePanel, Translatrix.getTranslationString((String)"dicom.FileInput"));
        this.fileEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.fileNameLabel.setText(Translatrix.getTranslationString((String)"dicom.DefFilePath"));
        this.setSubPanelTitle(this.dicomCD, Translatrix.getTranslationString((String)"dicom.DicomCDInput"));
        this.dicomCDEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.dicomCDLabel.setText(Translatrix.getTranslationString((String)"dicom.DefFilePath"));
        this.setSubPanelTitle(this.dicomdir, Translatrix.getTranslationString((String)"dicom.DicomDirInput"));
        this.dicomdirEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.dicomdirLabel.setText(Translatrix.getTranslationString((String)"dicom.DefFilePath"));
        this.setSubPanelTitle(this.dicomRecPanel, Translatrix.getTranslationString((String)"dicom.DicomRec"));
        this.recAddressLabel.setText(Translatrix.getTranslationString((String)"dicom.QueryToAddress"));
        this.recEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.recDirLabel.setText(Translatrix.getTranslationString((String)"dicom.DefStorePath"));
        this.recAETLabel.setText(Translatrix.getTranslationString((String)"dicom.RecAET"));
        this.recPortLabel.setText(Translatrix.getTranslationString((String)"dicom.RecPort"));
        this.setSubPanelTitle(this.dicomQueryPanel, Translatrix.getTranslationString((String)"dicom.DicomQuery"));
        this.queryEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.queryStringLabel.setText(Translatrix.getTranslationString((String)"dicom.QueryString"));
        this.queryToAddressLabel.setText(Translatrix.getTranslationString((String)"dicom.QueryToAddress"));
        this.queryToPortLabel.setText(Translatrix.getTranslationString((String)"dicom.QueryToPort"));
        this.queryToAETLabel.setText(Translatrix.getTranslationString((String)"dicom.QueryToAET"));
        this.queryOpenOnReceive.setText(Translatrix.getTranslationString((String)"dicom.OpenOnReceive"));
        this.setSubPanelTitle(this.selectorPanel, Translatrix.getTranslationString((String)"dicom.Selector"));
        this.selectorEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.selectorNameLabel.setText(Translatrix.getTranslationString((String)"dicom.DefFilePath"));
        this.setSubPanelTitle(this.dicomSendPanel, Translatrix.getTranslationString((String)"dicom.DicomSend"));
        this.sendEnabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.addSenderButton.setText(Translatrix.getTranslationString((String)"dicom.addSender"));
        this.deleteSenderButton.setText(Translatrix.getTranslationString((String)"dicom.deleteSender"));
        this.setSubPanelTitle(this.dicomHeaderPanel, Translatrix.getTranslationString((String)"dicom.DicomHeader"));
        this.showPreview.setText(Translatrix.getTranslationString((String)"dicom.showPreview"));
        this.dicomHeaderLabel.setText(Translatrix.getTranslationString((String)"dicom.DicomHeaderFields"));
    }

    public JButton createTestButton() {
        final JButton jb = new JButton(UNKNOWN);
        jb.setToolTipText("Test connection");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DcmURL url = new DcmURL("dicom://" + DICOMSettingsPlugin.this.queryToAET.getText() + ":" + DICOMSettingsPlugin.this.recAET.getText() + "@" + DICOMSettingsPlugin.this.queryToAddress.getText() + ":" + DICOMSettingsPlugin.this.queryToPort.getText());
                    String retVal = DICOMSettingsPlugin.testPACS("PACS", (JComponent)((Object)DICOMSettingsPlugin.this), url);
                    if (retVal == null) {
                        jb.setIcon(OK);
                    } else {
                        logger.warn((Object)("Error connecting to PACS " + retVal));
                        jb.setIcon(FAILED);
                    }
                }
                catch (Exception ee) {
                    jb.setIcon(FAILED);
                }
            }
        });
        return jb;
    }

    public void reindex(File inFile, JComponent comp) {
        try {
            this.setValue(REC_ENABLED, false);
            this.m_Owner.fireSettingEvent(new SettingEvent((SettingsPlugin)this, this.getName(), REC_ENABLED));
            File dir = inFile.getParentFile();
            inFile.delete();
            final File[] files = DICOMSettingsPlugin.getFilesRecursive(dir);
            final DicomDirReader ddr = new DicomDirReader();
            ddr.loadDicomDirFile(inFile, true, true);
            if (files.length == 0) {
                return;
            }
            final ProgressMonitor progressMonitor = new ProgressMonitor(comp, Translatrix.getTranslationString((String)"dicom.reindexing"), "", 0, files.length - 1);
            new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < files.length) {
                        if (!files[i].isDirectory()) {
                            try {
                                progressMonitor.setNote(" ( " + (i + 1) + " of " + (files.length + 1) + " )");
                                progressMonitor.setProgress(i);
                                ddr.append(files[i]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                    progressMonitor.close();
                    DICOMSettingsPlugin.this.setValue(DICOMSettingsPlugin.REC_ENABLED, true);
                    DICOMSettingsPlugin.this.m_Owner.fireSettingEvent(new SettingEvent((SettingsPlugin)DICOMSettingsPlugin.this, DICOMSettingsPlugin.this.getName(), DICOMSettingsPlugin.REC_ENABLED));
                }
            }.start();
        }
        catch (Exception e1) {
            logger.warn((Object)"error reindexing dicom view");
            e1.printStackTrace();
        }
    }

    private static File[] getFilesRecursive(File dir) {
        ArrayList<File> al = new ArrayList<File>();
        DICOMSettingsPlugin.visitAllFiles(dir, al);
        File[] files = new File[al.size()];
        int i = 0;
        Iterator<File> iter = al.iterator();
        while (iter.hasNext()) {
            File element;
            files[i] = element = iter.next();
            ++i;
        }
        return files;
    }

    private static void visitAllFiles(File dir, ArrayList<File> al) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                DICOMSettingsPlugin.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public void setSingleSender(boolean singleSender) {
        this.singleSender = singleSender;
    }

    public static String testPACS(String name, JComponent parent, DcmURL url) {
        block3: {
            try {
                if (DCMEcho.sendEcho(url) != 0) break block3;
                return null;
            }
            catch (Exception ee) {
                String error = "Connection TO " + name + ": " + url + " gives the following Error!\n\n" + ee.getClass().getSimpleName() + " " + ee.getMessage() + "\n\n" + DCMEcho.checkConnection(url.getHost(), url.getPort());
                logger.warn((Object)error);
                ee.printStackTrace();
                JOptionPane.showMessageDialog(parent, error, "Error connecting to " + name, 2);
                return error;
            }
        }
        JOptionPane.showMessageDialog(parent, "Connection TO " + name + " DOES NOT work!", "Error connecting to " + name, 2);
        return "PerMoS -> PACS Connection DOES NOT work!";
    }

    public class NumberValidation
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str != null && str != "") {
                try {
                    int i = Integer.parseInt(str);
                    if (i >= 0 && i <= 65535) {
                        super.insertString(offset, str, attr);
                    }
                }
                catch (NumberFormatException e) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

