/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.demoapps;

import ij.ImagePlus;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import lu.tudor.santec.dicom.receiver.DicomStorageServer;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;

public class Dicom2dbImporter
implements DICOMListener {
    private File propertyFile;
    private LinkedHashMap dicomTags = new LinkedHashMap();
    private String DB_URL;
    private String DB_USER;
    private String DB_PASSWORD;
    private String DB_TABLE;
    private String DB_DRIVER_CLASS;
    private String IMAGE_COLUMN;
    private String THUMB_COLUMN;
    private String FILESIZE_COLUMN;
    private String DICOM_AET_NAME;
    private Integer DICOM_PORT;
    private String DICOM_STORE_DIR;
    private String DICOM_MANAGE_PASS;
    private Connection dbConnection;
    private String ROOT_DIR;
    private String ERROR_DIR;
    private String OK_DIR;
    private boolean DELETE_FILES_AFTER_IMPORT;
    private int thumbsize = 300;
    private File LOGFILE = new File("Dicom2dbImporter.log");
    private Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.dbimporter.DBImporter");

    public Dicom2dbImporter(File propertyFile) {
        this.propertyFile = propertyFile;
        try {
            TTCCLayout layout = new TTCCLayout("ISO8601");
            DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)layout, this.LOGFILE.getAbsolutePath(), "'.'yyyy-MM-dd");
            BasicConfigurator.configure((Appender)fileAppender);
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)layout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.readConfig();
        try {
            DicomStorageServer storageServer = new DicomStorageServer(this.DICOM_AET_NAME, this.DICOM_PORT, this.DICOM_STORE_DIR, false, this.DICOM_MANAGE_PASS, false);
            storageServer.addDICOMListener(this);
            storageServer.start();
            this.logger.info((Object)"Dicom2dbImporter started");
            System.out.println("Dicom2dbImporter started");
        }
        catch (IOException e) {
            System.err.println("Starting the server failed.......");
            this.logger.warn((Object)"Starting the server failed.......");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Connection getDatabaseConnection() throws SQLException {
        if (this.dbConnection != null && !this.dbConnection.isClosed()) {
            return this.dbConnection;
        }
        try {
            this.dbConnection = null;
            Class.forName(this.DB_DRIVER_CLASS);
            this.dbConnection = DriverManager.getConnection(this.DB_URL, this.DB_USER, this.DB_PASSWORD);
            return this.dbConnection;
        }
        catch (ClassNotFoundException io) {
            System.err.println("unable to connecto to DB: " + this.DB_URL);
            this.logger.warn((Object)("unable to connecto to DB: " + this.DB_URL));
            io.printStackTrace();
            return null;
        }
    }

    private void readConfig() {
        InputStream in;
        Properties properties = new Properties();
        if (this.propertyFile != null && this.propertyFile.canRead()) {
            try {
                in = new FileInputStream(this.propertyFile);
            }
            catch (FileNotFoundException e) {
                in = Dicom2dbImporter.class.getResourceAsStream("DBImporter.properties");
            }
        } else {
            in = Dicom2dbImporter.class.getResourceAsStream("DBImporter.properties");
        }
        try {
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("no usable Settings found");
            this.logger.warn((Object)"no usable Settings found");
            e.printStackTrace();
            System.exit(-1);
        }
        this.ROOT_DIR = properties.getProperty("ROOT_DIR");
        this.ERROR_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("ERROR_DIR");
        new File(this.ERROR_DIR).mkdirs();
        this.OK_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("OK_DIR");
        new File(this.OK_DIR).mkdirs();
        String str = properties.getProperty("DICOM_AET_NAME");
        this.DELETE_FILES_AFTER_IMPORT = str.toUpperCase().equals("TRUE") || str.toUpperCase().equals("YES");
        this.DICOM_AET_NAME = properties.getProperty("DICOM_AET_NAME");
        this.DICOM_PORT = new Integer(properties.getProperty("DICOM_PORT"));
        this.DICOM_STORE_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("DICOM_STORE_DIR");
        this.DICOM_MANAGE_PASS = properties.getProperty("DICOM_MANAGE_PASS");
        this.DB_DRIVER_CLASS = properties.getProperty("DB_DRIVER_CLASS");
        this.DB_URL = properties.getProperty("DB_URL");
        this.DB_USER = properties.getProperty("DB_USER");
        this.DB_PASSWORD = properties.getProperty("DB_PASSWORD");
        this.DB_TABLE = properties.getProperty("DB_TABLE");
        this.IMAGE_COLUMN = properties.getProperty("IMAGE_COLUMN");
        this.THUMB_COLUMN = properties.getProperty("THUMB_COLUMN");
        this.FILESIZE_COLUMN = properties.getProperty("FILESIZE_COLUMN");
        for (String string : properties.keySet()) {
            if (!string.startsWith("00")) continue;
            this.dicomTags.put(string, properties.getProperty(string));
        }
    }

    private void insertFile2DB(File f) {
        long start = System.currentTimeMillis();
        StringBuffer statement = new StringBuffer("INSERT INTO " + this.DB_TABLE + " ( ");
        for (String column : this.dicomTags.values()) {
            statement.append(String.valueOf(column) + ", ");
        }
        statement.append(String.valueOf(this.IMAGE_COLUMN) + ", ");
        statement.append(String.valueOf(this.THUMB_COLUMN) + ", ");
        statement.append(String.valueOf(this.FILESIZE_COLUMN) + " ");
        statement.append(" ) VALUES (");
        int i = 0;
        while (i < this.dicomTags.keySet().size()) {
            statement.append("?, ");
            ++i;
        }
        statement.append("?, ");
        statement.append("?, ");
        statement.append("?);");
        System.out.println(statement.toString());
        try {
            PreparedStatement prepstat = this.getDatabaseConnection().prepareStatement(statement.toString());
            ImagePlus ip = new ImagePlus(f.getAbsolutePath());
            DicomHeader dh = new DicomHeader(f);
            FileInputStream fIn = new FileInputStream(f);
            byte[] thumbnail = this.createThumb(ip);
            FileOutputStream fOut = new FileOutputStream("thumbnail.png");
            fOut.write(thumbnail);
            fOut.close();
            int i2 = 1;
            for (String tag : this.dicomTags.keySet()) {
                prepstat.setString(i2, dh.getHeaderStringValue(tag));
                ++i2;
            }
            prepstat.setBinaryStream(i2++, (InputStream)fIn, (int)f.length());
            prepstat.setBytes(i2++, thumbnail);
            prepstat.setString(i2, String.valueOf(f.length()));
            prepstat.addBatch();
            prepstat.executeUpdate();
            this.logger.info((Object)("File inserted: " + f.getAbsolutePath()));
            this.logger.info((Object)("insert took: " + (System.currentTimeMillis() - start)));
            boolean success = f.renameTo(new File(this.OK_DIR, f.getName()));
            if (this.DELETE_FILES_AFTER_IMPORT) {
                f.delete();
            } else if (success) {
                this.logger.info((Object)("moved file to: " + this.OK_DIR + File.separator + f.getName()));
            } else {
                this.logger.warn((Object)("unable to move file to: " + this.OK_DIR + File.separator + f.getName()));
            }
        }
        catch (Exception e) {
            boolean success = f.renameTo(new File(this.ERROR_DIR, f.getName()));
            this.logger.warn((Object)("Failed to insert file: " + f.getAbsolutePath() + " " + e.getLocalizedMessage()));
            if (success) {
                this.logger.info((Object)("moved file to: " + this.ERROR_DIR + File.separator + f.getName()));
            }
            this.logger.warn((Object)("unable to move file to: " + this.ERROR_DIR + File.separator + f.getName()));
        }
        this.logger.info((Object)("END OF IMPORT FOR " + f.getName() + "\r\n" + "#######################################################"));
    }

    public static void main(String[] args) {
        File f = null;
        try {
            f = new File(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Dicom2dbImporter(f);
    }

    @Override
    public void fireDicomEvent(DicomEvent event) {
        this.logger.warn((Object)(" \r\n\r\n#######################################################\r\n#\r\n#  STARTING IMPORT FOR " + event.getFile().getName() + "\r\n" + "#\r\n" + "#######################################################"));
        this.insertFile2DB(event.getFile());
    }

    private byte[] createThumb(ImagePlus imp) throws Exception {
        int height;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int width = imp.getWidth();
        ImageIcon i = width > (height = imp.getHeight()) ? new ImageIcon(imp.getImage().getScaledInstance(this.thumbsize, -1, 4)) : new ImageIcon(imp.getImage().getScaledInstance(-1, this.thumbsize, 4));
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 10);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        if (width > height) {
            g.drawImage(i.getImage(), 0, 0, null);
        } else {
            g.drawImage(i.getImage(), 0, 0, null);
        }
        ImageIO.write((RenderedImage)bi, "png", bOut);
        bi = null;
        return bOut.toByteArray();
    }
}

