/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.anonymizer;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import lu.tudor.santec.dicom.anonymizer.DicomAnonymizer;
import lu.tudor.santec.dicom.anonymizer.SimpleAnonPanel;
import org.dcm4che2.data.DicomObject;

public class DicomAnonymizerGui
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton cancelButton;
    private JButton runButton;
    private JButton closeButton;
    private boolean standalone;
    private JTextField dirField;
    private JButton dirButton;
    private JFileChooser fileChooser = new JFileChooser();
    private static boolean stopRunning;
    private JTextArea logField;
    private SimpleAnonPanel anonPanel;
    private JButton clearButton;

    public DicomAnonymizerGui(boolean standalone) {
        this.setTitle("DicomAnonymizerGui");
        this.standalone = standalone;
        this.fileChooser.setFileSelectionMode(2);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.WHITE);
        JPanel dirPanel = new JPanel(new BorderLayout(3, 3));
        dirPanel.setOpaque(false);
        dirPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.dirField = new JTextField();
        dirPanel.add((Component)this.dirField, "Center");
        this.dirButton = new JButton("choose");
        this.dirButton.addActionListener(this);
        dirPanel.add((Component)this.dirButton, "East");
        this.add((Component)dirPanel, "North");
        this.add((Component)this.createSimplePanel(), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(this);
        bb.addGridded((JComponent)this.closeButton);
        bb.addRelatedGap();
        this.clearButton = new JButton("clear");
        this.clearButton.addActionListener(this);
        bb.addGridded((JComponent)this.clearButton);
        bb.addGlue();
        this.cancelButton = new JButton("cancel");
        this.cancelButton.addActionListener(this);
        bb.addGridded((JComponent)this.cancelButton);
        bb.addRelatedGap();
        this.runButton = new JButton("run");
        this.runButton.addActionListener(this);
        bb.addGridded((JComponent)this.runButton);
        JPanel buttonPanel = bb.getPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        buttonPanel.setOpaque(false);
        this.add((Component)buttonPanel, "South");
        this.setSize(600, 750);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeButton)) {
            if (this.standalone) {
                System.exit(0);
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource().equals(this.cancelButton)) {
            stopRunning = true;
        } else if (e.getSource().equals(this.runButton)) {
            int retval = JOptionPane.showConfirmDialog(this, "You are about to anonymize/strip all files in the following folder:\n" + new File(this.dirField.getText()).getAbsolutePath() + "\n\n" + "All ORIGINAL files in this folder will be deleted.\n" + "Do you understand and want to continue?", "Anonymize/Strip images", 2, 0);
            if (retval == 2) {
                return;
            }
            stopRunning = false;
            this.processFiles();
        } else if (e.getSource().equals(this.dirButton)) {
            this.chooseDir();
        } else if (e.getSource().equals(this.clearButton)) {
            this.logField.setText("");
        }
    }

    private void processFiles() {
        Thread t = new Thread(){

            @Override
            public void run() {
                DicomAnonymizerGui.this.logField.setText("");
                DicomAnonymizerGui.this.closeButton.setEnabled(false);
                DicomAnonymizerGui.this.runButton.setEnabled(false);
                File file = new File(DicomAnonymizerGui.this.dirField.getText());
                if (file.isDirectory()) {
                    File[] files = DicomAnonymizerGui.this.getFilesRecursive(file);
                    int i = 0;
                    while (i < files.length) {
                        if (!stopRunning) {
                            DicomAnonymizerGui.this.processFile(files[i]);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else if (file.isFile()) {
                    DicomAnonymizerGui.this.processFile(file);
                }
                DicomAnonymizerGui.this.closeButton.setEnabled(true);
                DicomAnonymizerGui.this.runButton.setEnabled(true);
            }
        };
        t.start();
    }

    private void processFile(File file) {
        block15: {
            if (file.canWrite()) {
                try {
                    String suffix = DicomAnonymizer.SUFFIX_ANON;
                    DicomObject dObj = DicomAnonymizer.readDicomObject(file);
                    if (dObj != null && !dObj.isEmpty() && dObj.vm(131088) != -1) {
                        System.out.println("processing file: " + file.getPath());
                        this.logField.append("processing file: " + file.getPath() + "\n");
                        if (this.anonPanel.isRemovePatient()) {
                            dObj = DicomAnonymizer.removePatientInfo(dObj, this.anonPanel.getNewPatientID(), this.anonPanel.getNewPatientName());
                        }
                        if (this.anonPanel.isRemovePatientAdditional()) {
                            dObj = DicomAnonymizer.removePatientAdditionalInfo(dObj);
                        }
                        if (this.anonPanel.isRemoveInstitution()) {
                            dObj = DicomAnonymizer.removeInstitutionInfo(dObj, this.anonPanel.getNewInstitutionName());
                        }
                        if (this.anonPanel.isRemovePhysician()) {
                            dObj = DicomAnonymizer.removePhysicianInfo(dObj);
                        }
                        if (this.anonPanel.isRemoveManufacturer()) {
                            dObj = DicomAnonymizer.removeManufacturerInfo(dObj);
                        }
                        if (this.anonPanel.isRemovePrivate()) {
                            dObj = DicomAnonymizer.removePrivateTags(dObj);
                        }
                        if (this.anonPanel.isRemoveThis()) {
                            dObj = DicomAnonymizer.removeTags(dObj, this.anonPanel.removeThisTags());
                        }
                        if (this.anonPanel.isRemoveImageData()) {
                            dObj = DicomAnonymizer.removeImageData(dObj);
                            suffix = DicomAnonymizer.SUFFIX_HEADER;
                        }
                        if (this.anonPanel.isRename()) {
                            file.delete();
                            DicomAnonymizer.writeDicomFile(dObj, new File(String.valueOf(file.getAbsolutePath()) + suffix));
                        } else {
                            DicomAnonymizer.writeDicomFile(dObj, file);
                        }
                        break block15;
                    }
                    System.out.println("NOT processing file: " + file.getPath());
                    this.logField.append("NOT processing file: " + file.getPath() + "\n");
                }
                catch (Exception e) {
                    System.out.println("\t" + e.getLocalizedMessage());
                    this.logField.append("\t" + e.getLocalizedMessage() + "\n");
                    e.printStackTrace();
                }
            } else {
                System.out.println("File NOT writeable: " + file.getPath());
                this.logField.append("File NOT writeable: " + file.getPath() + "\n");
            }
        }
    }

    private void chooseDir() {
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.dirField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private JPanel createSimplePanel() {
        CellConstraints cc = new CellConstraints();
        JPanel jp = new JPanel((LayoutManager)new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, pref, 3dlu, fill:pref:grow, 3dlu"));
        jp.setOpaque(false);
        this.anonPanel = new SimpleAnonPanel();
        jp.add((Component)this.anonPanel, cc.xyw(1, 2, 3));
        this.logField = new JTextArea();
        JScrollPane jsp = new JScrollPane(this.logField);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        jp.add((Component)jsp, cc.xyw(2, 4, 1));
        return jp;
    }

    private File[] getFilesRecursive(File dir) {
        ArrayList<File> al = new ArrayList<File>();
        DicomAnonymizerGui.visitAllFiles(dir, al);
        File[] files = new File[al.size()];
        int i = 0;
        Iterator<File> iter = al.iterator();
        while (iter.hasNext()) {
            File element;
            files[i] = element = iter.next();
            ++i;
        }
        return files;
    }

    private static void visitAllFiles(File dir, ArrayList<File> al) {
        if (dir.isDirectory() && !stopRunning) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                DicomAnonymizerGui.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public static void main(String[] args) {
        new DicomAnonymizerGui(true);
    }
}

