/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.anonymizer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;

public class DicomAnonymizer {
    public static final int[] INCIDENT_TAGS = new int[]{1589248, 0x400555, 524322, 524330, 1577984, 1610788, 524338, 524368, 3670032, 3670048, 528516, 528512, 3670049, 3670080, 0x102000, 0x101090, 0x401010, 4194322, 0x40084000, 3686400};
    public static final int[] PATIENT_TAGS = new int[]{0x100010, 0x100020, 0x101040, 0x100030, 0x101005, 1048626, 3671040, 0x100050, 0x101060, 1057264, 1057108, 0x104000, 3671296, 0x401004, 0x100101, 0x100102, 4235555, 4198658, 0x401101, 4198659, 0x101002, 0x101000, 0x101001, 1057200, 4235384, 4206593, 1074266394, 1074266393, 540672, 0x204000, 1074266880, 0x101050, 1074266389, 1074266626, 1074266370, 1074266379, 1074266378, 3670033, 1057152, 3671040, 0x40004000, 0x20300020, 3686400};
    public static final int[] PATIENT_ADDITIONAL_TAGS = new int[]{0x100040, 0x101020, 0x101010, 0x101080, 1057120, 1057283, 1057232, 1057216, 1057184, 0x102110};
    public static final int[] ORGANISATION_TAGS = new int[]{524417, 524416, 528448, 524418, 0x400242, 1057433, 0x400001, 0x400010, 4210727, 4210725, 3280928, 3280929, 528400, 4235303};
    public static final int[] PHYSICIAN_TAGS = new int[]{528456, 528457, 528464, 528466, 528496, 524432, 524434, 528480, 3280946, 3280945, 4210741, 4210743, 4210742, 1074266385, 1074266380, 0x401011, 4202512, 4202504, 4202505, 1074266388, 528482, 528456, 528457, 524434, 524432, 524438, 524436, 3280947, 1057431, 0x404034, 0x40000B, 0x400006};
    public static final int[] MANUFACTURER_TAGS = new int[]{524400, 528528, 1576992};
    public static final int[] OVERLAY_TAGS = new int[]{0x60004000, 0x60003000, 524340, 524324};
    public static final int[] IMAGE_TAGS = new int[]{2145386512};
    public static String SUFFIX_ANON = "_anon.dcm";
    public static String SUFFIX_HEADER = "_header.dcm";
    private static DecimalFormat df = new DecimalFormat("000");

    public static void anonymizeFile(File f) throws Exception {
        DicomObject dObj = DicomAnonymizer.readDicomObject(f);
        DicomAnonymizer.removePatientInfo(dObj, "", "");
        DicomAnonymizer.removePatientAdditionalInfo(dObj);
        DicomAnonymizer.removeInstitutionInfo(dObj, "");
        DicomAnonymizer.removePhysicianInfo(dObj);
        DicomAnonymizer.removeManufacturerInfo(dObj);
        DicomAnonymizer.writeDicomFile(dObj, f);
    }

    public static void replaceTag(DicomObject dObj, int tag, String newValue) {
        if (tag != 0 && dObj.contains(tag)) {
            VR vr = dObj.vrOf(tag);
            try {
                dObj.putString(tag, vr, newValue);
            }
            catch (Exception e) {
                System.err.println("Error replacing Tag: " + tag + " with new value: " + newValue);
            }
        }
    }

    public static void addTag(DicomObject dObj, int tag, String newValue) {
        VR vr = dObj.vrOf(tag);
        try {
            dObj.putString(tag, vr, newValue);
        }
        catch (Exception e) {
            System.err.println("Error adding Tag: " + tag + " with value: " + newValue);
        }
    }

    public static DicomObject removePatientInfo(DicomObject dObj, String patientID, String newName) {
        return DicomAnonymizer.removePatientInfo(dObj, patientID, newName, true);
    }

    public static DicomObject removePatientInfo(DicomObject dObj, String patientID, String newName, boolean calculateAge) {
        Date bDate = null;
        GregorianCalendar bDayCal = null;
        try {
            bDate = dObj.getDate(0x100030);
        }
        catch (Exception e) {
            System.err.println("error parsing birthdate " + e.getMessage());
        }
        if (bDate != null) {
            bDayCal = new GregorianCalendar();
            bDayCal.setTime(bDate);
        }
        if (newName == null || "".equals(newName)) {
            newName = "ANONYMOUS";
            try {
                String gender = dObj.getString(0x100040);
                newName = String.valueOf(newName) + "_" + gender;
                if (bDayCal != null) {
                    newName = String.valueOf(newName) + "_" + bDayCal.get(1);
                }
            }
            catch (Exception gender) {
                // empty catch block
            }
        }
        int[] nArray = PATIENT_TAGS;
        int n = PATIENT_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        if (calculateAge) {
            Date imageDate = null;
            if (dObj.contains(524306)) {
                imageDate = dObj.getDate(524306);
            } else if (dObj.contains(524322)) {
                imageDate = dObj.getDate(524322);
            } else if (dObj.contains(524321)) {
                imageDate = dObj.getDate(524321);
            }
            if (bDate != null && imageDate != null) {
                String age = DicomAnonymizer.calculateAge(bDate, imageDate);
                DicomAnonymizer.addTag(dObj, 0x101010, age);
            }
        }
        if (bDayCal != null) {
            DicomAnonymizer.addTag(dObj, 0x100030, String.valueOf(bDayCal.get(1)) + "0101");
        }
        DicomAnonymizer.addTag(dObj, 0x100010, newName);
        DicomAnonymizer.addTag(dObj, 0x100020, patientID);
        DicomAnonymizer.addTag(dObj, 1179746, "true");
        return dObj;
    }

    public static long calculateAgeInDays(Date birthDate, Date imageDate) {
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(birthDate);
        long start = startCal.getTimeInMillis() + (long)startCal.getTimeZone().getOffset(startCal.getTimeInMillis());
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(imageDate);
        long end = endCal.getTimeInMillis() + (long)endCal.getTimeZone().getOffset(endCal.getTimeInMillis());
        long msDiff = Math.abs(end - start);
        long days = msDiff / 86400000L;
        return days;
    }

    public static String calculateAgeString(DicomObject dObj) {
        Date bDate = null;
        if (dObj.contains(0x100030)) {
            bDate = dObj.getDate(0x100030);
        }
        Date imageDate = null;
        if (dObj.contains(524306)) {
            imageDate = dObj.getDate(524306);
        } else if (dObj.contains(524322)) {
            imageDate = dObj.getDate(524322);
        } else if (dObj.contains(524321)) {
            imageDate = dObj.getDate(524321);
        } else if (dObj.contains(524320)) {
            imageDate = dObj.getDate(524320);
        } else if (dObj.contains(524323)) {
            imageDate = dObj.getDate(524323);
        }
        return DicomAnonymizer.calculateAgeString(bDate, imageDate);
    }

    public static String calculateAgeString(Date bDate, Date imageDate) {
        DecimalFormat dFormat = new DecimalFormat("#.00");
        if (bDate == null || imageDate == null) {
            return null;
        }
        if (bDate.after(imageDate)) {
            return null;
        }
        GregorianCalendar bDayCal = new GregorianCalendar();
        bDayCal.setTime(bDate);
        GregorianCalendar imageCal = new GregorianCalendar();
        imageCal.setTime(imageDate);
        int bDayYeNum = bDayCal.get(1);
        int bDayMoNum = bDayCal.get(2) + 1;
        int bDayDaNum = bDayCal.get(5);
        int imgYeNum = imageCal.get(1);
        int imgMoNum = imageCal.get(2) + 1;
        int imgDaNum = imageCal.get(5);
        if (bDayDaNum > 30) {
            bDayDaNum = 30;
        }
        if (imgDaNum > 30) {
            imgDaNum = 30;
        }
        int ageYears = imgYeNum - bDayYeNum;
        double ageMonth = (double)(imgMoNum - bDayMoNum) + (double)(imgDaNum - bDayDaNum) / 30.0;
        int ageMonthRounded = (int)Math.round(ageMonth);
        double age = (double)ageYears + (double)ageMonthRounded / 12.0;
        String ageString = dFormat.format(age);
        return ageString;
    }

    public static String calculateAge(Date birthDate, Date imageDate) {
        String age = "";
        long days = DicomAnonymizer.calculateAgeInDays(birthDate, imageDate);
        age = days / 365L > 2L ? String.valueOf(df.format(days / 365L)) + "Y" : String.valueOf(df.format(days / 30L)) + "M";
        return age;
    }

    public static DicomObject removePatientAdditionalInfo(DicomObject dObj) {
        int[] nArray = PATIENT_ADDITIONAL_TAGS;
        int n = PATIENT_ADDITIONAL_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        return dObj;
    }

    public static DicomObject removePhysicianInfo(DicomObject dObj) {
        int[] nArray = PHYSICIAN_TAGS;
        int n = PHYSICIAN_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        return dObj;
    }

    public static DicomObject removeInstitutionInfo(DicomObject dObj, String institutionName) {
        int tag;
        int[] nArray = ORGANISATION_TAGS;
        int n = ORGANISATION_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        nArray = PHYSICIAN_TAGS;
        n = PHYSICIAN_TAGS.length;
        n2 = 0;
        while (n2 < n) {
            tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        DicomAnonymizer.addTag(dObj, 524416, institutionName);
        return dObj;
    }

    public static DicomObject removeManufacturerInfo(DicomObject dObj) {
        int[] nArray = MANUFACTURER_TAGS;
        int n = MANUFACTURER_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        return dObj;
    }

    public static DicomObject removeImageData(DicomObject dObj) {
        int[] nArray = IMAGE_TAGS;
        int n = IMAGE_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        return dObj;
    }

    public static DicomObject removeOverlayInfo(DicomObject dObj) {
        int[] nArray = OVERLAY_TAGS;
        int n = OVERLAY_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            dObj.remove(tag);
            ++n2;
        }
        return dObj;
    }

    public static DicomObject removePrivateTags(DicomObject dObj) {
        dObj = dObj.excludePrivate();
        return dObj;
    }

    public static DicomObject removeTags(DicomObject dObj, String[] tagStrings) throws Exception {
        if (tagStrings == null || tagStrings.length == 0) {
            return dObj;
        }
        int[] tags = new int[tagStrings.length];
        int i = 0;
        while (i < tags.length) {
            tags[i] = DicomHeader.toTagInt(tagStrings[i]);
            ++i;
        }
        dObj = dObj.exclude(tags);
        return dObj;
    }

    public static DicomObject removeTags(DicomObject dObj, int[] tags) {
        if (tags == null || tags.length == 0) {
            return dObj;
        }
        dObj = dObj.exclude(tags);
        return dObj;
    }

    public static DicomObject readDicomObject(File f) {
        DicomInputStream din = null;
        try {
            DicomObject dcmObj;
            din = new DicomInputStream(f);
            DicomObject dicomObject = dcmObj = din.readDicomObject();
            return dicomObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeDicomFile(DicomObject dObj, File f) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
        try {
            try {
                dos.writeDicomFile(dObj);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    dos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

