/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;

public class OverlayExtractor {
    public static boolean hasOverlayImage(File f) {
        try {
            DicomInputStream in = new DicomInputStream(f);
            in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dcmobj = in.readDicomObject();
            in.close();
            return OverlayExtractor.hasOverlayImage(dcmobj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasOverlayImage(DicomObject dcmobj) {
        return dcmobj.contains(0x60000010);
    }

    public static ImagePlus extractOverlay(File f) {
        try {
            DicomInputStream in = new DicomInputStream(f);
            in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dcmobj = in.readDicomObject();
            in.close();
            return OverlayExtractor.extractOverlay(dcmobj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImagePlus extractOverlay(File f, Color foreground, Color background) {
        try {
            DicomInputStream in = new DicomInputStream(f);
            in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dcmobj = in.readDicomObject();
            in.close();
            return OverlayExtractor.extractOverlay(dcmobj, foreground, background);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImagePlus extractOverlay(DicomObject dcmobj) {
        return OverlayExtractor.extractOverlay(dcmobj, Color.green, new Color(0, 0, 0, 0));
    }

    public static ImagePlus extractOverlay(DicomObject dcmobj, Color foreground, Color background) {
        try {
            if (dcmobj.contains(0x60003000)) {
                DicomElement olData = dcmobj.get(0x60003000);
                int rows = dcmobj.get(0x60000010).getInt(false);
                int cols = dcmobj.get(0x60000011).getInt(false);
                byte[] data = olData.getBytes();
                return OverlayExtractor.overlayFromBytes(data, rows, cols, foreground, background);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ImagePlus overlayFromBytes(byte[] data, int rows, int cols, Color fg, Color bg) {
        byte[] byteData = new byte[data.length * 8];
        int j = 0;
        int i = 0;
        while (i < data.length) {
            byte b = data[i];
            byteData[j++] = (b & 1) > 0 ? 0 : -1;
            byteData[j++] = (b & 2) > 0 ? 0 : -1;
            byteData[j++] = (b & 4) > 0 ? 0 : -1;
            byteData[j++] = (b & 8) > 0 ? 0 : -1;
            byteData[j++] = (b & 0x10) > 0 ? 0 : -1;
            byteData[j++] = (b & 0x20) > 0 ? 0 : -1;
            byteData[j++] = (b & 0x40) > 0 ? 0 : -1;
            byteData[j++] = (b & 0x80) > 0 ? 0 : -1;
            ++i;
        }
        if (rows * cols != byteData.length) {
            System.err.println("overlay should be " + rows + "x" + cols + "=" + rows * cols + "byte but is " + byteData.length + "byte - Adjusting data...");
            byteData = Arrays.copyOf(byteData, rows * cols);
        }
        byte[] cmap = new byte[]{(byte)fg.getRed(), (byte)fg.getGreen(), (byte)fg.getBlue(), (byte)fg.getAlpha(), (byte)bg.getRed(), (byte)bg.getGreen(), (byte)bg.getBlue(), (byte)bg.getAlpha()};
        ByteProcessor ip = new ByteProcessor(cols, rows, byteData, (ColorModel)new IndexColorModel(1, 2, cmap, 0, true));
        return new ImagePlus("overlay", (ImageProcessor)ip);
    }

    public static byte[] bytesFromOverLay(ByteProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        byte[] binaryPixels = new byte[pixels.length / 8];
        int j = 7;
        int i = 0;
        while (i < binaryPixels.length) {
            StringBuffer sb = new StringBuffer();
            int k = 0;
            while (k < 8) {
                sb.append((char)pixels[j--] > '\u0000' ? 1 : 0);
                ++k;
            }
            j += 16;
            binaryPixels[i] = (byte)Short.parseShort(sb.toString(), 2);
            ++i;
        }
        return binaryPixels;
    }

    public static ImagePlus createOverlayImage(ImagePlus orig, DicomObject dcmobj) {
        ImagePlus overlay = OverlayExtractor.extractOverlay(dcmobj);
        if (overlay == null) {
            return orig;
        }
        ColorProcessor cp = (ColorProcessor)orig.getProcessor().convertToRGB();
        ColorProcessor cp2 = (ColorProcessor)overlay.getProcessor().convertToRGB();
        cp.copyBits((ImageProcessor)cp2, 0, 0, 14);
        return new ImagePlus("img+overlay", (ImageProcessor)cp);
    }

    public static DicomObject image2Overlay(ImagePlus orig, DicomObject dcmobj) throws Throwable {
        ImageProcessor ip = orig.getProcessor();
        ip = ip.convertToByte(true);
        orig = new ImagePlus("test", ip);
        byte[] pixels = (byte[])ip.getPixels();
        byte[] bitData = new byte[pixels.length / 8];
        int pixcount = 0;
        int i = 0;
        while (i < bitData.length) {
            int j = 0;
            while (j < 8) {
                bitData[i] = pixels[pixcount] < 0 ? (byte)(bitData[i] | 1 << j) : (byte)(bitData[i] | 0 << j);
                ++pixcount;
                j = (byte)(j + 1);
            }
            ++i;
        }
        dcmobj.putInt(0x60000010, VR.US, orig.getHeight());
        dcmobj.putInt(0x60000011, VR.US, orig.getWidth());
        dcmobj.putInt(1610612757, VR.IS, 1);
        dcmobj.putString(0x60000022, VR.LO, "DOSE INFO");
        dcmobj.putString(0x60000040, VR.CS, "G");
        dcmobj.putShorts(0x60000050, VR.SS, new short[]{1, 1});
        dcmobj.putInt(0x60000100, VR.US, 1);
        dcmobj.putInt(1610612994, VR.US, 0);
        dcmobj.putBytes(0x60003000, VR.OB, bitData);
        return dcmobj;
    }

    public static BufferedImage removeColor(BufferedImage ipl, Color color) {
        BufferedImage dimg = new BufferedImage(ipl.getWidth(), ipl.getHeight(), 3);
        Graphics2D g = dimg.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, 0.65f));
        g.drawImage(ipl, null, 0, 0);
        g.dispose();
        int i = 0;
        while (i < dimg.getHeight()) {
            int j = 0;
            while (j < dimg.getWidth()) {
                if (dimg.getRGB(j, i) == color.getRGB()) {
                    dimg.setRGB(j, i, 9378844);
                }
                ++j;
            }
            ++i;
        }
        return dimg;
    }

    public static void main(String[] args) {
        try {
            ImagePlus ip = new ImagePlus("/home/hermenj/1");
            DicomInputStream in = new DicomInputStream(new File("/home/hermenj/1"));
            in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dcmobj = in.readDicomObject();
            in.close();
            dcmobj = OverlayExtractor.image2Overlay(ip, dcmobj);
            FileOutputStream fos = new FileOutputStream("/home/hermenj/1_ov");
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
            dos.writeDicomFile(dcmobj);
            dos.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

