/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Install_J3D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JOptionPane;
import loci.formats.IFormatReader;
import loci.formats.in.DicomReader;
import loci.plugins.util.ImageProcessorReader;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import org.apache.log4j.Logger;

public class DicomOpener {
    private static Logger logger = Logger.getLogger((String)DicomOpener.class.getName());

    public static ImagePlus loadImage(File p_File) throws FileNotFoundException {
        return DicomOpener.loadImage(p_File, null, null);
    }

    public static ImagePlus loadImageStack(File p_File) throws FileNotFoundException {
        return DicomOpener.loadImageStack(p_File, null, null);
    }

    public static ImagePlus loadImage(File p_File, Component parentComponent) throws FileNotFoundException {
        return DicomOpener.loadImage(p_File, null, parentComponent);
    }

    public static ImagePlus loadImageStack(File p_File, Component parentComponent) throws FileNotFoundException {
        return DicomOpener.loadImageStack(p_File, null, parentComponent);
    }

    public static ImagePlus loadImage(File p_File, DicomHeader dh, Component parentComponent) throws FileNotFoundException {
        return DicomOpener.loadImage(p_File, dh, parentComponent, false);
    }

    public static ImagePlus loadImage(File p_File, DicomHeader dh, Component parentComponent, boolean tryOpenViaImageJFirst) throws FileNotFoundException {
        long freeMem;
        if (!p_File.canRead()) {
            logger.error((Object)"Provided File is NULL");
            return null;
        }
        if (!p_File.canRead()) {
            logger.error((Object)("Unable to load file...File not readable: " + p_File));
            return null;
        }
        long fileSize = p_File.length() / 1024L / 1024L;
        if (fileSize > 5L) {
            logger.info((Object)("Trying to open a large File with " + fileSize + "mb " + p_File.getAbsolutePath()));
        }
        if (fileSize > (freeMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L)) {
            logger.error((Object)"File is bigger than available Memory -> NOT OPENING");
            return DicomOpener.createDummyImage(p_File, dh, "File is bigger than available Memory -> NOT OPENING");
        }
        ImagePlus image = null;
        try {
            if (dh == null) {
                dh = new DicomHeader(p_File);
                logger.debug((Object)"DicomHeader read!");
            }
            long start = System.currentTimeMillis();
            if (dh.hasPixelData()) {
                block33: {
                    if (tryOpenViaImageJFirst && !dh.isCompressedImage()) {
                        logger.info((Object)"opening image via ImageJ");
                        image = new ImagePlus(p_File.getAbsolutePath());
                    } else {
                        DicomReader dicomReader = new DicomReader();
                        try {
                            try {
                                String s = p_File.getAbsolutePath();
                                dicomReader.setGroupFiles(false);
                                dicomReader.setOriginalMetadataPopulated(false);
                                dicomReader.setId(s);
                                ImageProcessorReader r = new ImageProcessorReader((IFormatReader)dicomReader);
                                ImageProcessor ip = r.openProcessors(0)[0];
                                dicomReader.close();
                                image = new ImagePlus(p_File.getName(), ip);
                            }
                            catch (Throwable eArr) {
                                System.gc();
                                logger.warn((Object)"Opening file via Loci-Tools failed");
                                logger.info((Object)"Trying opening image via ImageJ");
                                image = new ImagePlus(p_File.getAbsolutePath());
                                try {
                                    if (dicomReader != null) {
                                        dicomReader.close();
                                    }
                                    break block33;
                                }
                                catch (Exception e) {
                                    logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                                }
                                break block33;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (dicomReader != null) {
                                    dicomReader.close();
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                            }
                            throw throwable;
                        }
                        try {
                            if (dicomReader != null) {
                                dicomReader.close();
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                        }
                    }
                }
                logger.info((Object)("loading image took: " + (System.currentTimeMillis() - start) + "ms"));
                image.setProperty("Info", (Object)dh.toString());
                image.setProperty(DicomHeader.class.getSimpleName(), (Object)dh);
                FileInfo fi = new FileInfo();
                fi.directory = String.valueOf(p_File.getParent()) + File.separator;
                fi.fileName = p_File.getName();
                if (dh.getHeaderIntegerValue(2621696) == 8) {
                    fi.fileType = 0;
                } else if (dh.getHeaderIntegerValue(2621696) == 32) {
                    fi.fileType = 11;
                } else if (dh.getHeaderIntegerValue(2621699) == 1) {
                    fi.fileType = 1;
                }
                image.setFileInfo(fi);
                try {
                    DicomOpener.setCalibration(image, dh);
                }
                catch (Exception e) {
                    logger.info((Object)("error setting image calibration for image: " + p_File));
                }
            } else {
                image = DicomOpener.createDummyImage(p_File, dh, "File does not contain Image Data.");
            }
            return image;
        }
        catch (Throwable e) {
            System.gc();
            logger.error((Object)("Unable to open image file: " + p_File.getAbsolutePath() + "\n" + e.getMessage()), e);
            if (parentComponent != null) {
                JOptionPane.showMessageDialog(parentComponent, "Unable to open image file: " + p_File.getAbsolutePath() + "\n" + e.getMessage(), "Error loading Image", 0);
            }
            return DicomOpener.createDummyImage(p_File, dh, e.getLocalizedMessage());
        }
    }

    private static void setCalibration(ImagePlus image, DicomHeader dh) {
        double rescaleIntercept = dh.getHeaderDoubleValue(2625618);
        double rescaleSlope = dh.getHeaderDoubleValue(2625619);
        if (image.getFileInfo().fileType == 1) {
            double[] coeff = new double[]{rescaleIntercept, rescaleSlope};
            image.getCalibration().setFunction(0, coeff, "HU");
        } else {
            double[] coeff = new double[]{rescaleIntercept, rescaleSlope};
            image.getCalibration().setFunction(0, coeff, "HU");
        }
    }

    public static ImagePlus loadImageStack(File p_File, DicomHeader dh, Component parentComponent) throws FileNotFoundException {
        return DicomOpener.loadImageStack(p_File, dh, parentComponent, false);
    }

    public static ImagePlus loadImageStack(File p_File, DicomHeader dh, Component parentComponent, boolean tryOpenViaImageJFirst) throws FileNotFoundException {
        if (!p_File.canRead()) {
            logger.error((Object)"Provided File is NULL");
            return null;
        }
        if (!p_File.canRead()) {
            logger.error((Object)("Unable to load file...File not readable: " + p_File));
            return null;
        }
        long fileSize = p_File.length() / 1024L / 1024L;
        if (fileSize > 5L) {
            logger.info((Object)("Trying to open a large File with " + fileSize + "mb " + p_File.getAbsolutePath()));
        }
        ImagePlus image = null;
        try {
            if (dh == null) {
                dh = new DicomHeader(p_File);
            }
            if (dh.hasPixelData()) {
                block29: {
                    if (tryOpenViaImageJFirst && !dh.isCompressedImage()) {
                        logger.info((Object)"opening image via ImageJ");
                        image = new ImagePlus(p_File.getAbsolutePath());
                    } else {
                        DicomReader dicomReader = new DicomReader();
                        try {
                            try {
                                String s = p_File.getAbsolutePath();
                                dicomReader.setGroupFiles(false);
                                dicomReader.setOriginalMetadataPopulated(false);
                                dicomReader.setId(s);
                                int slices = dicomReader.getImageCount();
                                ImageProcessorReader r = new ImageProcessorReader((IFormatReader)dicomReader);
                                ImageProcessor ip = r.openProcessors(0)[0];
                                image = new ImagePlus(p_File.getName(), ip);
                                System.out.println(String.valueOf(slices) + " slices");
                                System.out.println(String.valueOf(ip.getWidth()) + " + " + ip.getHeight());
                                if (slices > 1) {
                                    logger.info((Object)("Loading Multislice DICOM File with " + slices + " slices"));
                                    ImageStack is = new ImageStack(ip.getWidth(), ip.getHeight());
                                    int i = 0;
                                    while (i < slices) {
                                        ImageProcessor[] processor = r.openProcessors(i);
                                        logger.info((Object)("Loading Slice: " + i + "/" + slices + " Processoranz: " + processor.length));
                                        is.addSlice(String.valueOf(p_File.getName()) + "[" + (i + 1) + "]", processor[0]);
                                        ++i;
                                    }
                                    image.setStack(null, is);
                                }
                            }
                            catch (NegativeArraySizeException eArr) {
                                logger.warn((Object)"Opening file via Loci-Tools failed");
                                logger.info((Object)"Trying opening image via ImageJ");
                                image = new ImagePlus(p_File.getAbsolutePath());
                                try {
                                    if (dicomReader != null) {
                                        dicomReader.close();
                                    }
                                    break block29;
                                }
                                catch (Exception e) {
                                    logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                                }
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (dicomReader != null) {
                                    dicomReader.close();
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                            }
                            throw throwable;
                        }
                        try {
                            if (dicomReader != null) {
                                dicomReader.close();
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Error closing DICOM READER", (Throwable)e);
                        }
                    }
                }
                image.setProperty("Info", (Object)dh.toString());
                image.setProperty(DicomHeader.class.getSimpleName(), (Object)dh);
                FileInfo fi = new FileInfo();
                fi.directory = String.valueOf(p_File.getParent()) + File.separator;
                fi.fileName = p_File.getName();
                try {
                    DicomOpener.setCalibration(image, dh);
                }
                catch (Exception e) {
                    logger.warn((Object)("error setting image calibration for image: " + p_File));
                }
                image.setFileInfo(fi);
            } else {
                image = DicomOpener.createDummyImage(p_File, dh, "File does not contain Image Data.");
            }
            return image;
        }
        catch (Throwable e) {
            logger.error((Object)("Unable to open image file: " + p_File.getAbsolutePath() + "\n" + e.getMessage()), e);
            if (parentComponent != null) {
                JOptionPane.showMessageDialog(parentComponent, "Unable to open image file: " + p_File.getAbsolutePath() + "\n" + e.getMessage(), "Error loading Image", 0);
            }
            dh = new DicomHeader(p_File);
            return DicomOpener.createDummyImage(p_File, dh, e.getLocalizedMessage());
        }
    }

    private static ImagePlus createDummyImage(File file, DicomHeader dh, String message) {
        byte[] bArr;
        int rows = 0;
        int cols = 0;
        if (!dh.isEmpty()) {
            rows = dh.getHeaderIntegerValue(2621456);
            cols = dh.getHeaderIntegerValue(2621457);
        }
        if (rows == 0) {
            rows = 512;
        }
        if (cols == 0) {
            cols = 512;
        }
        byte[] byArray = bArr = new byte[cols * rows];
        int n = bArr.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            b = 127;
            ++n2;
        }
        ByteProcessor iProz = new ByteProcessor(cols, rows, bArr, null);
        iProz.setColor(Color.WHITE);
        iProz.setAntialiasedText(true);
        iProz.setFont(new Font("Arial", 1, 22));
        iProz.drawString(message, 10, 40);
        ImagePlus ip = new ImagePlus(file.getName(), (ImageProcessor)iProz);
        ip.setProperty("Info", (Object)dh.toString());
        ip.setProperty(DicomHeader.class.getSimpleName(), (Object)dh);
        FileInfo fi = new FileInfo();
        fi.directory = String.valueOf(file.getParent()) + File.separator;
        fi.fileName = file.getName();
        ip.setFileInfo(fi);
        return ip;
    }

    public static boolean isImageIOWorking() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("jpeg");
        while (readers.hasNext()) {
            ImageReader imageReader = readers.next();
            if (!imageReader.getClass().getSimpleName().endsWith("CLibJPEGImageReader")) continue;
            return true;
        }
        return false;
    }

    public static String getJavaImageInfos() {
        System.out.println("Gathering Java Infos....");
        StringBuffer sb = new StringBuffer();
        sb.append("OS: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.arch")).append("\n");
        sb.append("Java: ").append(System.getProperty("java.runtime.version")).append(" ").append(System.getProperty("sun.arch.data.model")).append("bit\n");
        System.out.print("\tChecking J3D... ");
        sb.append("Java 3D: ");
        try {
            String version = Install_J3D.getJava3DVersion();
            sb.append(String.valueOf(version) + "\n");
            System.out.println(version);
        }
        catch (Throwable e) {
            System.out.println("NOT Installed");
            sb.append("NOT Installed\n");
        }
        System.out.print("\tChecking ImageIO");
        sb.append("ImageIO: " + (DicomOpener.isImageIOWorking() ? "OK!" : "MISSING Native Libs!") + "\n");
        sb.append("JPEG Readers: ");
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("jpeg");
        while (readers.hasNext()) {
            ImageReader imageReader = readers.next();
            sb.append(imageReader.getClass().getSimpleName()).append(", ");
            System.out.println("\t\t" + imageReader.getClass().getSimpleName());
        }
        sb.append("\n");
        System.out.println(sb.toString());
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            DicomOpener.getJavaImageInfos();
            DicomOpener.loadImage(new File("/home/hermenj/Downloads/test2/1.2.840.113704.6.97392825010140.20001020.41231.11282400032"), null, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

