/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.drools.util.UUID;

public final class UUIDGenerator {
    private static final UUIDGenerator sSingleton = new UUIDGenerator();
    private Random mRnd = null;
    private MessageDigest mHasher = null;

    private UUIDGenerator() {
    }

    public static UUIDGenerator getInstance() {
        return sSingleton;
    }

    public Random getRandomNumberGenerator() {
        if (this.mRnd == null) {
            this.mRnd = new SecureRandom();
        }
        return this.mRnd;
    }

    public void setRandomNumberGenerator(Random r) {
        this.mRnd = r;
    }

    public MessageDigest getHashAlgorithm() {
        if (this.mHasher == null) {
            try {
                this.mHasher = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nex) {
                throw new Error("Couldn't instantiate an MD5 MessageDigest instance: " + nex.toString());
            }
        }
        return this.mHasher;
    }

    public UUID generateRandomBasedUUID() {
        return this.generateRandomBasedUUID(this.getRandomNumberGenerator());
    }

    public UUID generateRandomBasedUUID(Random randomGenerator) {
        byte[] rnd = new byte[16];
        randomGenerator.nextBytes(rnd);
        return new UUID(4, rnd);
    }
}

