/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;

public class ObjectHashMap
extends AbstractHashTable
implements Externalizable {
    private static final long serialVersionUID = 400L;

    public ObjectHashMap() {
        this(16, 0.75f);
    }

    public ObjectHashMap(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public ObjectHashMap(Entry[] table) {
        super(0.75f, table);
    }

    public ObjectHashMap(float loadFactor, Entry[] table) {
        super(loadFactor, table);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.resize(this.table.length, true);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    protected void updateHashCode(Entry entry) {
        ((ObjectEntry)entry).setHashCode(this.comparator.hashCodeOf(((ObjectEntry)entry).getKey()));
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, true);
    }

    public void clear() {
        this.table = new Entry[Math.min(this.table.length, 16)];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public Object put(Object key, Object value, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        if (checkExists) {
            for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
                if (hashCode != current.hashCode || !this.comparator.equal(key, current.key)) continue;
                Object oldValue = current.value;
                current.value = value;
                return oldValue;
            }
        }
        ObjectEntry entry = new ObjectEntry(key, value, hashCode);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length, false);
        }
        return null;
    }

    public Object get(Object key) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
            if (hashCode != current.hashCode || !this.comparator.equal(key, current.key)) continue;
            return current.value;
        }
        return null;
    }

    public Object remove(Object key) {
        ObjectEntry previous;
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        ObjectEntry current = previous = (ObjectEntry)this.table[index];
        while (current != null) {
            ObjectEntry next = (ObjectEntry)current.getNext();
            if (hashCode == current.hashCode && this.comparator.equal(key, current.key)) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return current.value;
            }
            previous = current;
            current = next;
        }
        return null;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.comparator.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public static class ObjectEntry
    implements Entry {
        private static final long serialVersionUID = 400L;
        private Object key;
        private Object value;
        private int hashCode;
        private Entry next;

        public ObjectEntry(Object key, Object value, int hashCode) {
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }

        public void setHashCode(int hashCode) {
            this.hashCode = hashCode;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            ObjectEntry other = (ObjectEntry)object;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }
    }
}

