/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.instance.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.Agenda;
import org.drools.WorkingMemory;
import org.drools.common.EventSupport;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.ruleflow.common.instance.impl.ProcessInstanceImpl;
import org.drools.ruleflow.core.ActionNode;
import org.drools.ruleflow.core.EndNode;
import org.drools.ruleflow.core.Join;
import org.drools.ruleflow.core.MilestoneNode;
import org.drools.ruleflow.core.Node;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.core.RuleSetNode;
import org.drools.ruleflow.core.Split;
import org.drools.ruleflow.core.StartNode;
import org.drools.ruleflow.core.SubFlowNode;
import org.drools.ruleflow.instance.RuleFlowNodeInstance;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.ruleflow.instance.impl.ActionNodeInstanceImpl;
import org.drools.ruleflow.instance.impl.EndNodeInstanceImpl;
import org.drools.ruleflow.instance.impl.MilestoneNodeInstanceImpl;
import org.drools.ruleflow.instance.impl.RuleFlowJoinInstanceImpl;
import org.drools.ruleflow.instance.impl.RuleFlowSplitInstanceImpl;
import org.drools.ruleflow.instance.impl.StartNodeInstanceImpl;
import org.drools.ruleflow.instance.impl.SubFlowNodeInstanceImpl;

public class RuleFlowProcessInstanceImpl
extends ProcessInstanceImpl
implements RuleFlowProcessInstance,
AgendaEventListener,
RuleFlowEventListener {
    private static final long serialVersionUID = 400L;
    private InternalWorkingMemory workingMemory;
    private final List nodeInstances = new ArrayList();

    public RuleFlowProcess getRuleFlowProcess() {
        return (RuleFlowProcess)this.getProcess();
    }

    public void addNodeInstance(RuleFlowNodeInstance nodeInstance) {
        this.nodeInstances.add(nodeInstance);
        nodeInstance.setProcessInstance(this);
    }

    public void removeNodeInstance(RuleFlowNodeInstance nodeInstance) {
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection getNodeInstances() {
        return Collections.unmodifiableCollection(new ArrayList(this.nodeInstances));
    }

    public RuleFlowNodeInstance getFirstNodeInstance(long nodeId) {
        Iterator iterator = this.nodeInstances.iterator();
        while (iterator.hasNext()) {
            RuleFlowNodeInstance nodeInstance = (RuleFlowNodeInstance)iterator.next();
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    public Agenda getAgenda() {
        if (this.workingMemory == null) {
            return null;
        }
        return this.workingMemory.getAgenda();
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        if (this.workingMemory != null) {
            throw new IllegalArgumentException("A working memory can only be set once.");
        }
        this.workingMemory = workingMemory;
        workingMemory.addEventListener(this);
        workingMemory.addEventListener(this);
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public RuleFlowNodeInstance getNodeInstance(Node node) {
        if (node instanceof RuleSetNode) {
            RuleFlowNodeInstance result = (RuleFlowNodeInstance)((Object)this.getAgenda().getRuleFlowGroup(((RuleSetNode)node).getRuleFlowGroup()));
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof Split) {
            RuleFlowNodeInstance result = this.getFirstNodeInstance(node.getId());
            if (result == null) {
                result = new RuleFlowSplitInstanceImpl();
                result.setNodeId(node.getId());
                this.addNodeInstance(result);
            }
            return result;
        }
        if (node instanceof Join) {
            RuleFlowNodeInstance result = this.getFirstNodeInstance(node.getId());
            if (result == null) {
                result = new RuleFlowJoinInstanceImpl();
                result.setNodeId(node.getId());
                this.addNodeInstance(result);
            }
            return result;
        }
        if (node instanceof StartNode) {
            StartNodeInstanceImpl result = new StartNodeInstanceImpl();
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof EndNode) {
            EndNodeInstanceImpl result = new EndNodeInstanceImpl();
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof MilestoneNode) {
            MilestoneNodeInstanceImpl result = new MilestoneNodeInstanceImpl();
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof SubFlowNode) {
            SubFlowNodeInstanceImpl result = new SubFlowNodeInstanceImpl();
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof ActionNode) {
            ActionNodeInstanceImpl result = new ActionNodeInstanceImpl();
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        throw new IllegalArgumentException("Illegal node type: " + node.getClass());
    }

    public void start() {
        if (this.getState() != 0) {
            throw new IllegalArgumentException("A process instance can only be started once");
        }
        this.setState(1);
        this.getNodeInstance(this.getRuleFlowProcess().getStart()).trigger(null);
    }

    public void setState(int state) {
        super.setState(state);
        if (state == 2) {
            while (!this.nodeInstances.isEmpty()) {
                RuleFlowNodeInstance nodeInstance = (RuleFlowNodeInstance)this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
            this.workingMemory.removeEventListener(this);
            this.workingMemory.removeEventListener(this);
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireRuleFlowProcessCompleted(this, this.workingMemory);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RuleFlowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcess().getId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        String ruleFlowGroup = event.getActivation().getRule().getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
            String ruleName = event.getActivation().getRule().getName();
            Iterator iterator = this.getNodeInstances().iterator();
            while (iterator.hasNext()) {
                String milestoneName;
                RuleFlowNodeInstance nodeInstance = (RuleFlowNodeInstance)iterator.next();
                if (!(nodeInstance instanceof MilestoneNodeInstanceImpl) || !(milestoneName = "RuleFlow-Milestone-" + this.getProcess().getId() + "-" + nodeInstance.getNodeId()).equals(ruleName)) continue;
                ((MilestoneNodeInstanceImpl)nodeInstance).triggerCompleted();
            }
        }
    }

    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
    }

    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
    }

    public void ruleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
    }

    public void ruleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
    }

    public void ruleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
    }

    public void ruleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
        Iterator iterator = this.getNodeInstances().iterator();
        while (iterator.hasNext()) {
            RuleFlowNodeInstance nodeInstance = (RuleFlowNodeInstance)iterator.next();
            if (!(nodeInstance instanceof SubFlowNodeInstanceImpl)) continue;
            SubFlowNodeInstanceImpl subFlowInstance = (SubFlowNodeInstanceImpl)nodeInstance;
            if (event.getRuleFlowProcessInstance().getId() != subFlowInstance.getProcessInstanceId()) continue;
            subFlowInstance.triggerCompleted();
        }
    }
}

