/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;
import org.mvel.Soundex;

public class StringFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new StringFactory();

    private StringFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StringFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return StringEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return StringNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MATCHES) {
            return StringMatchesEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_MATCHES) {
            return StringNotMatchesEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return StringMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return StringNotMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.SOUNDSLIKE) {
            return StringSoundsLikeEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for StringEvaluator");
    }

    static class StringSoundsLikeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringSoundsLikeEvaluator();

        private StringSoundsLikeEvaluator() {
            super(ValueType.STRING_TYPE, Operator.SOUNDSLIKE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            String value1 = (String)extractor.getValue(workingMemory, object1);
            String value2 = (String)object2.getValue();
            if (value1 == null) {
                return false;
            }
            return Soundex.soundex((String)value1).equals(Soundex.soundex((String)value2));
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return Soundex.soundex((String)value).equals(Soundex.soundex((String)((String)context.declaration.getExtractor().getValue(workingMemory, left))));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            String value = (String)context.extractor.getValue(workingMemory, right);
            if (value == null) {
                return false;
            }
            return Soundex.soundex((String)value).equals(Soundex.soundex((String)((String)((VariableRestriction.ObjectVariableContextEntry)context).left)));
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return false;
            }
            return Soundex.soundex((String)((String)value1)).equals(Soundex.soundex((String)((String)value2)));
        }

        public String toString() {
            return "Strings sound alike";
        }
    }

    static class StringNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMemberOfEvaluator();

        private StringNotMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "String not memberOf";
        }
    }

    static class StringMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMemberOfEvaluator();

        private StringMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "String memberOf";
        }
    }

    static class StringNotMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMatchesEvaluator();

        private StringNotMatchesEvaluator() {
            super(ValueType.STRING_TYPE, Operator.NOT_MATCHES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            String value1 = (String)extractor.getValue(workingMemory, object1);
            String value2 = (String)object2.getValue();
            if (value1 == null) {
                return false;
            }
            return !value1.matches(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return !value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            String value = (String)context.extractor.getValue(workingMemory, right);
            if (value == null) {
                return false;
            }
            return !value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return false;
            }
            return !((String)value1).matches((String)value2);
        }

        public String toString() {
            return "String not matches";
        }
    }

    static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        private StringMatchesEvaluator() {
            super(ValueType.STRING_TYPE, Operator.MATCHES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            String value1 = (String)extractor.getValue(workingMemory, object1);
            String value2 = (String)object2.getValue();
            if (value1 == null) {
                return false;
            }
            return value1.matches(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            String value = (String)context.extractor.getValue(workingMemory, right);
            if (value == null) {
                return false;
            }
            return value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return false;
            }
            return ((String)value1).matches((String)value2);
        }

        public String toString() {
            return "String matches";
        }
    }

    static class StringNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotEqualEvaluator();

        private StringNotEqualEvaluator() {
            super(ValueType.STRING_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "String !=";
        }
    }

    static class StringEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringEqualEvaluator();

        private StringEqualEvaluator() {
            super(ValueType.STRING_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "String ==";
        }
    }
}

