/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.math.BigDecimal;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class BigDecimalFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new BigDecimalFactory();

    private BigDecimalFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BigDecimalFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return BigDecimalEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return BigDecimalNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return BigDecimalLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return BigDecimalLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return BigDecimalGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return BigDecimalGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return BigDecimalMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return BigDecimalNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for BigDecimalEvaluator");
    }

    static class BigDecimalNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalNotMemberOfEvaluator();

        private BigDecimalNotMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "BigDecimal not memberOf";
        }
    }

    static class BigDecimalMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalMemberOfEvaluator();

        private BigDecimalMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "BigDecimal memberOf";
        }
    }

    static class BigDecimalGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BigDecimalGreaterOrEqualEvaluator();

        private BigDecimalGreaterOrEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = (BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigDecimal)context.declaration.getExtractor().getValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).left) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigDecimal)extractor2.getValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "BigDecimal >=";
        }
    }

    static class BigDecimalGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalGreaterEvaluator();

        private BigDecimalGreaterEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = (BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigDecimal)context.declaration.getExtractor().getValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).left) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigDecimal)extractor2.getValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "BigDecimal >";
        }
    }

    static class BigDecimalLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalLessOrEqualEvaluator();

        private BigDecimalLessOrEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = (BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigDecimal)context.declaration.getExtractor().getValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).left) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigDecimal)extractor2.getValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "BigDecimal <=";
        }
    }

    static class BigDecimalLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalLessEvaluator();

        private BigDecimalLessEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = (BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigDecimal)context.declaration.getExtractor().getValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigDecimal)((VariableRestriction.ObjectVariableContextEntry)context).left) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = (BigDecimal)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigDecimal)extractor2.getValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "BigDecimal <";
        }
    }

    static class BigDecimalNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalNotEqualEvaluator();

        private BigDecimalNotEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            BigDecimal value2 = object2.getBigDecimalValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "BigDecimal !=";
        }
    }

    static class BigDecimalEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalEqualEvaluator();

        private BigDecimalEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            BigDecimal value2 = object2.getBigDecimalValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "BigDecimal ==";
        }
    }
}

