/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.drools.RuleBase;
import org.drools.RuntimeDroolsException;
import org.drools.agent.AgentEventListener;
import org.drools.rule.Package;

public abstract class PackageProvider {
    protected AgentEventListener listener;

    abstract Package[] loadPackageChanges();

    abstract void configure(Properties var1);

    static void removePackage(String name, RuleBase rb) {
        Package[] ps = rb.getPackages();
        if (ps == null) {
            return;
        }
        for (int i = 0; i < ps.length; ++i) {
            Package p = ps[i];
            if (!p.getName().equals(name)) continue;
            rb.removePackage(name);
            return;
        }
    }

    static void applyChanges(RuleBase rb, boolean removeExistingPackages, Package[] ps, AgentEventListener listener) {
        PackageProvider.applyChanges(rb, removeExistingPackages, Arrays.asList(ps), listener);
    }

    static void applyChanges(RuleBase rb, boolean removeExistingPackages, Collection changes, AgentEventListener listener) {
        rb.lock();
        if (changes == null) {
            return;
        }
        Iterator iter = changes.iterator();
        while (iter.hasNext()) {
            Package p = (Package)iter.next();
            if (removeExistingPackages) {
                PackageProvider.removePackage(p.getName(), rb);
            }
            try {
                listener.info("Adding package called " + p.getName());
                rb.addPackage(p);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException(e);
            }
        }
        rb.unlock();
    }

    public void setAgentListener(AgentEventListener listener) {
        this.listener = listener;
    }
}

