/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public class EjbEncInjector
implements EncInjector {
    private static final Logger log = Logger.getLogger(EjbEncInjector.class);
    private String ejbLink;
    private Class refClass;
    private String jndiName;
    private String error;
    private String encName;

    public EjbEncInjector(String name, String mappedName, String error) {
        this.jndiName = mappedName;
        this.error = error;
        this.encName = name;
    }

    public EjbEncInjector(String name, Class refClass, String ejbLink, String error) {
        this.refClass = refClass;
        String refClassName = refClass == null ? "NULL" : refClass.getName();
        this.ejbLink = ejbLink;
        this.error = error;
        this.encName = name;
        if (refClass == null && ejbLink == null) {
            throw new RuntimeException("cannot have null refClass and ejbLink for encName: " + name);
        }
    }

    public void inject(InjectionContainer container) {
        if (this.jndiName == null || this.jndiName.equals("")) {
            if (this.ejbLink != null && !"".equals(this.ejbLink)) {
                this.jndiName = container.getEjbJndiName(this.ejbLink, this.refClass);
            } else {
                try {
                    if (this.refClass == null) {
                        throw new RuntimeException("searching for @EJB" + this.encName + " has null refClass and null ejbLink.");
                    }
                    this.jndiName = container.getEjbJndiName(this.refClass);
                }
                catch (NameNotFoundException e) {
                    throw new RuntimeException("could not resolve global JNDI name for " + this.error + " for container " + container.getIdentifier() + ": reference class: " + this.refClass.getName() + " ejbLink: " + this.ejbLink + " " + e.getMessage());
                }
            }
        }
        try {
            if (this.jndiName == null) {
                throw new RuntimeException("Failed to populate ENC: " + this.encName + " global jndi name was null");
            }
            Util.rebind((Context)container.getEnc(), (String)this.encName, (Object)new LinkRef(this.jndiName));
        }
        catch (NamingException e) {
            throw new RuntimeException("could not bind enc name '" + this.encName + "' for " + this.error + " for container " + container.getIdentifier() + ": reference class: " + this.refClass.getName() + " ejbLink: " + this.ejbLink + " " + e.getMessage());
        }
    }
}

