/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.quartz;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.ejb.TimerService;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.TimerServiceFactory;
import org.jboss.ejb3.timerservice.quartz.TimerServiceImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerService;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;

public class QuartzTimerServiceFactory
extends TimerServiceFactory {
    private static final Logger log = Logger.getLogger(QuartzTimerServiceFactory.class);
    private TransactionManager tm;
    private static Scheduler scheduler;
    private Properties properties;
    private Properties sqlProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema() {
        try {
            this.tm.begin();
            try {
                Connection conn = this.getConnection();
                try {
                    boolean success = this.execute(conn, "CREATE_TABLE_JOB_DETAILS");
                    if (success) {
                        this.execute(conn, "CREATE_TABLE_JOB_LISTENERS");
                        this.execute(conn, "CREATE_TABLE_TRIGGERS");
                        this.execute(conn, "CREATE_TABLE_SIMPLE_TRIGGERS");
                        this.execute(conn, "CREATE_TABLE_CRON_TRIGGERS");
                        this.execute(conn, "CREATE_TABLE_BLOB_TRIGGERS");
                        this.execute(conn, "CREATE_TABLE_TRIGGER_LISTENERS");
                        this.execute(conn, "CREATE_TABLE_CALENDARS");
                        this.execute(conn, "CREATE_TABLE_PAUSED_TRIGGER_GRPS");
                        this.execute(conn, "CREATE_TABLE_FIRED_TRIGGERS");
                        this.execute(conn, "CREATE_TABLE_SCHEDULER_STATE");
                        this.execute(conn, "CREATE_TABLE_LOCKS");
                        this.execute(conn, "INSERT_TRIGGER_ACCESS");
                        this.execute(conn, "INSERT_JOB_ACCESS");
                        this.execute(conn, "INSERT_CALENDAR_ACCESS");
                        this.execute(conn, "INSERT_STATE_ACCESS");
                        this.execute(conn, "INSERT_MISFIRE_ACCESS");
                    }
                }
                finally {
                    conn.close();
                }
                this.tm.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (HeuristicMixedException e) {
                throw new RuntimeException(e);
            }
            catch (HeuristicRollbackException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.tm.getStatus() == 0) {
                    this.tm.rollback();
                }
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TimerService createTimerService(ObjectName objectName, TimedObjectInvoker invoker) {
        Scheduler scheduler = QuartzTimerServiceFactory.getScheduler();
        if (scheduler == null) {
            return null;
        }
        return new TimerServiceImpl(scheduler, objectName, invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(Connection conn, String stmtName) throws SQLException {
        String sql = this.sqlProperties.getProperty(stmtName);
        if (sql == null) {
            throw new IllegalStateException("No sql set for '" + stmtName + "'");
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.warn((Object)("sql failed: " + sql));
            if (log.isDebugEnabled()) {
                log.debug((Object)("sql failed: " + sql), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    private Connection getConnection() throws SQLException {
        return DBConnectionManager.getInstance().getConnection("myDS");
    }

    protected static Scheduler getScheduler() {
        if (scheduler == null) {
            return null;
        }
        return scheduler;
    }

    public void removeTimerService(TimerService aTimerService) {
        TimerServiceImpl timerService = (TimerServiceImpl)aTimerService;
        timerService.shutdown();
    }

    public void restoreTimerService(TimerService aTimerService) {
    }

    public void setDataSource(String jndiName) {
        JNDIConnectionProvider connectionProvider = new JNDIConnectionProvider(jndiName, false);
        DBConnectionManager.getInstance().addConnectionProvider("myDS", (ConnectionProvider)connectionProvider);
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public void setSqlProperties(Properties props) {
        this.sqlProperties = props;
    }

    public synchronized void start() throws Exception {
        if (scheduler != null) {
            throw new IllegalStateException("already started");
        }
        log.debug((Object)("properties = " + this.properties));
        InitialContext ctx = new InitialContext();
        this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
        this.createSchema();
        StdSchedulerFactory factory = this.properties == null ? new StdSchedulerFactory() : new StdSchedulerFactory(this.properties);
        scheduler = factory.getScheduler();
        scheduler.start();
    }

    public synchronized void stop() throws Exception {
        if (scheduler == null) {
            throw new IllegalStateException("already stopped");
        }
        scheduler.shutdown();
        scheduler = null;
    }
}

