/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.util.proxy.MethodHandler;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class BaseStatelessProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatelessProxyFactory.class);
    protected Context proxyFactoryContext;
    protected String jndiName;
    private javassist.util.proxy.ProxyFactory proxyFactory;
    private Class proxyClass;
    private Constructor proxyConstructor;

    protected Object constructProxy(InvocationHandler handler) {
        try {
            Object[] args = new Object[]{handler};
            Object proxy = this.proxyConstructor.newInstance(args);
            return proxy;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public final Object createProxy(Object id) {
        assert (id == null) : "stateless bean must not have an id";
        return this.createProxy();
    }

    public void init() throws Exception {
        this.initializeJndiName();
        Class[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyConstructor = proxyClass.getConstructor(constructorParams);
    }

    public void start() throws Exception {
        this.init();
        Object proxy = this.createProxy();
        try {
            Util.rebind((Context)this.container.getInitialContext(), (String)this.jndiName, (Object)proxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateless proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.container.getInitialContext(), (String)this.jndiName);
    }

    protected abstract Class[] getInterfaces();

    protected abstract void initializeJndiName();

    public void setContainer(Container container) {
        this.container = container;
        this.advisor = (Advisor)container;
    }

    private static class MethodHandlerAdapter
    implements MethodHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private InvocationHandler delegate;

        private MethodHandlerAdapter(InvocationHandler delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate must not be null");
            }
            this.delegate = delegate;
        }

        public Object invoke(Object self, Method thisMethod, Method process, Object[] args) throws Throwable {
            return this.delegate.invoke(self, thisMethod, args);
        }
    }
}

