/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb3.mdb.MDBConfig;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.system.ServiceMBeanSupport;

public class DLQHandler
extends ServiceMBeanSupport {
    public static final String JBOSS_ORIG_DESTINATION = "JBOSS_ORIG_DESTINATION";
    public static final String JBOSS_ORIG_MESSAGEID = "JBOSS_ORIG_MESSAGEID";
    private static final String JMS_JBOSS_REDELIVERY_COUNT = "JMS_JBOSS_REDELIVERY_COUNT";
    private static final String JMS_JBOSS_REDELIVERY_LIMIT = "JMS_JBOSS_REDELIVERY_LIMIT";
    private int deliveryMode = 2;
    private int priority = 4;
    private QueueConnection connection;
    private Queue dlq;
    private JMSProviderAdapter providerAdapter;
    private Hashtable resentBuffer = new Hashtable();
    private MDBConfig config;

    public DLQHandler(JMSProviderAdapter providerAdapter, MDBConfig config) {
        this.providerAdapter = providerAdapter;
        this.config = config;
    }

    protected void createService() throws Exception {
        Context ctx = this.providerAdapter.getInitialContext();
        try {
            String factoryName = this.providerAdapter.getQueueFactoryRef();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(factoryName);
            this.log.debug((Object)("Using factory: " + factory));
            this.connection = this.config.getDlqUser() == null ? factory.createQueueConnection() : factory.createQueueConnection(this.config.getDlqUser(), this.config.getDlqPassword());
            this.log.debug((Object)("Created connection: " + this.connection));
            this.dlq = (Queue)ctx.lookup(this.config.getDlq());
            this.log.debug((Object)("Using Queue: " + this.dlq));
        }
        catch (Exception e) {
            if (e instanceof JMSException) {
                throw e;
            }
            JMSException x = new JMSException("Error creating the dlq connection: " + e.getMessage());
            x.setLinkedException(e);
            throw x;
        }
        finally {
            ctx.close();
        }
    }

    protected void startService() throws Exception {
        this.connection.start();
    }

    protected void stopService() throws Exception {
        this.connection.stop();
    }

    protected void destroyService() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        this.dlq = null;
        this.providerAdapter = null;
    }

    public boolean handleRedeliveredMessage(Message msg, Transaction tx) {
        boolean handled = false;
        int max = this.config.getDlqMaxTimesRedelivered();
        String id = null;
        boolean jbossmq = true;
        int count = 0;
        try {
            if (msg.propertyExists(JMS_JBOSS_REDELIVERY_LIMIT)) {
                max = msg.getIntProperty(JMS_JBOSS_REDELIVERY_LIMIT);
            }
            if (msg.propertyExists(JMS_JBOSS_REDELIVERY_COUNT)) {
                count = msg.getIntProperty(JMS_JBOSS_REDELIVERY_COUNT);
            } else {
                id = msg.getJMSMessageID();
                if (id == null) {
                    this.log.error((Object)"Message id is null, can't handle message");
                    return false;
                }
                count = this.incrementResentCount(id);
                jbossmq = false;
            }
            if (count > max) {
                id = msg.getJMSMessageID();
                this.log.warn((Object)("Message resent too many times; sending it to DLQ; message id=" + id));
                this.sendMessage(msg);
                this.deleteFromBuffer(id);
                handled = true;
            } else if (!jbossmq && tx != null) {
                DLQSynchronization synch = new DLQSynchronization(id);
                try {
                    tx.registerSynchronization((Synchronization)synch);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error registering DlQ Synchronization with transaction " + tx), (Throwable)e);
                }
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"Could not send message to Dead Letter Queue", (Throwable)e);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Message msg) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        QueueSession session = null;
        QueueSender sender = null;
        try {
            msg = this.makeWritable(msg, trace);
            msg.setStringProperty(JBOSS_ORIG_MESSAGEID, msg.getJMSMessageID());
            Destination d = msg.getJMSDestination();
            if (d != null) {
                msg.setStringProperty(JBOSS_ORIG_DESTINATION, d.toString());
            }
            session = this.connection.createQueueSession(false, 1);
            sender = session.createSender(this.dlq);
            if (trace) {
                this.log.trace((Object)("Sending message to DLQ; destination=" + this.dlq + ", session=" + session + ", sender=" + sender));
            }
            sender.send(msg, this.deliveryMode, this.priority, (long)this.config.getDlqTimeToLive());
            if (trace) {
                this.log.trace((Object)"Message sent.");
            }
        }
        finally {
            try {
                if (sender != null) {
                    sender.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close sender or session; ignoring", (Throwable)e);
            }
        }
    }

    protected int incrementResentCount(String id) {
        BufferEntry entry = null;
        boolean trace = this.log.isTraceEnabled();
        if (!this.resentBuffer.containsKey(id)) {
            if (trace) {
                this.log.trace((Object)("Making new entry for id " + id));
            }
            entry = new BufferEntry();
            entry.id = id;
            entry.count = 1;
            this.resentBuffer.put(id, entry);
        } else {
            entry = (BufferEntry)this.resentBuffer.get(id);
            ++entry.count;
            if (trace) {
                this.log.trace((Object)("Incremented old entry for id " + id + " count " + entry.count));
            }
        }
        return entry.count;
    }

    protected void deleteFromBuffer(String id) {
        this.resentBuffer.remove(id);
    }

    protected Message makeWritable(Message msg, boolean trace) throws JMSException {
        String key;
        Hashtable<String, Object> tmp = new Hashtable<String, Object>();
        Enumeration en = msg.getPropertyNames();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            tmp.put(key, msg.getObjectProperty(key));
        }
        msg.clearProperties();
        Enumeration keys = tmp.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            try {
                msg.setObjectProperty(key, tmp.get(key));
            }
            catch (JMSException ignored) {
                if (!trace) continue;
                this.log.trace((Object)("Could not copy message property " + key), (Throwable)ignored);
            }
        }
        return msg;
    }

    public String toString() {
        return super.toString() + "{ destinationJNDI=" + this.config.getDlq() + ", maxResent=" + this.config.getDlqMaxTimesRedelivered() + ", timeToLive=" + this.config.getDlqTimeToLive() + " }";
    }

    protected class DLQSynchronization
    implements Synchronization {
        String id;

        public DLQSynchronization(String id) {
            this.id = id;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                DLQHandler.this.deleteFromBuffer(this.id);
            }
        }
    }

    private class BufferEntry {
        int count;
        String id;

        private BufferEntry() {
        }
    }
}

