/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.enc;

import javax.naming.NameNotFoundException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EAR;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ProxyFactoryHelper;

public abstract class DeploymentEjbResolver {
    protected EAR ear;
    protected String errorName;

    protected DeploymentEjbResolver(EAR ear, String errorName) {
        this.ear = ear;
        this.errorName = errorName;
    }

    protected abstract EJBContainer searchDeploymentInternally(String var1, Class var2);

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        int hashIndex = ejbLink.indexOf(35);
        if (hashIndex != -1) {
            if (this.ear == null) {
                return null;
            }
            String relativePath = ejbLink.substring(0, hashIndex);
            Ejb3Deployment dep = this.ear.findRelativeDeployment(relativePath);
            if (dep == null) {
                return null;
            }
            String ejbName = ejbLink.substring(hashIndex);
            return dep.getEjbContainer(ejbName, businessIntf);
        }
        EJBContainer ejb = this.searchDeploymentInternally(ejbLink, businessIntf);
        if (ejb != null) {
            return ejb;
        }
        for (Object obj : Ejb3Registry.getContainers()) {
            EJBContainer container = (EJBContainer)obj;
            if (!container.getEjbName().equals(ejbLink)) continue;
            return container;
        }
        return null;
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        EJBContainer container = this.getEjbContainer(ejbLink, businessIntf);
        if (container == null) {
            return null;
        }
        return ProxyFactoryHelper.getJndiName(container, businessIntf);
    }

    public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException {
        EJBContainer container = null;
        for (Object obj : deployment.getEjbContainers().values()) {
            EJBContainer newContainer = (EJBContainer)obj;
            if (container == newContainer || !ProxyFactoryHelper.publishesInterface(newContainer, businessIntf)) continue;
            if (container != null) {
                throw new NameNotFoundException("duplicated in " + this.errorName);
            }
            container = newContainer;
        }
        return container;
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        EJBContainer rtnContainer = null;
        rtnContainer = this.searchForEjbContainerInternally(businessIntf);
        if (rtnContainer != null) {
            return rtnContainer;
        }
        String jarName = null;
        if (this.ear != null) {
            for (Ejb3Deployment deployment : this.ear.getEjbDeployments()) {
                EJBContainer newContainer = this.getEjbContainer(deployment, businessIntf);
                if (rtnContainer == newContainer) continue;
                if (rtnContainer != null && newContainer != null) {
                    throw new NameNotFoundException("duplicated in .ear within " + jarName + " and " + deployment.getDeploymentUnit().getShortName());
                }
                if (newContainer == null) continue;
                rtnContainer = newContainer;
                jarName = deployment.getDeploymentUnit().getShortName();
            }
        }
        if (rtnContainer != null) {
            return rtnContainer;
        }
        for (Container container : Ejb3Registry.getContainers()) {
            EJBContainer ejbContainer = (EJBContainer)container;
            if (ejbContainer == rtnContainer || !ProxyFactoryHelper.publishesInterface(container, businessIntf)) continue;
            if (rtnContainer != null) {
                throw new NameNotFoundException("duplicated in " + ejbContainer.getDeployment().getDeploymentUnit().getShortName() + " and " + jarName);
            }
            rtnContainer = ejbContainer;
            jarName = ejbContainer.getDeployment().getDeploymentUnit().getShortName();
        }
        if (rtnContainer != null) {
            return rtnContainer;
        }
        throw new NameNotFoundException("not used by any EJBs");
    }

    protected abstract EJBContainer searchForEjbContainerInternally(Class var1) throws NameNotFoundException;

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        EJBContainer container = this.getEjbContainer(businessIntf);
        String jndiName = ProxyFactoryHelper.getJndiName(container, businessIntf);
        if (jndiName == null) {
            throw new NameNotFoundException("not used by any EJBs");
        }
        return jndiName;
    }
}

