/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.LocalHome;
import javax.ejb.RemoteHome;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyDeployer;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.logging.Logger;
import org.jboss.serial.io.MarshalledObjectForLocalCalls;

public abstract class SessionContainer
extends EJBContainer {
    private static final Logger log = Logger.getLogger(SessionContainer.class);
    protected ProxyDeployer proxyDeployer;
    protected Map clusterFamilies = new HashMap();
    protected ThreadLocalStack<InvokedMethod> invokedMethod = new ThreadLocalStack();

    public SessionContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
        this.proxyDeployer = new ProxyDeployer(this);
    }

    public Class getInvokedBusinessInterface() {
        Class[] remoteInterfaces;
        InvokedMethod method = this.invokedMethod.get();
        if (method == null) {
            throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
        }
        if (method.method == null) {
            throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
        }
        if (method.isLocalInterface) {
            return method.method.getDeclaringClass();
        }
        for (Class intf : remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this)) {
            try {
                intf.getMethod(method.method.getName(), method.method.getParameterTypes());
                return intf;
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        throw new IllegalStateException("Unable to find geInvokedBusinessInterface()");
    }

    public void instantiated() {
        super.instantiated();
        this.proxyDeployer.initializeRemoteBindingMetadata();
        this.proxyDeployer.initializeLocalBindingMetadata();
    }

    public void processMetadata(DependencyPolicy dependencyPolicy) {
        super.processMetadata(dependencyPolicy);
    }

    public void start() throws Exception {
        super.start();
        Dispatcher.singleton.registerTarget((Object)this.getObjectName().getCanonicalName(), (Object)this);
        this.proxyDeployer.start();
    }

    public Map getClusterFamilies() {
        return this.clusterFamilies;
    }

    public void stop() throws Exception {
        try {
            this.proxyDeployer.stop();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            Dispatcher.singleton.unregisterTarget((Object)this.getObjectName().getCanonicalName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createMethodMap() {
        super.createMethodMap();
        try {
            LocalHome localHome;
            RemoteHome home = (RemoteHome)this.resolveAnnotation(RemoteHome.class);
            if (home != null) {
                long hash;
                int i;
                Method[] declaredMethods = home.value().getMethods();
                for (i = 0; i < declaredMethods.length; ++i) {
                    hash = MethodHashing.methodHash((Method)declaredMethods[i]);
                    this.advisedMethods.put(hash, (Object)declaredMethods[i]);
                }
                declaredMethods = EJBObject.class.getMethods();
                for (i = 0; i < declaredMethods.length; ++i) {
                    hash = MethodHashing.methodHash((Method)declaredMethods[i]);
                    this.advisedMethods.put(hash, (Object)declaredMethods[i]);
                }
            }
            if ((localHome = (LocalHome)this.resolveAnnotation(LocalHome.class)) != null) {
                long hash;
                int i;
                Method[] declaredMethods = localHome.value().getMethods();
                for (i = 0; i < declaredMethods.length; ++i) {
                    hash = MethodHashing.methodHash((Method)declaredMethods[i]);
                    this.advisedMethods.put(hash, (Object)declaredMethods[i]);
                }
                declaredMethods = EJBLocalObject.class.getMethods();
                for (i = 0; i < declaredMethods.length; ++i) {
                    hash = MethodHashing.methodHash((Method)declaredMethods[i]);
                    this.advisedMethods.put(hash, (Object)declaredMethods[i]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isHomeMethod(Method method) {
        if (EJBHome.class.isAssignableFrom(method.getDeclaringClass())) {
            return true;
        }
        return EJBLocalHome.class.isAssignableFrom(method.getDeclaringClass());
    }

    protected boolean isEJBObjectMethod(Method method) {
        if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
            return true;
        }
        return method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject");
    }

    protected boolean isHandleMethod(Method method) {
        return method.getDeclaringClass().getName().equals("javax.ejb.Handle");
    }

    public static InvocationResponse marshallException(Invocation invocation, Throwable exception, Map responseContext) throws Throwable {
        if (!invocation.getMetaData().hasTag("IS_LOCAL")) {
            throw exception;
        }
        InvocationResponse response = new InvocationResponse();
        response.setContextInfo(responseContext);
        response.addAttachment((Object)"IS_LOCAL_EXCEPTION", (Object)new MarshalledObjectForLocalCalls((Object)exception));
        return response;
    }

    public static InvocationResponse marshallResponse(Invocation invocation, Object rtn, Map responseContext) throws IOException {
        InvocationResponse response = rtn != null && invocation.getMetaData().hasTag("IS_LOCAL") ? new InvocationResponse((Object)new MarshalledObjectForLocalCalls(rtn)) : new InvocationResponse(rtn);
        response.setContextInfo(responseContext);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ProxyFactory factory, Object id, Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            Object object;
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Method unadvisedMethod = info.getUnadvisedMethod();
            if (unadvisedMethod != null && this.isHomeMethod(unadvisedMethod)) {
                Object object2 = this.invokeHomeMethod(factory, info, args);
                return object2;
            }
            if (unadvisedMethod != null && this.isEJBObjectMethod(unadvisedMethod)) {
                Object object3 = this.invokeEJBObjectMethod(factory, id, info, args);
                return object3;
            }
            Interceptor[] aspects = info.getInterceptors();
            EJBContainerInvocation nextInvocation = new StatefulContainerInvocation(info, aspects, id);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            nextInvocation = this.populateInvocation(nextInvocation);
            ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
            try {
                this.invokedMethod.push(new InvokedMethod(true, method));
                object = nextInvocation.invokeNext();
                this.invokedMethod.pop();
            }
            catch (Throwable throwable) {
                this.invokedMethod.pop();
                throw throwable;
            }
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    private Object invokeHomeMethod(ProxyFactory factory, MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("create")) {
            Class[] initParameterTypes = new Class[]{};
            Object[] initParameterValues = new Object[]{};
            if (unadvisedMethod.getParameterTypes().length > 0) {
                initParameterTypes = unadvisedMethod.getParameterTypes();
                initParameterValues = args;
            }
            Object id = this.createSession(initParameterTypes, initParameterValues);
            Object proxy = factory.createProxy(id);
            return proxy;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            if (args[0] instanceof Handle) {
                this.removeHandle((Handle)args[0]);
            } else {
                this.destroySession(args[0]);
            }
            return null;
        }
        throw new IllegalArgumentException("illegal home method " + unadvisedMethod);
    }

    protected abstract Object createSession(Class[] var1, Object[] var2);

    protected void destroySession(Object id) {
        throw new RuntimeException("NYI");
    }

    protected Object invokeEJBObjectMethod(ProxyFactory factory, Object id, MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("getEJBHome")) {
            return factory.createHomeProxy();
        }
        if (unadvisedMethod.getName().equals("getPrimaryKey")) {
            return id;
        }
        if (unadvisedMethod.getName().equals("isIdentical")) {
            if (id == null) {
                return false;
            }
            EJBObject bean = (EJBObject)args[0];
            Object primaryKey = bean.getPrimaryKey();
            if (primaryKey == null) {
                return false;
            }
            boolean isIdentical = id.equals(primaryKey);
            return isIdentical;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            this.destroySession(id);
            return null;
        }
        throw new RuntimeException("NYI");
    }

    protected EJBContainerInvocation populateInvocation(EJBContainerInvocation invocation) {
        return invocation;
    }

    protected abstract void removeHandle(Handle var1) throws Exception;

    public class InvokedMethod {
        public boolean isLocalInterface;
        public Method method;

        public InvokedMethod(boolean localInterface, Method method) {
            this.isLocalInterface = localInterface;
            this.method = method;
        }
    }
}

