/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.StringMemberValue;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.persistence.Entity;
import org.jboss.annotation.ejb.Consumer;
import org.jboss.annotation.ejb.Service;
import org.jboss.aop.AspectManager;
import org.jboss.aop.DomainDefinition;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;

public class Ejb3AnnotationHandler
implements Ejb3Handler {
    private static final Logger log = Logger.getLogger(Ejb3AnnotationHandler.class);
    protected DeploymentUnit di;
    protected ClassFile cf;
    protected List<String> ejbNames = new ArrayList<String>();
    protected Class ejbClass;
    protected String className;
    protected EJB_TYPE ejbType;
    protected Annotation annotation;
    protected AnnotationsAttribute visible;
    protected Hashtable ctxProperties;
    protected String defaultSLSBDomain;
    protected String defaultSFSBDomain;
    protected String defaultMDBDomain;
    protected String defaultServiceDomain;
    protected String defaultConsumerDomain;
    protected Ejb3Deployment deployment;

    public Ejb3AnnotationHandler(Ejb3Deployment deployment, ClassFile cf) {
        this.deployment = deployment;
        this.di = deployment.getDeploymentUnit();
        this.cf = cf;
        this.className = cf.getName();
        this.visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
        this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
        this.defaultMDBDomain = deployment.getDefaultMDBDomain();
        this.defaultServiceDomain = deployment.getDefaultServiceDomain();
        this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
    }

    public void setCtxProperties(Hashtable ctxProperties) {
        this.ctxProperties = ctxProperties;
    }

    private String getJaccContextId() {
        return this.di.getShortName();
    }

    public boolean isEjb() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isStateless(this.visible)) {
            return true;
        }
        if (EJB3Util.isMessageDriven(this.visible)) {
            return true;
        }
        return EJB3Util.isStatefulSession(this.visible);
    }

    public boolean isJBossBeanType() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isService(this.visible)) {
            return true;
        }
        return EJB3Util.isConsumer(this.visible);
    }

    public List getContainers(ClassFile cf, Ejb3Deployment deployment) throws Exception {
        ArrayList<EJBContainer> containers = new ArrayList<EJBContainer>();
        this.populateBaseInfo();
        for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ++ejbIndex) {
            EJBContainer container;
            String ejbName = this.ejbNames.get(ejbIndex);
            if (this.ejbType == EJB_TYPE.STATELESS) {
                container = this.getStatelessContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.STATEFUL) {
                container = this.getStatefulContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.MESSAGE_DRIVEN) {
                container = this.getMDB(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.SERVICE) {
                container = this.getServiceContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == EJB_TYPE.CONSUMER) {
                container = this.getConsumerContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            }
            log.debug((Object)("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + (Object)((Object)this.ejbType)));
        }
        return containers;
    }

    protected String getAspectDomain(int ejbIndex, String defaultDomain) {
        return EJB3Util.getAspectDomain(this.visible, defaultDomain);
    }

    protected ServiceContainer getServiceContainer(int ejbIndex) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultServiceDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new ServiceContainer(this.deployment.getMbeanServer(), this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
    }

    protected ConsumerContainer getConsumerContainer(int ejbIndex) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultConsumerDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new ConsumerContainer(this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.cf.getName(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
    }

    protected StatefulContainer getStatefulContainer(int ejbIndex) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultSFSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new StatefulContainer(this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
    }

    protected StatelessContainer getStatelessContainer(int ejbIndex) throws Exception {
        String containerName = this.getAspectDomain(ejbIndex, this.defaultSLSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        return new StatelessContainer(this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
    }

    protected String getMDBDomainName(int ejbIndex) {
        return this.defaultMDBDomain;
    }

    protected void createProxyFactories() {
    }

    protected MDB getMDB(int ejbIndex) throws Exception {
        return this.getMDB(ejbIndex, null);
    }

    protected MDB getMDB(int ejbIndex, EnterpriseBean xml) throws Exception {
        String domainName = this.getMDBDomainName(ejbIndex);
        String containerName = this.getAspectDomain(ejbIndex, domainName);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        MDB container = new MDB(this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.cf.getName(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
        return container;
    }

    protected void populateBaseInfo() throws Exception {
        String ejbName = null;
        this.ejbClass = this.di.getClassLoader().loadClass(this.className);
        this.visible = (AnnotationsAttribute)this.cf.getAttribute("RuntimeVisibleAnnotations");
        if (this.visible != null) {
            this.annotation = this.visible.getAnnotation(Stateless.class.getName());
            if (this.annotation != null) {
                this.ejbType = EJB_TYPE.STATELESS;
            } else {
                this.annotation = this.visible.getAnnotation(Stateful.class.getName());
                if (this.annotation != null) {
                    this.ejbType = EJB_TYPE.STATEFUL;
                } else {
                    this.annotation = this.visible.getAnnotation(Entity.class.getName());
                    if (this.annotation != null) {
                        this.ejbType = EJB_TYPE.ENTITY;
                    } else {
                        this.annotation = this.visible.getAnnotation(MessageDriven.class.getName());
                        if (this.annotation != null) {
                            this.ejbType = EJB_TYPE.MESSAGE_DRIVEN;
                        } else {
                            this.annotation = this.visible.getAnnotation(Service.class.getName());
                            if (this.annotation != null) {
                                this.ejbType = EJB_TYPE.SERVICE;
                            } else {
                                this.annotation = this.visible.getAnnotation(Consumer.class.getName());
                                if (this.annotation != null) {
                                    this.ejbType = EJB_TYPE.CONSUMER;
                                }
                            }
                        }
                    }
                }
            }
            if (this.annotation != null) {
                StringMemberValue mv = (StringMemberValue)this.annotation.getMemberValue("name");
                ejbName = mv != null ? mv.getValue() : this.ejbClass.getSimpleName();
            }
        }
        if (ejbName != null) {
            this.ejbNames.add(ejbName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EJB_TYPE {
        STATELESS,
        STATEFUL,
        MESSAGE_DRIVEN,
        ENTITY,
        SERVICE,
        CONSUMER;

    }
}

