/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import lu.luxtrust.cryptomathic.CIC_CTI_Certificate;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_X509;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_X509
extends CIC_CTI_Certificate
implements CryptoTI_X509 {
    private Log logger = Logger.getLogger(CIC_CTI_X509.class);
    private X509Certificate x509Certificate = null;
    private CertificateFactory factory = null;
    private CIC_CTI_Certificate certificate = null;

    public CIC_CTI_X509(CIC_CTI_Certificate certificate) throws CryptoTI_Exception {
        ByteArrayInputStream input = null;
        if (certificate == null) {
            this.logger.error("Provided certificate cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Provided certificate cannot be null");
        }
        try {
            try {
                this.factory = CertificateFactory.getInstance("X.509");
                input = new ByteArrayInputStream(certificate.getEncoded());
                this.certificate = certificate;
                this.x509Certificate = (X509Certificate)this.factory.generateCertificate(input);
            }
            catch (CertificateException e) {
                this.logger.error("Certificate generation exception", (Throwable)e, 131072);
                throw new CryptoTI_Exception(131072, "Certificate generation exception");
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.error("An Input/Output exception occured", (Throwable)e, 131072);
                throw new CryptoTI_Exception(131072, "An Input/Output exception occured");
            }
        }
    }

    public String getIssuerDN() throws CryptoTI_Exception {
        this.logger.debug("GET ISSUER DN /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available. IssuerDN cannot be retrieved.", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available. IssuerDN cannot be retrieved.");
        }
        return this.x509Certificate.getIssuerX500Principal().getName();
    }

    public byte[] getIssuerPublicKeyHash() throws CryptoTI_Exception {
        this.logger.debug("GET ISSUER PUBLIC KEY HASH /");
        this.logger.warn("Attribute \"Issuer Public Key Hash\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Issuer Public Key Hash is not available");
    }

    public byte[] getPublicKeyHash() throws CryptoTI_Exception {
        this.logger.debug("GET PUBLIC KEY HASH /");
        this.logger.warn("Attribute \"Public Key Hash\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Public Key Hash is not available");
    }

    public String getSerialNumber() throws CryptoTI_Exception {
        this.logger.debug("GET SERIAL NUMBER /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getSerialNumber().toString();
    }

    public String getSubjectDN() throws CryptoTI_Exception {
        this.logger.debug("GET SUBJECT DN /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getSubjectDN().getName();
    }

    public String getURL() throws CryptoTI_Exception {
        this.logger.debug("GET URL /");
        this.logger.warn("Attribute \"URL\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "URL is not available");
    }

    public boolean isKU_CrlSign() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE CRL SIGN /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[6];
    }

    public boolean isKU_DataEncipherment() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DATA ENCIPHERMENT /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[3];
    }

    public boolean isKU_DecipherOnly() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DECIPHER ONLY /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[8];
    }

    public boolean isKU_DigitalSignature() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DIGITAL SIGNATURE /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[0];
    }

    public boolean isKU_EncipherOnly() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE ENCIPHER ONLY /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[7];
    }

    public boolean isKU_KeyCertSign() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE CERTIFICATE SIGNING /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[5];
    }

    public boolean isKU_KeyEncipherment() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE KEY ENCIPHERMENT /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[2];
    }

    public boolean isKU_NonRepudiation() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE NON REPUDIATION /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[1];
    }

    public boolean isKU_hasKeyAgreement() throws CryptoTI_Exception {
        this.logger.debug("HAS KEY AGREEMENT /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.x509Certificate.getKeyUsage()[4];
    }

    public boolean isAuthority() throws CryptoTI_Exception {
        this.logger.debug("IS AUTHORITY /");
        if (this.x509Certificate == null) {
            this.logger.warn("x509Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "x509Certificate is not available");
        }
        return this.certificate.isAuthority();
    }

    public boolean isCategorySpecified() throws CryptoTI_Exception {
        this.logger.debug("IS CATEGORY SPECIFIED /");
        if (this.certificate == null) {
            this.logger.warn("CIC_CTI_Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "CIC_CTI_Certificate is not available");
        }
        return this.certificate.isCategorySpecified();
    }

    public boolean isOtherEntity() throws CryptoTI_Exception {
        this.logger.debug("IS OTHER ENTITY /");
        if (this.certificate == null) {
            this.logger.warn("CIC_CTI_Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "CIC_CTI_Certificate is not available");
        }
        return this.certificate.isOtherEntity();
    }

    public boolean isUserToken() throws CryptoTI_Exception {
        this.logger.debug("IS USER TOKEN /");
        if (this.certificate == null) {
            this.logger.warn("CIC_CTI_Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "CIC_CTI_Certificate is not available");
        }
        return this.certificate.isUserToken();
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        this.logger.debug("GET ALIAS /");
        if (this.certificate == null) {
            this.logger.warn("CIC_CTI_Certificate is not available", 131082);
            throw new CryptoTI_Exception(131082, "CIC_CTI_Certificate is not available");
        }
        return this.certificate.getAlias();
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        this.logger.debug("GET ENCODED /");
        if (this.certificate == null) {
            this.logger.warn("Encoded certificate value is not available", 131082);
            throw new CryptoTI_Exception(131082, "Encoded certificate value is not available");
        }
        return this.certificate.getEncoded();
    }

    public int hashCode() {
        this.logger.debug("HASH CODE /");
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = 31 * result + (this.x509Certificate == null ? 0 : this.x509Certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_X509 other = (CIC_CTI_X509)obj;
        if (this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate)) {
            return false;
        }
        return !(this.x509Certificate == null ? other.x509Certificate != null : !this.x509Certificate.equals(other.x509Certificate));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        if (this.certificate != null) {
            return this.certificate.toString();
        }
        return "null";
    }
}

