/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import lu.luxtrust.cryptoti.CryptoTI_User;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_NotSupportedException;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_User
implements CryptoTI_User {
    private Log logger = Logger.getLogger(CIC_CTI_User.class);
    private String userName = null;
    private String otp = null;

    public CIC_CTI_User(String userName, String password) throws CryptoTI_Exception {
        if (userName == null) {
            this.logger.error("Provided username cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Username cannot be null");
        }
        if (password == null) {
            this.logger.error("Provided password cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Provided password cannot be null");
        }
        this.userName = userName;
        this.otp = password;
    }

    public String getPassword() throws CryptoTI_Exception {
        this.logger.debug("GET PASSWORD /");
        this.logger.error("Get Password is not supported", 135168);
        throw new CryptoTI_NotSupportedException(135168, "Get Password is not supported");
    }

    protected String getUserOTP() throws CryptoTI_Exception {
        if (this.otp != null) {
            return this.otp;
        }
        this.logger.error("Attribute \"One time password\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"One time password\" is not available");
    }

    public String getUserName() throws CryptoTI_Exception {
        this.logger.debug("GET USERNAME /");
        if (this.userName != null) {
            return this.userName;
        }
        this.logger.error("Attribute \"Username\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Username\" is not available");
    }

    public boolean isLowPasswordCount() throws CryptoTI_Exception {
        this.logger.debug("IS LOW PASSWORDCOUNT /");
        this.logger.error("Attribute \"Is Low Password Count\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Is Low Password Count\" is not available");
    }

    public boolean isPasswordChangeRequired() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD CHANGE REQUIRED /");
        this.logger.error("Attribute \"Is Password Change Required\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Is Password Change Required\" is not available");
    }

    public boolean isPasswordFinalTry() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD FINAL TRY /");
        this.logger.error("Attribute \"Is Password final try\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Is Password final try\" is not available");
    }

    public boolean isPasswordLocked() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD LOCKED /");
        this.logger.error("Attribute \"Is Password Locked\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Is Password Locked\" is not available");
    }

    public boolean isUserPasswordInitialised() throws CryptoTI_Exception {
        this.logger.debug("IS USER PASSWORD INITIALISED /");
        this.logger.error("Attribute \"Is Password Initialised\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute \"Is Password Initialised\" is not available");
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        if (this.userName != null && this.otp != null) {
            return "User: " + this.userName;
        }
        return "null";
    }

    public int hashCode() {
        this.logger.debug("HASH CODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.otp == null ? 0 : this.otp.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_User other = (CIC_CTI_User)obj;
        if (this.otp == null ? other.otp != null : !this.otp.equals(other.otp)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

