/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import lu.luxtrust.cryptoti.CryptoTI_TokenInfo;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_TokenInfo
implements CryptoTI_TokenInfo {
    private static Log logger = Logger.getLogger(CIC_CTI_TokenInfo.class);
    private long maximumPinLength = -1L;
    private long minimumPinLength = -1L;
    private String pinFormat = null;

    public CIC_CTI_TokenInfo(String pinFormat, long maximumPinLength, long minimumPinLength) {
        this.maximumPinLength = maximumPinLength;
        this.minimumPinLength = minimumPinLength;
        this.pinFormat = pinFormat;
    }

    public String getFirmwareVersion() throws CryptoTI_Exception {
        logger.debug("GET FIRMWARE VERSION /");
        logger.warn("Attribute \"Firmware Version\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Firmware Version is not available");
    }

    public String getHardwareVersion() throws CryptoTI_Exception {
        logger.debug("GET HARDWARE VERSION /");
        logger.warn("Attribute \"Hardware Version is not available", 131082);
        throw new CryptoTI_Exception(131082, "Hardware Version is not available");
    }

    public String getLabel() throws CryptoTI_Exception {
        logger.debug("GET LABEL /");
        logger.warn("Attribute \"Label\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Label is not available");
    }

    public String getManufacturerID() throws CryptoTI_Exception {
        logger.debug("GET MANUFACTURER ID /");
        logger.warn("Attribute \"ManufacturerID\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "ManufacturerID is not available");
    }

    public long getMaximumPinLength() throws CryptoTI_Exception {
        logger.debug("GET MAXIMUM PIN LENGTH /");
        return this.maximumPinLength;
    }

    public long getMinimumPinLength() throws CryptoTI_Exception {
        logger.debug("GET MINIMUM PIN LENGTH /");
        return this.minimumPinLength;
    }

    public String getModel() throws CryptoTI_Exception {
        logger.debug("GET MODEL /");
        logger.warn("Attribute \"Model\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Model is not available");
    }

    public String getSerialNumber() throws CryptoTI_Exception {
        logger.debug("GET SERIAL NUMBER /");
        logger.warn("Attribute \"SerialNumber\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "SerialNumber is not available");
    }

    public boolean hasProtectedAuthentication() throws CryptoTI_Exception {
        logger.debug("HAS PROTECTED AUTHENTIFICATION /");
        return false;
    }

    public boolean isLoginRequired() throws CryptoTI_Exception {
        logger.debug("IS LOGIN REQUIRED /");
        return true;
    }

    public boolean isTokenInitialised() throws CryptoTI_Exception {
        logger.debug("IS TOKEN INITIALISED /");
        logger.warn("Attribute \"TokenInitialised\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "TokenInitialised is not available");
    }

    public boolean isWriteProtected() throws CryptoTI_Exception {
        logger.debug("IS WRITE PROTECTED /");
        logger.warn("Attribute \"WriteProtected\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "WriteProtected is not available");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.maximumPinLength ^ this.maximumPinLength >>> 32);
        result = 31 * result + (int)(this.minimumPinLength ^ this.minimumPinLength >>> 32);
        result = 31 * result + (this.pinFormat == null ? 0 : this.pinFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_TokenInfo other = (CIC_CTI_TokenInfo)obj;
        if (this.maximumPinLength != other.maximumPinLength) {
            return false;
        }
        if (this.minimumPinLength != other.minimumPinLength) {
            return false;
        }
        return !(this.pinFormat == null ? other.pinFormat != null : !this.pinFormat.equals(other.pinFormat));
    }

    public String toString() {
        logger.debug("TO STRING /");
        String str = null;
        try {
            str = "hasProtectedAuthentication: " + this.hasProtectedAuthentication();
        }
        catch (CryptoTI_Exception e) {
            logger.error((Exception)((Object)e), 0);
        }
        return str;
    }

    public String getPINFormat() throws CryptoTI_Exception {
        logger.debug("GET OTP FORMAT /");
        return this.pinFormat;
    }
}

