/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandler;
import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.common.SignatureResult;
import com.cryptomathic.security.RSAPublicKey;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import lu.luxtrust.crypto.digest.DigestAlgorithm;
import lu.luxtrust.crypto.digest.Digester;
import lu.luxtrust.crypto.digest.exceptions.Crypto_Exception;
import lu.luxtrust.cryptomathic.CIC_CTI_Certificate;
import lu.luxtrust.cryptomathic.CIC_CTI_Mechanism;
import lu.luxtrust.cryptomathic.CIC_CTI_PrivateKey;
import lu.luxtrust.cryptomathic.CIC_CTI_PublicKey;
import lu.luxtrust.cryptomathic.CIC_CTI_Session;
import lu.luxtrust.cryptomathic.CIC_CTI_TokenInfo;
import lu.luxtrust.cryptomathic.CIC_CTI_User;
import lu.luxtrust.cryptomathic.CIC_CTI_X509;
import lu.luxtrust.cryptoti.CryptoTI_Certificate;
import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.CryptoTI_PrivateKey;
import lu.luxtrust.cryptoti.CryptoTI_PublicKey;
import lu.luxtrust.cryptoti.CryptoTI_Session;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.CryptoTI_TokenInfo;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_Token
implements CryptoTI_Token {
    private Log logger = Logger.getLogger(CIC_CTI_Token.class);
    private CIC_CTI_TokenInfo _info = null;
    private boolean checkPWDFormat = false;
    byte[] dataToSign = new byte[0];
    private String mechanism = null;
    private AdvancedCSSignatureHandler token = null;
    private int signUpdateCounter = 0;
    private boolean signer4 = false;

    public CIC_CTI_Token(AdvancedCSSignatureHandler token, String pinFormat, long maximumPinLength, long minimumPinLength, boolean checkPWDFormat) throws CryptoTI_Exception {
        if (token == null) {
            this.logger.error("Token cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Token cannot be null");
        }
        if (pinFormat == null) {
            this.logger.error("PinFormat cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "PinFormat cannot be null");
        }
        this.token = token;
        this.checkPWDFormat = checkPWDFormat;
        this._info = new CIC_CTI_TokenInfo(pinFormat, maximumPinLength, minimumPinLength);
    }

    public CIC_CTI_Token(AdvancedCSSignatureHandler token, String pinFormat, long maximumPinLength, long minimumPinLength, boolean checkPWDFormat, boolean signer4Used) throws CryptoTI_Exception {
        if (token == null) {
            this.logger.error("Token cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Token cannot be null");
        }
        if (pinFormat == null) {
            this.logger.error("PinFormat cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "PinFormat cannot be null");
        }
        this.token = token;
        this.checkPWDFormat = checkPWDFormat;
        this.signer4 = signer4Used;
        this._info = new CIC_CTI_TokenInfo(pinFormat, maximumPinLength, minimumPinLength);
    }

    public void closeSession(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("CLOSE SESSION /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
    }

    public CryptoTI_TokenInfo getInfo() throws CryptoTI_Exception {
        this.logger.debug("GET INFO /");
        return this._info;
    }

    public CryptoTI_PrivateKey getPrivateKey(CryptoTI_PublicKey publicKey, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("GET PRIVATE KEY /PUBLIC KEY");
        if (publicKey == null) {
            this.logger.error("PublicKey cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "PublicKey cannot be null");
        }
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        return new CIC_CTI_PrivateKey();
    }

    public CryptoTI_PrivateKey getPrivateKey(CryptoTI_Certificate certificate, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("GET PRIVATE KEY /CERTIFICATE");
        if (certificate == null) {
            this.logger.error("Certificate cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Certificate cannot be null");
        }
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        return new CIC_CTI_PrivateKey();
    }

    public void initialise() throws CryptoTI_Exception {
        this.logger.debug("INITIALISE TOKEN /");
    }

    public void initialise(InputStream configurationFile) throws CryptoTI_Exception {
        this.logger.debug("INITIALISE TOKEN /INPUTSTREAM");
    }

    public void initialise(String pathToConfigurationFile) throws CryptoTI_Exception {
        this.logger.debug("INITIALISE TOKEN /CONFIGURATION FILE");
    }

    public CryptoTI_Certificate[] listCertificates(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("LIST CERTIFICATES /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        CIC_CTI_Session _ccsession = (CIC_CTI_Session)session;
        CryptoTI_Certificate[] _certificates = null;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = _ccsession.getSession().getCertificate();
        }
        catch (CertificateException e) {
            this.logger.error("Certificate could not be loaded: " + e.toString(), 131072);
            throw new CryptoTI_Exception(131072, "Certificate could not be loaded");
        }
        if (x509Certificate != null) {
            _certificates = new CIC_CTI_Certificate[]{new CIC_CTI_X509(new CIC_CTI_Certificate(x509Certificate))};
        }
        if (_certificates != null) {
            this.logger.debug("Number of certificates found: " + _certificates.length);
        } else {
            this.logger.debug("No certificates have been found");
        }
        return _certificates;
    }

    public CryptoTI_Mechanism[] listMechanisms() throws CryptoTI_Exception {
        this.logger.debug("LIST MECHANISMS /");
        CryptoTI_Mechanism[] _mechanisms = null;
        CIC_CTI_Mechanism sha1Mechanism = new CIC_CTI_Mechanism("CKM_SHA1_RSA_PKCS");
        if (sha1Mechanism == null) {
            this.logger.error("Mechanism could not be loaded", 131072);
            throw new CryptoTI_Exception(131072, "Mechanism could not be loaded");
        }
        CIC_CTI_Mechanism rsaMechanism = new CIC_CTI_Mechanism("CKM_RSA_PKCS");
        if (rsaMechanism == null) {
            this.logger.error("Mechanism could not be loaded", 131072);
            throw new CryptoTI_Exception(131072, "Mechanism could not be loaded");
        }
        CIC_CTI_Mechanism sha256Mechanism = new CIC_CTI_Mechanism("CKM_SHA256_RSA_PKCS");
        if (rsaMechanism == null) {
            this.logger.error("Mechanism could not be loaded", 131072);
            throw new CryptoTI_Exception(131072, "Mechanism could not be loaded");
        }
        _mechanisms = this.signer4 ? new CryptoTI_Mechanism[]{sha1Mechanism, rsaMechanism, sha256Mechanism} : new CryptoTI_Mechanism[]{sha1Mechanism, rsaMechanism};
        if (sha1Mechanism != null) {
            sha1Mechanism = null;
        }
        if (rsaMechanism != null) {
            rsaMechanism = null;
        }
        if (sha256Mechanism != null) {
            sha256Mechanism = null;
        }
        if (_mechanisms.length > 0) {
            this.logger.debug("Number of mechanisms found: " + _mechanisms.length);
        } else {
            this.logger.debug("No mechanisms have been found");
        }
        return _mechanisms;
    }

    public CryptoTI_PublicKey[] listPublicKeys(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("LIST PUBLICKEYS /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        CIC_CTI_Session _ccsession = (CIC_CTI_Session)session;
        CryptoTI_PublicKey[] _publickeys = null;
        RSAPublicKey publicKey = null;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = _ccsession.getSession().getCertificate();
        }
        catch (CertificateException e) {
            this.logger.error("Certificate could not be loaded", 131072);
            throw new CryptoTI_Exception(131072, "Certificate could not be loaded");
        }
        if (x509Certificate != null && (publicKey = (RSAPublicKey)x509Certificate.getPublicKey()) != null) {
            _publickeys = new CryptoTI_PublicKey[]{new CIC_CTI_PublicKey(publicKey)};
        }
        if (_publickeys != null) {
            this.logger.debug("Number of publicKeys found: " + _publickeys.length);
        } else {
            this.logger.debug("No certificates have been found");
        }
        return _publickeys;
    }

    public CryptoTI_Session openSession() throws CryptoTI_Exception {
        this.logger.debug("OPEN SESSION /");
        return new CIC_CTI_Session(this.token, this, this.checkPWDFormat);
    }

    public byte[] signFinal(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("SIGN FINAL /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (!session.isLoggedIn()) {
            this.logger.error("Not Logged In", 143373);
            throw new CryptoTI_SessionException(143373, "User is not logged in");
        }
        CIC_CTI_Session ccSession = (CIC_CTI_Session)session;
        Result sigRes = null;
        CIC_CTI_User user = (CIC_CTI_User)session.getUser();
        if (user != null && this.mechanism != null) {
            byte[] hashedData = null;
            Digester digester = new Digester();
            if (this.mechanism.equals("CKM_SHA1_RSA_PKCS")) {
                try {
                    hashedData = digester.calculateHash(this.dataToSign, DigestAlgorithm.SHA1);
                }
                catch (Crypto_Exception e) {
                    this.logger.error("Error creating hash value of data to sign", (Throwable)e, 131072);
                    throw new CryptoTI_Exception(131072, "Error creating hash value of data to sign");
                }
                sigRes = ccSession.getSession().createSignatureHash(user.getUserOTP(), hashedData, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1, AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS1);
            } else if (this.mechanism.equals("CKM_SHA256_RSA_PKCS")) {
                try {
                    hashedData = digester.calculateHash(this.dataToSign, DigestAlgorithm.SHA256);
                }
                catch (Crypto_Exception e) {
                    this.logger.error("Error creating hash value of data to sign", (Throwable)e, 131072);
                    throw new CryptoTI_Exception(131072, "Error creating hash value of data to sign");
                }
                sigRes = ccSession.getSession().createSignatureHash(user.getUserOTP(), hashedData, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA256, AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS1);
            } else if (this.mechanism.equals("CKM_RSA_PKCS")) {
                sigRes = ccSession.getSession().createAuthenticationSignatureHash(user.getUserOTP(), this.dataToSign, AdvancedCSSignatureHandlerInterface.HashAlgorithm.MD5SHA1, AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS1);
            }
            if (digester != null) {
                digester = null;
            }
            if (hashedData != null) {
                hashedData = null;
            }
            if (sigRes.getResultCode() == ResultCodes.OK) {
                this.resetDataToSign();
                return ((SignatureResult)sigRes).getSignature();
            }
            this.resetDataToSign();
            if (sigRes.getResultCode() == ResultCodes.ERROR_INCORRECT_AUTHENTICATION) {
                this.logger.error("The login was incorrect: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 143373);
                throw new CryptoTI_SessionException(143373, "The login was incorrect");
            }
            if (sigRes.getResultCode() == ResultCodes.ERROR_INSUFFICIENT_AUTHENTICATION) {
                this.logger.error("Authentication error. Insufficient privileges for key: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 143360);
                throw new CryptoTI_SessionException(143360, "Authentication error. Insufficient privileges for key");
            }
            if (sigRes.getResultCode() == ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED) {
                this.logger.error("Connection to Signer has not been initialised: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 131072);
                throw new CryptoTI_Exception(131072, "Connection to Signer has not been initialised");
            }
            if (sigRes.getResultCode() == ResultCodes.ERROR_CONNECTION) {
                this.logger.error("A problem connecting to the server occurred: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 131072);
                throw new CryptoTI_Exception(131072, "A problem connecting to the server occurred");
            }
            if (sigRes.getResultCode() == ResultCodes.ERROR_SIGNING_NOT_INITIALISED) {
                this.logger.error("Signing has not been initialised: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 131072);
                throw new CryptoTI_Exception(131072, "Signing has not been initialised");
            }
            if (sigRes.getResultCode() == ResultCodes.ERROR_CREATING_PKCS7_SIGNATURE) {
                this.logger.error("An error occurred while creating PKCS7 signature: " + sigRes.getErrorDescription() + " (" + (Object)((Object)sigRes.getResultCode()) + ")", 131072);
                throw new CryptoTI_Exception(131072, "An error occurred while creating PKCS7 signature");
            }
            return null;
        }
        this.logger.error("An error occurred during signFinal.", 131072);
        throw new CryptoTI_Exception(131072, "An error occurred during signFinal.");
    }

    public boolean signInit(CryptoTI_PrivateKey privateKey, CryptoTI_Session session, CryptoTI_Mechanism mechanism) throws CryptoTI_Exception {
        this.logger.debug("SIGN INIT /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (mechanism == null) {
            this.logger.error("Mechanism cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Mechanism cannot be null");
        }
        this.resetDataToSign();
        this.mechanism = mechanism.getName();
        Result result = this.token.initialiseSigning();
        if (result.getResultCode() == ResultCodes.OK) {
            this.logger.debug("Signing Initialisation complete!");
            return false;
        }
        if (result.getResultCode() == ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED) {
            this.logger.error("Connection to the signing server is not initilalsed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131079);
            throw new CryptoTI_Exception(131079, "Connection to the signing server is not initilalsed");
        }
        if (result.getResultCode() == ResultCodes.ERROR_CONNECTION) {
            this.logger.error("A problem connecting to the server occurred: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131072);
            throw new CryptoTI_Exception(131072, "A problem connecting to the server occurred");
        }
        if (result.getResultCode() == ResultCodes.ERROR_NOT_LOGGED_IN) {
            this.logger.error("Not logged in: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 143373);
            throw new CryptoTI_SessionException(143373, "Not logged in");
        }
        if (result.getResultCode() == ResultCodes.ERROR_SIGNING_IN_PROGRESS) {
            this.logger.error("A signing operation is already in progres: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131072);
            throw new CryptoTI_Exception(131072, "A signing operation is already in progres");
        }
        if (result.getResultCode() == ResultCodes.ERROR_SMS_NOTIFICATION_FAILED) {
            this.logger.error(" The SMS notification failed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 143360);
            throw new CryptoTI_SessionException(143360, " The SMS notification failed");
        }
        return false;
    }

    public int signUpdate(byte[] data, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("SIGN UPDATE /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (data == null) {
            this.logger.error("Data cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Data cannot be null");
        }
        if (!session.isLoggedIn()) {
            this.logger.error("Not Logged In", 143373);
            throw new CryptoTI_SessionException(143373, "User is not logged In");
        }
        int newDataToSignLenght = this.dataToSign.length + data.length;
        byte[] lastDataToSign = this.dataToSign;
        this.dataToSign = new byte[newDataToSignLenght];
        int i = 0;
        while (i < lastDataToSign.length) {
            this.dataToSign[i] = lastDataToSign[i];
            ++i;
        }
        int j = lastDataToSign.length;
        while (j < newDataToSignLenght) {
            this.dataToSign[j] = data[j - lastDataToSign.length];
            ++j;
        }
        this.signUpdateCounter += data.length;
        return this.signUpdateCounter;
    }

    public void terminate() throws CryptoTI_Exception {
        this.logger.debug("TERMINATE /");
        this.resetDataToSign();
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        return this.token.toString();
    }

    public int hashCode() {
        this.logger.debug("HASH CODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dataToSign);
        result = 31 * result + this.signUpdateCounter;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_Token other = (CIC_CTI_Token)obj;
        if (!Arrays.equals(this.dataToSign, other.dataToSign)) {
            return false;
        }
        if (this.signUpdateCounter != other.signUpdateCounter) {
            return false;
        }
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public boolean isAvailable() throws CryptoTI_Exception {
        this.logger.debug("IS AVAILABLE /");
        return this.token != null;
    }

    private void resetDataToSign() {
        this.dataToSign = null;
        this.dataToSign = new byte[0];
        this.signUpdateCounter = 0;
        this.mechanism = null;
    }
}

