/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandler;
import lu.luxtrust.cryptomathic.CIC_CTI_User;
import lu.luxtrust.cryptoti.CryptoTI_Session;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.CryptoTI_User;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.utils.TextUtils;

public class CIC_CTI_Session
implements CryptoTI_Session {
    private Log logger = Logger.getLogger(CIC_CTI_Session.class);
    private AdvancedCSSignatureHandler session = null;
    private CIC_CTI_User user = null;
    private boolean loggedIn = false;
    private String otp = null;
    private String userName = null;
    private boolean checkPWDFormat = false;
    private CryptoTI_Token token = null;

    public CIC_CTI_Session(AdvancedCSSignatureHandler session, CryptoTI_Token token, boolean checkPWDFormat) throws CryptoTI_Exception {
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_SessionException(131075, "Session cannot be null");
        }
        if (token == null) {
            this.logger.error("Token cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Token cannot be null");
        }
        this.token = token;
        this.session = session;
        this.checkPWDFormat = checkPWDFormat;
    }

    public String getHandleID() throws CryptoTI_Exception {
        this.logger.debug("GET HANDLE ID /");
        this.logger.error("Attribute \"Handle\" is not available", 131082);
        throw new CryptoTI_SessionException(131082, "Attribute is not available");
    }

    public CryptoTI_User getUser() throws CryptoTI_Exception {
        this.logger.debug("GET USER /");
        if (this.user == null) {
            this.logger.error("User object is not instantiated", 131082);
            throw new CryptoTI_SessionException(131082, "User object is not instantiated");
        }
        return this.user;
    }

    public boolean isLoggedIn() throws CryptoTI_Exception {
        this.logger.debug("IS LOGGED IN /");
        return this.loggedIn;
    }

    public boolean isPublic() throws CryptoTI_Exception {
        this.logger.debug("IS PUBLIC /");
        return false;
    }

    public boolean isReadOnly() throws CryptoTI_Exception {
        this.logger.debug("IS READONLY /");
        return true;
    }

    public boolean isSecurityOfficer() throws CryptoTI_Exception {
        this.logger.debug("IS SECURITYOFFICER /");
        return false;
    }

    public boolean isUserSession() throws CryptoTI_Exception {
        this.logger.debug("IS USER SESSION /");
        return true;
    }

    public void logOff() throws CryptoTI_Exception {
        this.logger.debug("LOGOFF /");
        this.loggedIn = false;
    }

    public CryptoTI_User login(String userName, char[] password) throws CryptoTI_Exception {
        this.logger.debug("LOGIN /");
        boolean isPasswordConform = true;
        if (!this.loggedIn) {
            this.loggedIn = true;
            this.userName = userName;
            if (this.checkPWDFormat) {
                isPasswordConform = TextUtils.matchRegEx(String.valueOf(password), this.getToken().getInfo().getPINFormat());
            }
            if (!isPasswordConform) {
                this.logger.warn("Password does not match required PWD format: " + this.getToken().getInfo().getPINFormat(), 143369);
                throw new CryptoTI_SessionException(143369, "Password does not match required PWD format");
            }
            this.otp = String.valueOf(password);
            this.user = new CIC_CTI_User(userName, String.valueOf(this.otp));
            return this.user;
        }
        this.logger.error("User is already logged in", 131080);
        throw new CryptoTI_SessionException(131080, "User is already logged in");
    }

    protected AdvancedCSSignatureHandler getSession() {
        this.logger.debug("GET SESSION/");
        return this.session;
    }

    public CryptoTI_Token getToken() throws CryptoTI_Exception {
        this.logger.debug("GET TOKEN /");
        return this.token;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loggedIn ? 1231 : 1237);
        result = 31 * result + (this.otp == null ? 0 : this.otp.hashCode());
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_Session other = (CIC_CTI_Session)obj;
        if (this.loggedIn != other.loggedIn) {
            return false;
        }
        if (this.otp == null ? other.otp != null : !this.otp.equals(other.otp)) {
            return false;
        }
        if (this.session == null ? other.session != null : !this.session.equals(other.session)) {
            return false;
        }
        if (this.token == null ? other.token != null : !this.token.equals(other.token)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        String str = null;
        try {
            str = "isLoggedIn: " + this.loggedIn + "\n" + "isPublic: " + this.isPublic() + "\n" + "isReadOnly: " + this.isReadOnly() + "\n" + "isSecurityOfficer: " + this.isSecurityOfficer() + "\n" + "isUserSession: " + this.isUserSession();
        }
        catch (CryptoTI_Exception e) {
            this.logger.error((Exception)((Object)e), 0);
        }
        return str;
    }
}

