/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import com.cryptomathic.security.RSAPublicKey;
import java.util.Date;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.CryptoTI_PublicKey;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_PublicKey
implements CryptoTI_PublicKey {
    private Log logger = Logger.getLogger(CIC_CTI_PublicKey.class);
    private RSAPublicKey publicKey = null;

    public CIC_CTI_PublicKey(RSAPublicKey publicKey) throws CryptoTI_Exception {
        if (publicKey == null) {
            this.logger.error("Public Key cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Public Key cannot be null");
        }
        this.publicKey = publicKey;
    }

    public byte[] getKeySubject() throws CryptoTI_Exception {
        this.logger.debug("GET KEY SUBJECT /");
        this.logger.warn("Key Subject is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key Subject is not available");
    }

    public Date getEndDate() throws CryptoTI_Exception {
        this.logger.debug("GET END DATE /");
        this.logger.warn("Attribute \"End date\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "End date is not available");
    }

    public byte[] getKeyIdentifier() throws CryptoTI_Exception {
        this.logger.debug("GET KEY IDENTIFIER /");
        this.logger.warn("Attribute \"Key identifier\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key identifier is not available");
    }

    public Date getStartDate() throws CryptoTI_Exception {
        this.logger.debug("GET START DATE /");
        this.logger.warn("Attribute \"Start date\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Start date is not available");
    }

    public String getType() throws CryptoTI_Exception {
        this.logger.debug("GET KEY TYPE /");
        this.logger.warn("Attribute \"Key type\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key type is not available");
    }

    public boolean isLocal() throws CryptoTI_Exception {
        this.logger.debug("GET IS LOCAL /");
        this.logger.warn("Attribute \"Local\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Local is not available");
    }

    public CryptoTI_Mechanism[] listMechanisms() throws CryptoTI_Exception {
        this.logger.debug("GET MECHANISM LIST /");
        this.logger.warn("Mechanism list is not available", 131082);
        throw new CryptoTI_Exception(131082, "Mechanisms list is not available");
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        this.logger.debug("GET ALIAS /");
        this.logger.warn("Alias is not available", 131082);
        throw new CryptoTI_Exception(131082, "Alias is not available");
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        this.logger.debug("GET ENCODED /");
        if (this.publicKey == null) {
            this.logger.warn("PublicKey is not available", 131082);
            throw new CryptoTI_Exception(131082, "PublicKey is not available");
        }
        return this.publicKey.getEncoded();
    }

    public int hashCode() {
        this.logger.debug("HASH CODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_PublicKey other = (CIC_CTI_PublicKey)obj;
        return !(this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey));
    }
}

