/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static int DES_KEY_LENGTH = 8;
    private byte[] _key_material = new byte[DES_KEY_LENGTH];
    private static final byte[][] weak_keys = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 14, 14, 14, 14}, {-32, -32, -32, -32, -15, -15, -15, -15}, {1, -2, 1, -2, 1, -2, 1, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {31, -32, 31, -32, 14, -15, 14, -15}, {-32, 31, -32, 31, -15, 14, -15, 14}, {1, -32, 1, -32, 1, -15, 1, -15}, {-32, 1, -32, 1, -15, 1, -15, 1}, {31, -2, 31, -2, 14, -2, 14, -2}, {-2, 31, -2, 31, -2, 14, -2, 14}, {1, 31, 1, 31, 1, 14, 1, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, -32, -2, -32, -2, -15, -2, -15}};

    public DESKeySpec(byte[] key) throws InvalidKeyException {
        if (key == null || key.length < DES_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        System.arraycopy(key, 0, this._key_material, 0, DES_KEY_LENGTH);
    }

    public DESKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        System.arraycopy(key, offset, this._key_material, 0, DES_KEY_LENGTH);
    }

    public byte[] getKey() {
        byte[] copy_off_key_material = new byte[DES_KEY_LENGTH];
        System.arraycopy(this._key_material, 0, copy_off_key_material, 0, DES_KEY_LENGTH);
        return copy_off_key_material;
    }

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        for (int i = 0; i < DES_KEY_LENGTH; ++i) {
            if (DESKeySpec.haveOddParity(key[i + offset])) continue;
            return false;
        }
        return true;
    }

    public static boolean isWeak(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        int i = 0;
        int j = 0;
        while (i < 16) {
            if (key[j + offset] == weak_keys[i][j]) {
                if (++j != 8) continue;
                return true;
            }
            j = 0;
            ++i;
        }
        return false;
    }

    private static boolean haveOddParity(byte b) {
        int numberOfBits = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) == 1) {
                ++numberOfBits;
            }
            b = (byte)((b & 0xFF) >>> 1);
        }
        return numberOfBits & true;
    }
}

