/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private SecretKeyFactorySpi spi;
    private Provider provider;
    private String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        this.spi = keyFacSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    private static final SecretKeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            SecretKeyFactorySpi keyFact = (SecretKeyFactorySpi)Class.forName(provider.getProperty("SecretKeyFactory." + algorithm)).newInstance();
            return new SecretKeyFactory(keyFact, provider, algorithm);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("No SecretKeyFactory could be found for  algorithm " + algorithm + " for provider " + provider.getName() + " (" + e.getMessage() + ")");
        }
    }

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] prov = Security.getProviders();
        for (int i = 0; i != prov.length; ++i) {
            try {
                return SecretKeyFactory.getInstance(algorithm, prov[i]);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No SecretKeyFactory could be found for algorithm " + algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecretKeyFactory.getInstance(algorithm, prov);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.spi.engineGenerateSecret(keySpec);
    }

    public final KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        return this.spi.engineGetKeySpec(key, keySpec);
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        return this.spi.engineTranslateKey(key);
    }
}

