/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac {
    private MacSpi my_macSpi;
    private Provider my_provider;
    private String my_algorithm;
    private boolean initialised;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.my_macSpi = macSpi;
        this.my_provider = provider;
        this.my_algorithm = algorithm;
        this.initialised = false;
    }

    public final String getAlgorithm() {
        return this.my_algorithm;
    }

    private static final Mac getInstance(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        MacSpi mac_spi;
        String class_name = prov.getProperty("Mac." + algorithm);
        if (class_name == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        try {
            mac_spi = (MacSpi)Class.forName(class_name).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Could not initialise implementation of " + algorithm);
        }
        return new Mac(mac_spi, prov, algorithm);
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] prov = Security.getProviders();
        for (int i = 0; i != prov.length; ++i) {
            try {
                return Mac.getInstance(algorithm, prov[i]);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Provider supports " + algorithm);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("Provider " + provider + " not found");
        }
        return Mac.getInstance(algorithm, prov);
    }

    public final Provider getProvider() {
        return this.my_provider;
    }

    public final int getMacLength() {
        return this.my_macSpi.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.my_macSpi.engineInit(key, null);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException("Implementation of MAC requires algorithm parameters: " + ex.getMessage());
        }
        this.initialised = true;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.my_macSpi.engineInit(key, params);
        this.initialised = true;
    }

    public final void update(byte input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        this.my_macSpi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Input buffer is null.");
        }
        if (input.length > 0) {
            this.my_macSpi.engineUpdate(input, 0, input.length);
        }
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        if (input == null || offset < 0 || len > input.length - offset) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        if (len > 0) {
            this.my_macSpi.engineUpdate(input, offset, len);
        }
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        return this.my_macSpi.engineDoFinal();
    }

    public final void doFinal(byte[] output, int outOffset) throws ShortBufferException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        if (output == null || outOffset < 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        if (output.length - outOffset < this.my_macSpi.engineGetMacLength()) {
            throw new ShortBufferException("Not enough space for MAC");
        }
        byte[] mac = this.my_macSpi.engineDoFinal();
        this.my_macSpi.engineReset();
        System.arraycopy(mac, 0, output, outOffset, mac.length);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC is in illegal state.");
        }
        if (input != null && input.length > 0) {
            this.my_macSpi.engineUpdate(input, 0, input.length);
        }
        byte[] result = this.my_macSpi.engineDoFinal();
        this.my_macSpi.engineReset();
        return result;
    }

    public final void reset() {
        this.my_macSpi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.my_macSpi instanceof Cloneable) {
            return new Mac((MacSpi)this.my_macSpi.clone(), this.my_provider, this.my_algorithm);
        }
        throw new CloneNotSupportedException();
    }
}

