/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    KeyGeneratorSpi my_spi;
    Provider my_provider;
    String my_algorithm;

    protected KeyGenerator(KeyGeneratorSpi spi, Provider provider, String algorithm) {
        this.my_spi = spi;
        this.my_provider = provider;
        this.my_algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.my_algorithm;
    }

    private static final KeyGenerator getInstance(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        KeyGeneratorSpi kg_spi;
        String class_name = prov.getProperty("KeyGenerator." + algorithm);
        if (class_name == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        try {
            kg_spi = (KeyGeneratorSpi)Class.forName(class_name).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Could not initialise class " + class_name);
        }
        return new KeyGenerator(kg_spi, prov, algorithm);
    }

    public static KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] prov = Security.getProviders();
        for (int i = 0; i != prov.length; ++i) {
            try {
                return KeyGenerator.getInstance(algorithm, prov[i]);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Provider supports KeyGenerator." + algorithm);
    }

    public static KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyGenerator.getInstance(algorithm, prov);
    }

    public final Provider getProvider() {
        return this.my_provider;
    }

    public final void init(SecureRandom random) {
        this.my_spi.engineInit(random);
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.init(params, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.my_spi.engineInit(params, random);
    }

    public final void init(int strength) {
        this.my_spi.engineInit(strength, new SecureRandom());
    }

    public final void init(int strength, SecureRandom random) {
        this.my_spi.engineInit(strength, random);
    }

    public SecretKey generateKey() {
        return this.my_spi.engineGenerateKey();
    }
}

