/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private boolean initialised = false;
    private CipherSpi cipherSpi;
    private Provider provider;
    private String transformation;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
    }

    public static final Cipher getInstance(String transformation, Provider prov) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = null;
        CipherSpi spi = null;
        spi = Cipher.getImpl(transformation, prov);
        cipher = new Cipher(spi, prov, transformation);
        return cipher;
    }

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] prov = Security.getProviders();
        for (int i = 0; i != prov.length; ++i) {
            try {
                return Cipher.getInstance(transformation, prov[i]);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("Could not find any Provider supporting " + transformation);
    }

    public static final Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("Could not find the Provider " + provider);
        }
        return Cipher.getInstance(transformation, prov);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public final int getOutputSize(int inputLen) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher is in an Illegal State.");
        }
        return this.cipherSpi.engineGetOutputSize(inputLen);
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        this.cipherSpi.engineInit(opmode, key, new SecureRandom());
        this.initialised = true;
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.cipherSpi.engineInit(opmode, key, random);
        this.initialised = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, new SecureRandom());
        this.initialised = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, random);
        this.initialised = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, new SecureRandom());
        this.initialised = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, random);
        this.initialised = true;
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher is in an Illegal State.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Input buffer is null!");
        }
        if (input.length == 0) {
            return null;
        }
        return this.cipherSpi.engineUpdate(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher is in an Illegal State.");
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        if (inputLen == 0) {
            return null;
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalStateException, ShortBufferException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher is in an Illegal State.");
        }
        if (input == null || output == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        if (input == null || output == null || inputOffset < 0 || outputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        if (input != null) {
            return this.cipherSpi.engineDoFinal(input, 0, input.length);
        }
        throw new IllegalArgumentException("Input is null!");
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        if (inputOffset < 0 || input != null && inputLen > input.length - inputOffset) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        if (output == null || inputOffset < 0 || input != null && inputLen > input.length - inputOffset) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialised) {
            throw new IllegalStateException("Cipher in Illegal State");
        }
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        if (output == null || inputOffset < 0 || outputOffset < 0 || input != null && inputLen > input.length - inputOffset) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    private static CipherSpi getImpl(String transformation, Provider prov) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String my_transformation = transformation;
        String my_algorithm = null;
        String my_mode = null;
        String my_padding = null;
        CipherSpi my_spi = null;
        String class_name = null;
        StringTokenizer st = new StringTokenizer(my_transformation, "/");
        if (st.hasMoreTokens()) {
            my_algorithm = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            my_mode = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            my_padding = st.nextToken();
        }
        if (my_algorithm == null) {
            throw new IllegalArgumentException("Transformation is empty!");
        }
        if (my_mode == null && my_padding != null || my_mode != null && my_padding == null) {
            throw new IllegalArgumentException("Illegal transformation: " + transformation);
        }
        if (my_mode == null) {
            class_name = prov.getProperty("Cipher." + my_algorithm);
            if (class_name == null) {
                throw new NoSuchAlgorithmException("The Provider " + prov.getName() + "does not support Cipher." + my_algorithm);
            }
            try {
                my_spi = (CipherSpi)Class.forName(class_name).newInstance();
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Could not load the class " + class_name + " for the transformation " + transformation);
            }
            return my_spi;
        }
        class_name = prov.getProperty("Cipher." + my_algorithm + "/" + my_mode + "/" + my_padding);
        if (class_name != null) {
            try {
                my_spi = (CipherSpi)Class.forName(class_name).newInstance();
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Could not load the class " + class_name + " for the transformation " + transformation);
            }
            return my_spi;
        }
        class_name = prov.getProperty("Cipher." + my_algorithm + "/" + my_mode);
        if (class_name != null) {
            try {
                my_spi = (CipherSpi)Class.forName(class_name).newInstance();
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Could not load the class " + class_name + " for the transformation " + transformation);
            }
            my_spi.engineSetPadding(my_padding);
            return my_spi;
        }
        class_name = prov.getProperty("Cipher." + my_algorithm + "//" + my_padding);
        if (class_name != null) {
            try {
                my_spi = (CipherSpi)Class.forName(class_name).newInstance();
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Could not load the class " + class_name + " for the transformation " + transformation);
            }
            my_spi.engineSetMode(my_mode);
            return my_spi;
        }
        class_name = prov.getProperty("Cipher." + my_algorithm);
        if (class_name != null) {
            try {
                my_spi = (CipherSpi)Class.forName(class_name).newInstance();
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Could not load the class " + class_name + " for the transformation " + transformation);
            }
            my_spi.engineSetMode(my_mode);
            my_spi.engineSetPadding(my_padding);
            return my_spi;
        }
        throw new NoSuchAlgorithmException("The Provider " + prov.getName() + " does not support " + transformation);
    }
}

